/*
 *	Math functions for <A>GEMatrix
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)xgematmath.cc	2.2	9/18/89
 */

#include "rw/<A>GEMatrix.h"

static const char SCCSid[] = "@(#)xgematmath.cc	2.2 9/18/89";

<A>GEMatrix
transpose(const <A>GEMatrix& m)
{
  register int nr = m.rows();
  register int nc = m.cols();

  <A>GEMatrix temp(nc, nr);

  for(register int irow=0; irow<nr; irow++)temp.col(irow) = m.row(irow);

  return temp;
}

// Inner product --- multiply self by m
<A>GEMatrix
<A>GEMatrix::product(const <A>GEMatrix& m)
{
  assertProduct(m);

  int nr = rows();
  int nc = m.cols();

  <A>GEMatrix temp(nr, nc);

  for(int irow=0; irow<nr; irow++){
    <T>Vec arow = row(irow);
    for(int icol=0; icol<nc; icol++)
      temp(irow,icol) = dot(arow, m.col(icol));
  }

  return temp;
}

<T>Vec
<A>GEMatrix::product(const <T>Vec& v)
{
  assertProduct(v);

  int nr = rows();

  <T>Vec temp(nr);

  for(int irow=0; irow<nr; irow++)
    temp(irow) = dot(row(irow), v);

  return temp;
}
