c   imsl routine name   - vbla=daxpy                                    vbdb0010
c
c-----------------------------------------------------------------------
c
c   computer            - vax/double
c
c   latest revision     - january 1, 1978
c
c   purpose             - compute a constant times a vector plus
c                           a vector, all double precision
c
c   usage               - call daxpy (n,da,dx,incx,dy,incy)
c
c   arguments    n      - length of vectors x and y. (input)
c                da     - double precision scalar. (input)
c                dx     - double precision vector of length
c                           max(n*iabs(incx),1). (input)
c                incx   - displacement between elements of dx. (input)
c                           x(i) is defined to be..
c                           dx(1+(i-1)*incx) if incx.ge.0 or
c                           dx(1+(i-n)*incx) if incx.lt.0.
c                dy     - double precision vector of length
c                           max(n*iabs(incy),1). (input/output)
c                           daxpy replaces y(i) with da*x(i)+y(i) for
c                           i=1,...,n.
c                           x(i) and y(i) refer to specific elements
c                           of dx and dy, respectively. see incx and
c                           incy argument descriptions.
c                incy   - displacement between elements of dy. (input)
c                           y(i) is defined to be..
c                           dy(1+(i-1)*incy) if incy.ge.0 or
c                           dy(1+(i-n)*incy) if incy.lt.0.
c
c   precision/hardware  - double/all
c
c   reqd. imsl routines - none required
c
c   notation            - information on special notation and
c                           conventions is available in the manual
c                           introduction or through imsl routine uhelp
c
c   copyright           - 1978 by imsl, inc. all rights reserved.
c
c   warranty            - imsl warrants only that imsl testing has been
c                           applied to this code. no other warranty,
c                           expressed or implied, is applicable.
c
c-----------------------------------------------------------------------
c
      subroutine daxpy  (n,da,dx,incx,dy,incy)
c
c                                  specifications for arguments
      double precision   dx(1),dy(1),da
      integer            n,incx,incy
c                                  specifications for local variables
      integer            i,iy,m,mp1,ns,ix
c                                  first executable statement
      if (n.le.0.or.da.eq.0.d0) return
      if (incx.eq.incy) if (incx-1) 5,15,35
    5 continue
c                                  code for nonequal or nonpositive
c                                    increments.
      ix = 1
      iy = 1
      if (incx.lt.0) ix = (-n+1)*incx+1
      if (incy.lt.0) iy = (-n+1)*incy+1
      do 10 i=1,n
         dy(iy) = dy(iy)+da*dx(ix)
         ix = ix+incx
         iy = iy+incy
   10 continue
      return
c                                  code for both increments equal to 1
c                                    clean-up loop so remaining vector
c                                    length is a multiple of 4.
   15 m = n-(n/4)*4
      if (m.eq.0) go to 25
      do 20 i=1,m
         dy(i) = dy(i)+da*dx(i)
   20 continue
      if (n.lt.4) return
   25 mp1 = m+1
      do 30 i=mp1,n,4
         dy(i) = dy(i)+da*dx(i)
         dy(i+1) = dy(i+1)+da*dx(i+1)
         dy(i+2) = dy(i+2)+da*dx(i+2)
         dy(i+3) = dy(i+3)+da*dx(i+3)
   30 continue
      return
c                                  code for equal, positive, nonunit
c                                    increments.
   35 continue
      ns = n*incx
      do 40 i=1,ns,incx
         dy(i) = da*dx(i)+dy(i)
   40 continue
      return
      end
