#ifndef TIMER_H
#define TIMER_H
#pragma once

/*
 *	
 *	Written by
 *
 *	Bruce Eckel
 *	School of Oceanography; WB-10
 *	University of Washington
 *	Seattle, WA 98195
 *
 *	@(#)Timer.h	2.2	9/18/89
 */

#include <sys/time.h>
#include <sys/resource.h>
#include <stream.h>
#ifdef __GNUG__
#include <std.h>
#endif
#ifdef __ATT__
#include <string.h>
#endif

/* 
-*++ class timer: measures use of system resources
** 
** (*++ history: 
** 	27 Apr 88	Bruce Eckel	Creation date
** ++*)
** 
** (*++ detailed: Whenever you want to measure a point, use the "mark"
** function.  Everything will be dumped out at the end when you're done. 
** ++*)
*/

struct MarkPoint {
    float seconds;
    char * msg;
    MarkPoint * next;
};

class Timer {
    MarkPoint * head;
    MarkPoint * current;
    void timer_(float * secs);
  public: 
    Timer();
    ~Timer();
    void mark();
    void mark(char * msg);
    friend ostream& operator<<(ostream &, Timer & );  /* send to stream */
};

#endif TIMER_H
