#include <LEDA/list.h>
#include <LEDA/array.h>
#include <LEDA/ugraph.h>

/*

MAKE_SIMPLE 

Preliminary and experimental feature for using arbitrary data types 
as actual type parameters in LEDA "declare" statements. 


Let "T" be an arbitary C++ class with 

a) operator<<(ostream,T)  and operator>>(istream,T&) defined 
b) T has a constructor taking no arguments


then

MAKE_SIMPLE(T)

introduces a new type name "T_simple" which can be used as a substitute for
type "T" in declarations of parameterized LEDA data types. 

Note: T_simple may only be used as actual type parameters inside of LEDA 
      declare macro calls and not as variable or function argument/return 
      type.
*/

class point3
{

  double x,y,z; 

public:

  double xcoord() { return x; }
  double ycoord() { return y; }
  double zcoord() { return z; }

  point3(double a=0, double b=0, double c=0) { x=a; y=b; z=c; }
  point3(const point3& p) { x=p.x; y=p.y; z=p.z; }

  friend ostream& operator<<(ostream& out, const point3& a)
  { return out << a.x << " " << a.y << " " << a.z; }
  
  friend istream& operator>>(istream& in, point3& a) 
  { return in >> a.x >> a.y >> a.z ; }

  LEDA_MEMORY(point3);

};


MAKE_SIMPLE(point3)

declare(list,Simple(point3))

declare(array,Simple(point3))

declare2(UGRAPH,point3_simple,point3_simple)


void main() 
{ 
  point3 p(13,17,19);
  point3 q;
  double x;
  int i=0;

  list(Simple(point3))  L;
  array(Simple(point3)) A(10);

  L.read("L = ");
  L.append(p);

  L.print("L = ");
  newline;

  forall(q,L) A[i++] = q;         // Ignore cfront warning: "temporary used for 
                                  // non-const point3_simple& argument"

  A.print("A = ");
  newline;


  x = L.head()->xcoord();        //L.head().xcoord() -->  error

  x = A[0]->xcoord();            //A[0].xcoord()     -->  error

  p = L.head();

  p = A[0];


  UGRAPH(point3_simple,point3_simple) G;
  test_graph(G);

  G.print();
}
