/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	<notice.h>

/* 10/1/84 - added declaration of calloc() so compiler wouldn't grumble.
						<John Romkey>
*/

#include <stdio.h>
#include <types.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>

/* The pkt_alloc() routine allocates a packet but doesn't enqueue it anywhere
 * it returns a pointer to the packet, or NULL if the allocation failed.
 * this routine does not generate garbage if it fails in allocating memory
 */
extern int LBUF;		/* size of packet buffers */
extern unsigned get_ds();

char *calloc();

PACKET pkt_alloc() {
	register PACKET packet;
	register unsigned physaddr;
	char *tmpbuff;

	if ((packet = (PACKET)calloc(1, sizeof(struct net_buf))) != NULL) {
		packet->nb_tstamp =
		packet->nb_len    = 0;
		packet->nb_buff   = calloc(1, LBUF);

		/* Check if the packet buffer crosses a physical 64K */
		/* boundary causing the DMA controller to explode.  If */
		/* it does, try again */
		physaddr = ((unsigned)packet->nb_buff >> 4) + get_ds();
	
		if(((physaddr + (LBUF>>4)) & 0xF000) > (physaddr & 0xF000)) {
			tmpbuff = packet->nb_buff;	/* remember bad pkt */
			packet->nb_buff = calloc(1, LBUF);
			cfree((char *)tmpbuff);		/* dealloc bad pkt */
		}

		if(packet->nb_buff == NULL) {		/* out of memory ? */
			cfree((char *)packet);		/* clean up header */
			packet = NULL;			/* return error */
		}
	}
	return(packet);	/* Return: don't put the packet on the free queue */
}

pkt_free(packet)
register PACKET packet;
{	cfree((char *)packet->nb_buff); /* free data buffer */
	cfree((char *)packet);		/* free extra info */
}
