typedef	long	time_t;			/* ugly! */

#include <stdio.h>
#include <types.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <timer.h>
#include <ntcp.h>
#include <ntcpblk.h>

TcpCon tcp_grab();

/* The passive open routine.  It listens to the socket given as
 * its first argument, for a connection.  When another host begins to
 * transmit, this routine upcalls the user-open function, and dedicates
 * itself to that port-host combination.  Most applications will probably
 * create another listener to take its place
 */
TcpCon tcp_listen( ls, win, lowwin, pblock)
	unsigned ls;		/* local socket */
	unsigned win;		/* window to advertise */
	unsigned lowwin;	/* low water mark for window */
	int	(*pblock[])();{ /* block of 7 upcall procedures */
	register TcpCon con;	/* connection block being opened  */

	/* first try all the things that could cause failure */
	if (connects >= MAXCONS) return(0);
	if (tcp_is_port(ls)){
		printf("TCP_PASSIVE_OPEN:port %d already in use\n",ls);
		return(0);
	}
	if (!(con = tcp_grab(pblock,win,lowwin))) return(0);
	con->otp->tc_srcp	= con->srcport	= ls;
	con->otp->tc_dstp	= con->dstport	= 0;
	con->otp->tc_fack	= 1;
	con->ophp.tp_dst	= con->fhost	= 
	con->ophp.tp_src	= (in_name) 0L;
	con->conn_state		= LISTEN;
	return(con);
}


/* Actively open a tcp connection to foreign host fh on foreign socket
 * fs using local socket ls.  Returns FALSE if unable to open an internet
 * connection with the specified hosts and sockets, or TRUE otherwise.
 * This routine doesn't wait until the connection is actually opened before
 * returning.  Instead, the user open function
 * is upcalled when the connection is successfully opened.  This routine
 * also sets a timer to call the user timeout routine on ICP timeout.
 */

TcpCon tcp_open(fh, fs, ls, win, lowwin, pblock)
	in_name	 fh;		/* foreign host address */
	unsigned fs;		/* foreign socket */
	unsigned ls;		/* local socket */
	unsigned win;		/* window to advertise */
	unsigned lowwin;	/* low water mark for window */
	int	(*pblock[])();{ /* block upcall procedures */
	register TcpCon con;	/* connection block being opened  */

	/* first try all the things that could cause failure */
	if (connects >= MAXCONS) {
		printf("TCP_OPEN: Too many connections(%d)\n",connects);
		return(0);
	}
	if (ls == 0) ls = tcp_gen_socket();	/* Wants us to pick socket  */
	else if (tcp_is_socket(ls,fh)){
		printf("TCP_OPEN:port %d to machine %d already in use\n",ls,fh);
		return(0);
	}
	if (!(con = tcp_grab(pblock,win,lowwin))) return(0);
	con->otp->tc_srcp	= con->srcport	= ls;
	con->otp->tc_dstp	= con->dstport	= fs;
	con->ophp.tp_dst	= con->fhost	= fh;
	con->ophp.tp_src	= in_mymach(fh);
	con->conn_state		= SYNSENT;
	tcp_newdata(con);	/* retransmit the syn */
	return(con);
}


PACKET pkt_alloc();
int tcp_process();
/* This INTERNAL procedure grabs new objects from all the structures used
 * for a connection.  If any of these allocations fail, it returns FALSE.
 * It allocates a packet buffer, 2 timers, the memory for a connection, clips
 * the TCP window if necessary and does an absurd amount of initialization.
 */
static TcpCon tcp_grab(pblock,win,lowwin)
	unsigned win;		/* window to advertise */
	unsigned lowwin;	/* low water mark for window */
	int	(*pblock[])();{ /* block of upcall procedures */
	timer	*Ttimer1;	/* temporaries in case the connection */
	timer	*Ttimer2;	/* is not successfully opened */
	PACKET	Tpacket;
	register TcpCon con;
	int	i;
	char	*j;

	if((Ttimer1 = tm_alloc()) == 0) {
#ifdef DEBUG
		if(TCDBG) printf("TCP_OPEN: Couldn't alloc resend timer\n");
#endif
		goto tm1abort;
	}

	if((Ttimer2 = tm_alloc()) == 0) {
#ifdef DEBUG
		if (TCDBG)printf("TCP_OPEN: Couldn't alloc dally timer\n");
#endif
		goto tm2abort;
	}
	if (!(Tpacket = pkt_alloc())) {
#ifdef	DEBUG
		if (TCDBG) printf("TCP_OPEN: Could not get a packet.\n");
#endif
		goto pktabort;
	}
	ip_init(Tpacket,MAXBUF+1, 0);	/* initialize part of IP header */

	if (OutOfBounds(win,1,TCPMAXWIND) | OutOfBounds(lowwin,1,TCPLOWIND)){
		win = TCPWINDOW;
		lowwin = TCPLOWIND;
	}
	/* COMMIT POINT */
	/* allocate a connection block and output pseudo hdr */
	if (!(con = (TcpCon) calloc(1, sizeof(tcp_con)))) goto conabort;
	conlist[connects++] = con;
	con->loc_win	= win;
	con->loc_lowwater = lowwin;
	con->tcptm	= Ttimer1;
	con->tmack	= Ttimer2;
	con->opbi	= Tpacket;

	con->tc_open 	= pblock[0];		/* save user fcn addresses */
	con->tc_timeout	= pblock[1];
	con->tc_dispose = pblock[2];
	con->tc_buff	= pblock[3];
	con->tc_fclose	= pblock[4];
	con->tc_close	= pblock[5];
	con->retry_time = INITRT;
	con->ack_dally  = ACKDALLY;	/* initial # ticks between acks */
	con->SendReason	= NOREASON;
	con->blk_inpt	= BLOCKED;
	con->otp 	= (struct tcp *)in_data(in_head(con->opbi));
	con->bptr	= 
	con->odp	= (char *)con->otp + sizeof(struct tcp);
	con->taken	=
	con->avail	= -1;
	con->numchunks	=
	con->maxchunks	=
	con->ack_time	=
	con->tw_to_live =
	con->odlen	= 0;		/* no output data yet */
	con->usafe	= FALSE;	/* type safety for get_ufield */
	for(i = 0; i < TOTALCHUNKS; i++) (con->free)[i] = TRUE;

	/* start send and data upcall processes */
	con->TCPsend = tk_fork(tk_cur, tcp_send, TCPSTACK, "TCPsend", (unsigned) con);
	if (!(con->TCPsend)) goto procabort;
	con->TCPprocess = tk_fork(tk_cur,tcp_process, TCPSTACK, "TCPprocess", (unsigned) con);
	if (!(con->TCPprocess)) goto procabort2;

	tk_sleep(con->TCPsend);
	tk_sleep(con->TCPprocess);
	/* set up psuedoheader for outgoing packet */
	con->ophp.tp_zero = 0;
	con->ophp.tp_pro  = TCPPROT;

	/* set up the output packet: first, zero the whole tcp header: */
	for(j = (char *) con->otp,i = sizeof(struct tcp); i--; *(j++) = 0);

	con->otp->tc_thl = sizeof(struct tcp) >> 2; /* fill in output tcp hdr */
	con->otp->tc_syn = 1;
	con->otp->tc_win = win;
	return(con);
	
	/* labels for abort situations */
procabort2:	tk_kill(con->TCPsend);
procabort:	cfree((char *)con);
conabort:	pkt_free(con->opbi);	/* deallocate output packet */
pktabort:	tm_free(Ttimer2);	/* deallocate second timer */
tm2abort:	tm_free(Ttimer1);	/* deallocate first timter */
tm1abort:	printf("FAILED");
		return(NULL);
}
