/*
 * Copyright (c) 1991 David I. Bell
 * Permission is granted to use, distribute, or modify this source,
 * provided that this copyright notice remains intact.
 *
 * Main module of graphics server.
 */
#include <stdio.h>
#include "graph_serv.h"


/*
 * External definitions defined here.
 */
char *		curfunc;		/* current function name */
GR_WINDOW_ID	cachewindowid;		/* cached window id */
GR_GC_ID	cachegcid;		/* cached graphics context id */
GR_WINDOW	*cachewp;		/* cached window pointer */
GR_GC		*cachegcp;		/* cached graphics context */
GR_WINDOW	*listwp;		/* list of all windows */
GR_WINDOW	*rootwp;		/* root window pointer */
GR_GC		*listgcp;		/* list of all gc */
GR_GC		*curgcp;		/* currently enabled gc */
GR_WINDOW	*clipwp;		/* window clipping is set for */
GR_WINDOW	*focuswp;		/* focus window for keyboard */
GR_WINDOW	*mousewp;		/* window mouse is currently in */
GR_WINDOW	*grabbuttonwp;		/* window grabbed by button */
GR_CURSOR	*curcursor;		/* currently enabled cursor */
GR_COORD	cursorx;		/* current x position of cursor */
GR_COORD	cursory;		/* current y position of cursor */
GR_BUTTON	curbuttons;		/* current state of buttons */
GR_CLIENT	*curclient;		/* client currently executing for */
GR_EVENT_LIST	*eventfree;		/* list of free events */
GR_EVENT_NUMBER	eventnumber;		/* current event number */
GR_BOOL		inited;			/* TRUE if been initialized */
GR_BOOL		focusfixed;		/* TRUE if focus is fixed on a window */
GR_SCREEN_INFO	sinfo;			/* screen information */
GR_FONT_INFO	curfont;		/* current font information */
GR_CLIENT	clients[GR_MAX_CLIENTS];	/* table of clients */


static	int	connectcount;		/* number of connections to server */


/*
 * When the server is a separate process from the client,
 * then this main would be executed, and would drive the whole
 * server loop.
 */
#if 0
main(argc, argv)
	char	**argv;
{
	if (GsInitialize())
		exit(1);

	/* read initialization file to start up default clients */

	/* let clients connect and service them until all are gone */

	GsTerminate();
}
#endif


/*
 * Initialize the graphics and mouse devices at startup.
 * Returns nonzero with a message printed if the initialization failed.
 */
int
GsInitialize()
{
	GR_WINDOW	*wp;		/* root window */
	GR_CURSOR	*cp;		/* cursor for root window */

	if (connectcount > 0) {
		connectcount++;
		return 0;
	}

	wp = (GR_WINDOW *) malloc(sizeof(GR_WINDOW));
	if (wp == NULL) {
		fprintf(stderr, "Cannot allocate root window\n");
		return -1;
	}

	cp = (GR_CURSOR *) malloc(sizeof(GR_CURSOR));
	if (cp == NULL) {
		fprintf(stderr, "Cannot allocate cursor\n");
		return -1;
	}

	if (GsOpenMouse() < 0) {
		fprintf(stderr, "Cannot initialize mouse: ");
		perror("");
		free(wp);
		free(cp);
		return -1;
	}

	if (GsOpenKeyboard() < 0) {
		fprintf(stderr, "Cannot initialize keyboard: ");
		perror("");
		GsCloseMouse();
		free(wp);
		free(cp);
		return -1;
	}

	if (GdOpenScreen(0, 0, 0) < 0) {
		fprintf(stderr, "Cannot initialize screen: ");
		perror("");
		GsCloseMouse();
		GsCloseKeyboard();
		free(wp);
		free(cp);
		return -1;
	}

	/*
	 * Get screen dimensions for our own and the client's use,
	 * and the information about the default font.
	 */
	GdGetScreenInfo(&sinfo);
	GdGetFontInfo(0, &curfont);
	GsGetModifierInfo(&sinfo.modifiers);
	GsGetButtonInfo(&sinfo.buttons);

	/*
	 * Initialize the default cursor.
	 */
	cp->usecount = 1;
	cp->foreground = sinfo.white;
	cp->background = sinfo.black;
	cp->width = 5;
	cp->height = 5;
	cp->hotx = 2;
	cp->hoty = 2;
	cp->fgbitmap[0] = 0x8800;	/* X---X */
	cp->fgbitmap[1] = 0x5000;	/* -X-X- */
	cp->fgbitmap[2] = 0x2000;	/* --X-- */
	cp->fgbitmap[3] = 0x5000;	/* -X-X- */
	cp->fgbitmap[4] = 0x8800;	/* X---X */

	cp->bgbitmap[0] = 0xd800;	/* XX-XX */
	cp->bgbitmap[1] = 0xf800;	/* XXXXX */
	cp->bgbitmap[2] = 0x7000;	/* -XXX- */
	cp->bgbitmap[3] = 0xf800;	/* XXXXX */
	cp->bgbitmap[4] = 0xd800;	/* XX-XX */

	curcursor = NULL;
	cursorx = -1;
	cursory = -1;

	/*
	 * Initialize the root window.
	 */
	wp->id = GR_ROOT_WINDOW_ID;
	wp->parent = wp;
	wp->children = NULL;
	wp->siblings = NULL;
	wp->next = NULL;
	wp->x = 0;
	wp->y = 0;
	wp->width = sinfo.cols;
	wp->height = sinfo.rows;
	wp->bordersize = 0;
	wp->background = sinfo.black;
	wp->bordercolor = sinfo.black;
	wp->nopropmask = 0;
	wp->eventclients = NULL;
	wp->cursor = cp;
	wp->mapped = GR_TRUE;
	wp->unmapcount = 0;
	wp->output = GR_TRUE;
	listwp = wp;
	rootwp = wp;
	focuswp = wp;
	mousewp = wp;
	focusfixed = GR_FALSE;

	/*
	 * Finally tell the mouse driver some things and tell the
	 * screen driver where the cursor should go.
	 */
	curbuttons = 0;
	GsSetAccelMouse(5, 3);
	GsRestrictMouse(0, 0, sinfo.cols - 1, sinfo.rows - 1);
	GsMoveMouse(sinfo.cols / 2, sinfo.rows / 2);
	GsMoveCursor(sinfo.cols / 2, sinfo.rows / 2);
	GsFlush();

	/*
	 * All done.
	 */
	connectcount = 1;
	inited = GR_TRUE;

	return 0;
}


/*
 * Here to close down the server.
 */
void
GsTerminate()
{
	if (--connectcount == 0) {
		GdCloseScreen();
		GsCloseMouse();
		GsCloseKeyboard();
		inited = GR_FALSE;
	}
}

/* END CODE */
