#if ACK
# Makefile for kernel using standard Minix directory layout and compiler.
# CPP may need changing to /usr/lib/cpp.
# The following nonstandard flags are used:
# -F:	run cpp and cem sequentially (used when memory is tight)
# -T.:	put temporaries in working directory (when RAM disk is small)
#	define	O	s
BIN		=.
CC		=cc
CFLAGS		=-F -T.
CPP		=/usr/lib/cpp
CPPFLAGS	=-DASLD -P
END		=/usr/lib/end.s
LD		=asld
LDFLAGS		=-i
LIBS		=/usr/lib/libc.a
START		=start.O
#else
# Makefile for kernel using Bruce's Minix directory layout and compiler.
# The following nonstandard flags are used:
# -0:	produce 16-bit (8086) object code
# -3:	produce 32-bit (80386) object code
#	define	O	o
#	if INTEL_32BITS
AS		=as -3
BIN		=/etc/system
CC		=cc -3
CFLAGS		=-DINTEL_32BITS
CPP		=/usr/lib/cpp
CPPFLAGS	=-DINTEL_32BITS -P
LD		=ld -3
LDFLAGS		=-i
LIBS		=/usr/local/lib/i386/libc.a longlib.a
START		=start.O
#	else
AS		=as -0 -a
BIN		=/tmp
CC		=cc -0
CFLAGS		=
CPP		=/usr/lib/cpp
CPPFLAGS	=-P
LD		=ld -0
LDFLAGS		=-i
LIBS		=/usr/local/lib/i86/libc.a
START		=start.O
#	endif
#endif

a		=kernel.h $h/config.h $h/const.h $h/type.h \
		 $s/types.h $i/limits.h $i/errno.h \
		 const.h type.h proto.h glo.h
h		=/usr/include/minix
i		=/usr/include
s		=/usr/include/sys

KEROBJS		=cstart.O protect.O protect1.O klib.O mpx.O wini.O \
	table.O main.O tty.O floppy.O system.O proc.O \
	clock.O memory.O console.O rs232.O rs2.O printer.O \
	dmp.O exception.O i8259.O misc.O keyboard.O \
	graphics.O graph_main.O graph_gen.O graph_clip.O cursor_gen.O \
	graph_ega.O ega.O

SOBJS		=start.s klib.s mpx.s rs2.s ega.s

# Rules.
.SUFFIXES: .x		# .x files are .s files which need C-preprocessing
.x.s:
	$(CPP) $(CPPFLAGS) $< >$@
#if !ACK
.s.O:
	$(AS) $< -o $@
.x.O:
	$(CPP) $(CPPFLAGS) $< >$@
	$(AS) $< -o $@
#endif

# What to make.
dummy: $(BIN)/kernel	# this line fixes a bug in RAL's latest make

$(BIN)/kernel: $(START) $(KEROBJS) $(LIBS) $(END)
#if ACK
	$(LD) $(LDFLAGS) -o $(BIN)/kernel \
	$(START) $(KEROBJS) \
	$(LIBS) $(END) -s > kernel.sym
	ast -X $(BIN)/kernel kernel.sym
	@rm kernel.sym
#else
	$(LD) $(LDFLAGS) -o $(BIN)/kernel \
	$(START) $(KEROBJS) \
	$(LIBS) $(END)
#endif

clean:
#if ACK
	@rm -f $(START) $(KEROBJS) $(SOBJS)
#else
	rm -f $(START) $(KEROBJS) $(SOBJS)
#endif

klib.s: $h/config.h $h/const.h const.h protect.h sconst.h klib.x
mpx.s: $h/config.h $h/const.h $h/com.h const.h protect.h sconst.h mpx.x
rs2.s: $h/config.h $h/const.h const.h sconst.h rs2.x
start.s: $h/config.h $h/const.h $h/com.h const.h protect.h sconst.h start.x
ega.s: $h/config.h $h/const.h $h/com.h const.h protect.h sconst.h ega.x
#if !ACK
start.O: start.s
	$(AS) -0 -a start.s -o start.O
#endif

clock.O:	$a
clock.O:	$i/signal.h
clock.O:	$h/callnr.h
clock.O:	$h/com.h
clock.O:	proc.h

console.O:	$a
console.O:	$i/sgtty.h
console.O:	$h/callnr.h
console.O:	$h/com.h
console.O:	protect.h
console.O:	tty.h

cstart.O:	$a
cstart.O:	$h/boot.h
cstart.O:	cstart.c
#if INTEL_32BITS
	bcc -0 -c $(CFLAGS) cstart.c
#endif

cursor_gen.O:	$a
cursor_gen.O:	$i/graphics.h
cursor_gen.O:	$h/graph_msg.h
cursor_gen.O:	graph_dev.h

dmp.O:		$a
dmp.O:		$h/callnr.h
dmp.O:		$h/com.h
dmp.O:		proc.h

exception.O:	$a
exception.O:	$i/signal.h
exception.O:	proc.h

floppy.O:	$a
floppy.O:	$h/callnr.h
floppy.O:	$h/com.h

graphics.O:	$a
graphics.O:	$i/graphics.h
graphics.O:	$h/graph_msg.h
graphics.O:	graph_dev.h

graph_clip.O:	$a
graph_clip.O:	$i/graphics.h
graph_clip.O:	graph_dev.h

graph_ega.O:	$a
graph_ega.O:	$i/graphics.h
graph_ega.O:	graph_dev.h

graph_gen.O:	$a
graph_gen.O:	$i/graphics.h
graph_gen.O:	graph_dev.h

graph_main.O:	$a
graph_main.O:	$i/graphics.h
graph_main.O:	graph_dev.h

i8259.O:	$a

keyboard.O:	$a
keyboard.O:	$i/sgtty.h
keyboard.O:	$i/signal.h
keyboard.O:	$h/callnr.h
keyboard.O:	$h/com.h
keyboard.O:	tty.h

main.O:	$a
main.O:	$i/signal.h
main.O:	$h/callnr.h
main.O:	$h/com.h
main.O:	proc.h

memory.O:	$a
memory.O:	$h/callnr.h
memory.O:	$h/com.h

misc.O:	$a
misc.O:	$h/com.h

printer.O:	$a
printer.O:	$h/callnr.h
printer.O:	$h/com.h

proc.O:	$a
proc.O:	$h/callnr.h
proc.O:	$h/com.h
proc.O:	proc.h

protect.O:	$a
protect.O:	protect.h
protect.O:	protect1.c
#if INTEL_32BITS
protect.O:	protect.c
	bcc -0 -c $(CFLAGS) protect.c
#endif

protect1.O:	$a
protect1.O:	proc.h
protect1.O:	protect.h

rs232.O:	$a
rs232.O:	$i/sgtty.h
rs232.O:	tty.h

system.O:	$a
system.O:	$i/signal.h
system.O:	$h/boot.h
system.O:	$h/callnr.h
system.O:	$h/com.h
system.O:	proc.h
system.O:	protect.h

table.O:	$a
table.O:	$h/com.h
table.O:	proc.h
table.O:	tty.h

tty.O:		$a
tty.O:		$i/sgtty.h
tty.O:		$i/signal.h
tty.O:		$h/callnr.h
tty.O:		$h/com.h
tty.O:		tty.h

wini.O:	$a
wini.O:	$h/callnr.h
wini.O:	$h/com.h
wini.O:	$h/partition.h
#if ACK /* two gratuitous blank lines :-( */


#endif
