/*****************************************************************
 |  ndb - build Name DataBase
 |----------------------------------------------------------------
 |  takes data from a raw listing of names, phone numbers, room
 |  numbers, etc and builds an index by name. Name is in upper
 |  case, in the first 26 columns. The index points into the
 |  original text file.
 ****************************************************************/
 
#include <stdio.h>
#include "bplus.h"
#define EOS     ((unsigned char) 0)

IX_DESC namesfile;
ENTRY index;
FILE *namedata, *fopen();

main() {
    int status, n, nnames;
    int names_count = 0, keys_count = 0;
    long ftell();
    char namebuf[132], names[6][30];

    status = make_index("phdata.idx", &namesfile, 1);
    if (status != IX_OK) {
        printf("Can't create 'phdata.idx' file\n");
        exit(1);
    }
    namedata = fopen("phdata", "r");
    if (namedata == NULL) {
        printf("Can't find 'phdata' file\n");
        exit(1);
    }

    /* read loop */
    while (index.recptr = ftell(namedata),
        fgets(namebuf, 132, namedata) != NULL)
    {        
        namebuf[26] = EOS;
        ++names_count;
        nnames = sscanf(namebuf, "%s%s%s%s%s%s",
            names[0], names[1], names[2],
            names[3], names[4], names[5]);
        for (n=0; n<nnames; ++n) {
            if (strlen(names[n]) < 2) continue;
            ++keys_count;
            clearkey(&index);
            strcpy(index.key, names[n]);
            status = add_key(&index, &namesfile);
            if (status != IX_OK) {
                printf("Bad status on add of key '%s'\n", names[n]);
                close_index(&namesfile);
                exit(1);
            }
        }
    }

    /* wrapup */
    printf("Build complete, %d names, %d keys\n",
        names_count, keys_count);
    close_index(&namesfile);
    fclose(namedata);
}
