/*****************************************************************
 |  lookup - lookup a name in the names data base
 |----------------------------------------------------------------
 |  finds all occurrences of the name(s) on the command line and
 |  displays the matching records from the original text file.
 |  Locates records with name fields starting with the string
 |  argument. "lookup j" finds all records with a first or last
 |  name starting with j.
 ****************************************************************/

#include <stdio.h>
#include <ctype.h>
#include "bplus.h"

IX_DESC namesfile;
ENTRY index;
FILE *namedata, *fopen();

main(argc, argv)
int argc;
char *argv[];
{
    int n, status, keylen;
    char uckey[MAXKEY];
    int ch, chindex;

    status = open_index("phdata.idx", &namesfile, 1);
    namedata = fopen("phdata", "r");
    
    for (n = 1; n < argc; ++n) {
        for (chindex = 0; ch = argv[n][chindex]; ++chindex) {
            if (islower(ch)) ch = toupper(ch);
            uckey[chindex] = ch;
        }
        
        clearkey(&index);
        strcpy(index.key, uckey);
        status = locate_key(&index, &namesfile);
        if (status == EOIX) continue;
        keylen = strlen(uckey);
        
        dumprec(index.recptr);
        while (next_key(&index, &namesfile) == IX_OK &&
            (strncmp(index.key, uckey, keylen) == 0))
        {
            dumprec(index.recptr);
        }
    }

    close_index(&namesfile);
}

dumprec(seekloc)
long seekloc;
{
    char line[132];
    
    fseek(namedata, seekloc, 0);
    fgets(line, 132, namedata);
    fputs(line, stdout);
}
