|  mini boot loader:
|	MINIX 1.5 Hard Disk BootUp utility for the IBM PC/AT & compatibles
|							Auther: takamiti@mix

#define		retf	.byte 0xCB

NULL		= 0x00
CR		= 0x0D
LF		= 0x0A

LOADSEG		= 0x0060

DISKBIOS	= 0x13
KEYBIOS		= 0x16
CRTBIOS		= 0x10
BLOCKSIZE	= 1024
READBLOCK	= 0x0202
IPLMAGIC	= 0xAA55
OLD_MINIX	= 0x41

open_msg	= 1026

KEYBUFF		= 0
DISKBUF		= 1024
INODETBL	= DISKBUF  + BLOCKSIZE
STACK		= INODETBL + BLOCKSIZE
STACKTOP	= STACK    + BLOCKSIZE - 8
MENU_DS		= 1530
INODESIZE	= 32
SUPERMAGIC	= 0x1008

|	struct SuperBlock
NR_INODE	= 0
NR_ZONE		= 2
IBIT_MAP	= 4
ZBIT_MAP	= 6
FIRSTDATA	= 8
LOG2		= 10
MAXFIEL		= 12
MAGIC		= 14

|	struct InodeEntry
MODE		= 0
UID		= 2
SIZE_L		= 4
SIZE_H		= 6
DATE		= 8
LINK		= 12
GID		= 13
ZONE0		= 14
ZONE1		= 16
ZONE7		= 28
ZONE8		= 30

|	struct DirEntry
INODE		= 0
NAME		= 2

.globl begtext, begdata, begbss, endtext, enddata, endbss  | asld needs these

.text
begtext:

.data
begdata:

.bss
begbss:

.text

#ifndef ASLD
entry	crtso
#endif

|	HD preBoot loader
crtso:		mov	dx,(si)
		orb	dl,*0x80
		mov	cx,2(si)
		int	0x12
		shr	ax,*1
		shr	ax,*1
		dec	ax
		xchgb	al,ah
		mov	es,ax
		mov	ax,#READBLOCK
		xor	bx,bx
		int	DISKBIOS
		jc	booterr
		push	es
		mov	ax,#start
		push	ax
		retf

booterr:	push	ax
		call	error


hex2:		push	ax
		movb	cl,*4
		shrb	al,cl
		call	hex1
		pop	ax
hex1:		and	ax,#0x000F
		addb	al,*0x30	| '0'
		cmpb	al,*0x3A	| '9'+1
		jc	hex0
		addb	al,*7
hex0:		call	putch
		ret

putstr:		lodb
		orb	al,al
		jz	ext_putc
		call	putch
		j	putstr
putBS:		call	putch
		movb	al,*0x20
		call	putch
		movb	al,*8
putch:		push	bx
		movb	ah,*14
		mov	bx,#1
		int	CRTBIOS
		pop	bx
ext_putc:	ret

error:		mov	si,#Fatal
		call	putstr
		xor	bp,bp
dump:		pop	ax
		push	ax
		movb	al,ah
		call	hex2
		pop	ax
		call	hex2
		movb	al,*0x20
		call	putch
		inc	bp
		cmp	bp,*4
		jc	dump
_reboot:	mov	si,#ReBootMsg
		call	putstr
		xor	ax,ax
		int	KEYBIOS
		int	0x19

Fatal:		.byte	CR, LF
		.ascii	"Fatal Err "
		.byte	NULL
ReBootMsg:	.byte	CR, LF
		.ascii	"Hit any key to reboot."
		.byte	NULL


|****************************************************************************
|			Start HD-boot procedure
|****************************************************************************
start:		cli
		mov	ax,cs
		mov	es,ax
		mov	ss,ax			| cs = ds = es = ss
		mov     sp,#STACKTOP		| initialize sp
		sti
		cld

		mov	di,si
		mov	cx,#4
_loop1:		add	di,*16
		cmp	(di),#IPLMAGIC
		jz	getparam
		loop	_loop1
		call	error

getparam:	mov	dx,(si)			| dirve number
		mov	ax,8(si)
		mov	bx,10(si)
|		movb	ch,4(si)		| SysID
		push	cs
		pop	ds
		movb	partition,cl
		orb	dl,*0x80
		movb	drive,dl
		mov	offset_L,ax
		mov	offset_H,bx
		movb	ah,*8			| get drive parameter
		int	DISKBIOS
		incb	dh			| heads
		andb	cl,*0x3F
		movb	trk_size,cl		| sectors / track
		xchg	ax,cx
		mulb	dh
		mov	cyl_size,ax		| sectors / cylinder

|	read SuperBlock from "root" partition
		mov	bp,#DISKBUF
		mov	ax,#1
		call	HD_read
		cmp	MAGIC(bp),#SUPERMAGIC
		jz	normal_fs
		mov	si,#WrongFS
reboot:		call	putstr
		jmp	_reboot

normal_fs:	mov	ax,IBIT_MAP(bp)
		add	ax,ZBIT_MAP(bp)
		add	ax,*2			| i-node start address
		mov	inode_start,ax

|	check shift key
		movb	ah,*2
		int	KEYBIOS
		andb	al,*3
		jnz	prompt

|	search "/system/minix.sys"
		call	se_img1
		or	ax,ax
		jz	prompt
		jmp	read_img

|	read image file name from KBD
prompt:		mov	ax,#2
		int 	CRTBIOS			| set screen mode
		mov	ax,#0x0200
		xor	dx,dx
		xor	bx,bx
		int	CRTBIOS			| HOME
		mov	si,#Prompt
		call	putstr

		xor	bx,bx
		mov	si,#KEYBUFF
keyin:		xorb	ah,ah
		int	KEYBIOS
		xorb	ah,ah
		cmpb	al,*0x21
		jc	ctrl_code
		cmpb	al,*0x7f
		jnc	keyin
		cmp	bx,#13
		jnc	keyin
#ifdef ASLD
		movb	(bx_si),al
#else
		movb	(bx+si),al
#endif
		inc	bx
		call	putch
		j	keyin

ctrl_code:	cmpb	al,*0x0D
		jz	decide
		cmpb	al,*0x08
		jnz	keyin
		or	bx,bx
		jz	keyin
		dec	bx
		call	putBS
		j	keyin

decide:		or	bx,bx
		jz	def_name
		mov	di,#Minix_sys
		mov	cx,bx
		rep
		movb
		movb	(di),*0
		call	init_ind_tbl		| search /xxxxx
		call	se_img2
		or	ax,ax
		jnz	read_img		| if not exist
def_name:	call	se_img1			| 	search /system/xxxxxx
		or	ax,ax
		jnz	read_img
		mov	si,#NoFile		| file not found
		jmp	reboot

|	load boot image to memory
read_img:	mov	bx,ax
		push	bx			| save i-node
		mov	ax,ZONE0(bx)
		mov	bp,#DISKBUF
		call	HD_read
		mov	ax,504(bp)
		inc	ax
		shr	ax,*1
		mov	last_block,ax
		cmp	(bp),#0x02EB
		jz	prn_open
my_open:	mov	si,#MyOpenMsg
		call	putstr
		movb	tracksize,*15
		j	move_blok

prn_open:	cmp	2(bp),#500
		jnc	my_open
|	display opening messege
		add	open_msg,bp
		push	ds
		mov	ax,ds
		add	ax,#0x40
		mov	ds,ax
		seg	cs
		call	@open_msg
		pop	ds

|	move block
move_blok:	mov	si,#MENU_DS
		mov	di,#menu_ds
		mov	cx,#3
		rep
		movw
		push	es
		mov	ax,#LOADSEG
		mov	es,ax
		xor	di,di
		mov	si,#DISKBUF + 512
		mov	cx,#256
		rep
		movw
		pop	es
|
		pop	si			| i-node
		lea	si,ZONE1(si)
		mov	di,#DISKBUF - 12
		mov	cx,#6
		rep
		movw
|
		lodw				| ZONE 7
		push	ax
		lodw				| ZONE 8
		or	ax,ax
		jz	rd_zone7
		mov	bp,#INODETBL
		call	HD_read
rd_zone7:	pop	ax
		mov	bp,#DISKBUF
		call	HD_read

		mov	ax,#LOADSEG + 0x0020	| LOADSEG + 512
		mov	es,ax
		xor	bp,bp
		xor	di,di
		mov	si,#DISKBUF - 12

|	Load the operating system from HD
loading:	lodw
		or	ax,ax
		jz	finish
		call	HD_read
		mov	ax,es
		add	ax,*0x40		| 1024 byte/block
		mov	es,ax
		cmp	si,#INODETBL
		jnz	chk_end
		mov	si,zone8rp
		lodw
		mov	zone8rp,si
		or	ax,ax
		jz	finish
		push	es
		push	bp
		mov	bp,#DISKBUF
		push	ds
		pop	es
		call	HD_read
		mov	si,bp
		pop	bp
		pop	es
chk_end:	inc	di
		cmp	di,last_block
		jc	loading

| Loading done.  Finish up.
finish:		cli
		mov	bx,tracksize
		or	bx,bx
		jnz	j_menu
		mov	bx,drive	| bh = boot partition number
					| bl = boot drive number
j_menu:		mov	ax,menu_ds
		mov	ds,ax
		mov	es,ax
		mov	ss,ax
		seg	cs
		jmpi	@menu_pc


|	ax = int  zone number	-->	Return:
|	si = char *filename			ax = i-node number
search:		mov	bp,#DISKBUF
		call	HD_read
		mov	bx,bp
		xor	bp,bp
se_file:	cmp	(bx),#0			| INODE(bx),#0
		jz	next2
		push	si
		mov	di,bx
		add	di,*2
		movb	dl,*14
cmpstr:		cmpb
		jnz	next1
		decb	dl	
		cmpb	(si),*0
		jne	cmpstr
		orb	dl,dl
		jz	chk_fmode
		cmpb	(di),*0
		jz	chk_fmode
next1:		pop	si
next2:		add	bx,*16
		inc	bp
		cmp	bp,#64
		jnz	se_file
no_file:	xor	ax,ax
		ret

chk_fmode:	pop	si			| check filemode
		sub	si,*2
		mov	ax,(bx)
		call	inode_ofs
		mov	ax,(bx)
		test	(si),ax
		jz	no_file
		xchg	ax,bx			| return(q->inode)
		ret

dir_search:	mov	cx,#7
		add	di,*ZONE0
dir_se1:	push	cx
		push	si
		push	di
		mov	ax,(di)
		call	search
		pop	di
		pop	si
		pop	cx
		or	ax,ax
		jnz	find
		add	di,*2
		loop	dir_se1
find:		ret

se_img1:	call	init_ind_tbl
		mov	di,ax
		mov	si,#System
		call	dir_search
		or	ax,ax
		jz	not_exist
se_img2:	mov	di,ax
		mov	si,#Minix_sys
		call	dir_search
not_exist:	ret

init_ind_tbl:	mov	ax,#1
inode_ofs:	dec	ax
inodeofs:	push	dx
		xor	dx,dx
		mov	bx,#INODESIZE
		div	bx
		cmp	ax,inode_block
		jz	calc_iofs
		push	dx
		push	cx
		push	bx
		push	bp
		mov	inode_block,ax
		add	ax,inode_start
		mov	bp,#INODETBL
		call	HD_read
		pop	bp
		pop	bx
		pop	cx
		pop	dx
calc_iofs:	xchg	ax,dx
		mul	bx
		add	ax,#INODETBL
		mov	bx,ax
		pop	dx
		ret

|	bp = char *buffer_address
|	ax = int  block_number
HD_read:	shl	ax,*1
		mov	sect_addr,ax
		movb	retrys,*0x80
hd_read1:	add	ax,offset_L
		mov	dx,offset_H
		adc	dx,#0
		div	cyl_size
		movb	ch,al		| cylinder number
		shr	ax,*1
		shr	ax,*1
		andb	al,*0xC0
		movb	cl,al		| cylinder-H
		mov	ax,dx
		xor	dx,dx
		div	trk_size
		movb	dh,al		| head address
		incb	dl		| sector start from 1
		orb	cl,dl		| cylinder + sector
		movb	dl,drive
		mov	bx,bp		| buffer address
		mov	ax,#READBLOCK	| read 1 block
		int	DISKBIOS
		jc	hd_retry
		ret

hd_retry:	shrb	retrys,*1
		jc	hd_err
		movb	dl,drive
		xor	ax,ax		| reset HDC
		int	DISKBIOS
|		movb	ah,*17
|		int	DISKBIOS
		mov	ax,sect_addr
		j	hd_read1

hd_err:		push	ax		| DISK status code
		call	error


| datas
.even
offset_L:	.word	0
offset_H:	.word	0
trk_size:	.word	0
cyl_size:	.word	0
drive:		.byte	0
partition:	.byte	0

sect_addr:	.word	0
retrys:		.word	0x80

inode_block:	.word	0xFFFF
inode_start:	.word	0
zone8rp:	.word	INODETBL
last_block:	.word	0
menu_ds:	.word	0
menu_pc:	.long	0

tracksize:	.word	0

WrongFS:	.byte	CR, LF
		.ascii	"Wrong FS"
		.byte	NULL

NoFile:		.byte	CR, LF
		.ascii	"File not found"
		.byte	NULL

MyOpenMsg:	.ascii	"Mini Boot Utility v0.7"
		.byte	CR, LF, NULL

Prompt:		.ascii	"mini.7>"
		.byte	NULL

		.word	0x4000
System:		.ascii	"system"
		.byte	NULL

		.word	0x8000
Minix_sys:	.ascii	"minix.sys"
		.byte	NULL

.text
endtext:

.data
enddata:

.bss
endbss:
