/*
 * dip		A program for handling dialup IP connecions.
 *		IP Datagram dumping routines.
 *
 * Author:      Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 */
#include "dip.h"
#include <linux/ip.h>	/* --> should become <net/ip.h> */


/* Dump the contents of an IP datagram. */
void ip_dump(ptr, len)
char *ptr;
int len;
{
  struct iphdr *ip;
  int dlen, doff;

  ip = (struct iphdr *) ptr;
  dlen = ntohs(ip->tot_len);
  doff = ((ntohs(ip->frag_off) & IPF_F_OFFSET) << 3);

  fprintf(stderr, "\r*****\n");
  fprintf(stderr, "IP: %s->", inet_ntoa(*(struct in_addr *) &ip->saddr));
  fprintf(stderr, "%s\n", inet_ntoa(*(struct in_addr *) &ip->daddr));
  fprintf(stderr, " len %u ihl %u ver %u ttl %u prot %u",
	dlen, ip->ihl, ip->version, ip->ttl, ip->protocol);

  if (ip->tos != 0) fprintf(stderr, " tos %u", ip->tos);
  if (doff != 0 || (ntohs(ip->frag_off) & IPF_MF))
	fprintf(stderr, " id %u offs %u", ntohs(ip->id), doff);

  if (ntohs(ip->frag_off) & IPF_DF) fprintf(stderr, " DF");
  if (ntohs(ip->frag_off) & IPF_MF) fprintf(stderr, " MF");
  fprintf(stderr, "\n*****\n");
  (void) fflush(stderr);
}
