#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>

volatile void usage(void)
{
	fprintf(stderr,"Usage: mknod filename [c|b] major minor\n\r");
	exit(1);
}

int main(int argc, char ** argv)
{
	int mode;
	int minor,major;
	char * pathname;

	if (argc != 5 || argv[2][1])
		usage();
	if (argv[2][0]=='c')
		mode = S_IFCHR;
	else if (argv[2][0] == 'b')
		mode = S_IFBLK;
	else
		usage();
	mode |= 0600;
	pathname=argv[1];
	major = atoi(argv[3]);
	if (errno == ERANGE)
		usage();
	minor = atoi(argv[4]);
	if (errno == ERANGE)
		usage();
	if (mknod(pathname,mode,major<<8 | minor)) {
		perror("mknod");
		exit(1);
	}
	return 0;
}
