#ifndef PAN_COM_LOW
#define PAN_COM_LOW

#include <dpmi.h>
#include <go32.h>
#include <stdio.h>
#include "../pan_glob.h"

#ifdef __cplusplus
extern "C" {
#endif

/***************************I/O Level***********************/

/*****************DOS memory/DPMI memory buffer swap********/
int Allocate_Dos_Buffers
   ( _go32_dpmi_seginfo *handler, uint16 bytes, uint16 *segment,
     uint16 *offset, uint32 *linear )
 {
/*allocates twice as needed because of 64k boundary test*/
  handler->size = (bytes*2 + 15) / 16; 
  if ( _go32_dpmi_allocate_dos_memory(handler) ) return(-202);

  *linear = handler->rm_segment << 4; /*linear adress of buffer*/

/* Does it cross a 64K boundary? */
/* if it does we allocate the bloc reserved AFTHER the boundary */
/* cause it seems that the IPX handler dosen't like boundaries */
  if ( (((*linear)&0xffff)+bytes) > 0xffff)
  *linear = ((*linear)-((*linear)&0xffff)) + 0x10000; /*0x10000 is next page*/
         
  *segment = (*linear) / 16;
  *offset  = (*linear) % 16;

  return(0);
 }

/**********************Core NCP*********************/
int shreq(int f,void *req,int rl,void *ans,int al)
 {
  int err;
  _go32_dpmi_registers r;
  _go32_dpmi_seginfo handler,handler2;
  uint32 linear, linear2;
  uint16 segment, offset, segment2, offset2;

  err=Allocate_Dos_Buffers(&handler,rl,&segment,&offset,&linear);
  if (err)
   {
    _go32_dpmi_free_dos_memory(&handler);
    return(err);
   }
  err=Allocate_Dos_Buffers(&handler2,al,&segment2,&offset2,&linear2);
  if (err)
   {
    _go32_dpmi_free_dos_memory(&handler);
    _go32_dpmi_free_dos_memory(&handler2);
    return(err);
   }
  memset(&r,0,sizeof(r));

  r.x.cx=rl;
  r.x.dx=al;
  r.x.ds=segment;
  r.x.si=offset;
  dosmemput(req,rl,linear);
  r.x.es=segment2;
  r.x.di=offset2;
  r.x.ax=0xf200|f;
  _go32_dpmi_simulate_int(0x21,&r);
  dosmemget(linear2,al,ans);

  _go32_dpmi_free_dos_memory(&handler);
  _go32_dpmi_free_dos_memory(&handler2);

  return(r.h.al);
 }

/*
 * Set connection id
 */
int setconn(int c)
 {
  _go32_dpmi_registers r;

  memset(&r,0,sizeof(r));

  r.x.ax=0xf000;  /* set preferred connection server */
  r.x.dx=c+1;
  _go32_dpmi_simulate_int(0x21,&r);

  return(r.h.al);
 }

int spoof(void *req,int rl)
 {
  int err;
  _go32_dpmi_registers r;
  _go32_dpmi_seginfo handler;
  uint32 linear;
  uint16 segment, offset;

  err=Allocate_Dos_Buffers(&handler,rl,&segment,&offset,&linear);
  if (err)
   {
     _go32_dpmi_free_dos_memory(&handler);
    return(err);
   }
  memset(&r,0,sizeof(r));

  r.x.cx=rl;
  r.x.ds=segment;
  r.x.si=offset;
  dosmemput(req,rl,linear);
  r.h.ah=0x04;

  _go32_dpmi_simulate_int(0x60,&r);

  _go32_dpmi_free_dos_memory(&handler);

  return(r.h.al);
 }
/****************************End of I/O level*********************/

#ifdef __cplusplus
}
#endif

#endif /* PAN_FILE_LIB */
