/* This simple example shows how to capture packets using the the pcap library

Copyright (C) 1999 Politecnico di Torino

This file is part of libpcap for win32.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */


#include <stdlib.h>
#include <stdio.h>

#include <pcap.h>

#define MAX_PRINT 80
#define MAX_LINE 16


void dispatcher_handler(u_char *, 
	const struct pcap_pkthdr *, const u_char *);
void usage();

void main(int argc, char **argv) {
pcap_t *fp;
char error[PCAP_ERRBUF_SIZE];

	if (argc < 3)
	{
		printf("\n\t pktdump [-n adapter] | [-f file_name]\n\n");
		return;
	}

	switch (argv[1] [1])
	{
	
	case 'n':
		{
			if ( (fp= pcap_open_live(argv[2], 100, 1, 20, error) ) == NULL)
			{
				fprintf(stderr,"\nError opening adapter\n");
				return;
			}
		};
		break;

	case 'f':
		{
			if ( (fp = pcap_open_offline(argv[2], NULL) ) == NULL)
			{
				fprintf(stderr,"\nError opening dump file\n");
				return;
			}
		};
		break;
	}
		
	// read and dispatch packets until EOF is reached
	pcap_loop(fp, 0, dispatcher_handler, NULL);
	
}



void dispatcher_handler(u_char *temp1, 
	const struct pcap_pkthdr *header, const u_char *pkt_data)
{
u_int i=0;
	
	//print pkt timestamp and pkt len
	printf("%ld:%ld (%ld)\n", header->ts.tv_sec, header->ts.tv_usec, header->len);			
	

	while ( (i<MAX_PRINT) && (i<header->len) )
	{
		i++;
		printf("%x ", pkt_data[i]);
		if ( (i%MAX_LINE) == 0) printf("\n");
	}
	
	printf("\n\n");

}


void usage()
{
	
	printf("\n\t pktdump [-n adapter] | [-f file_name]\n");
	exit(0);
}