/* closedir routine */

/* under MiNT (v0.9 or better) these use the appropriate system calls.
 * under TOS or older versions of MiNT, they use Fsfirst/Fsnext
 *
 * Written by Eric R. Smith and placed in the public domain
 */

#include <stdlib.h>
#include <string.h>
#include <types.h>
#include <limits.h>
#include <dirent.h>
#include <errno.h>
#include <osbind.h>
#include <mintbind.h>
#include "lib.h"


/* Important note: the same comment for the status variable of
 * opendir/readdir under Metados applies also here.
 */

extern ino_t __inode;	/* in stat.c */


int
closedir(dirp)
	DIR *dirp;
{
	long r;

	if (dirp->handle != 0xff000000L)
		r = Dclosedir(dirp->handle);
	else
		r = 0;
	if (r == -EINVAL) {
		/* hmm, something went wrong, just ignore it. */
		r = 0;
	}
	free(dirp);
	return r;
}
