/*                             -*- Mode: Elec-C -*-
 * dumpemac.c -- Automize dumping of GNU Emacs on the ST
 * 
 * Author          : Frank Ridderbusch T35
 * Created On      : Mon Nov 18 08:58:56 1991
 * Last Modified By: Frank Ridderbusch T35
 * Last Modified On: Tue Nov 19 16:03:36 1991
 * Update Count    : 2
 * Status          : Unknown, Use with caution!
 *
 * COMMENTS
 * 18-Nov-1991		Frank Ridderbusch T35	
 *    The idea for this program is from J.R.Dunning from his port of
 *    GNU Emacs 18.55 to the ST.
 *
 * $Locker$
 * $Log$
 */

#include <stdio.h>
#include <unistd.h>
#include <types.h>
#include <stat.h>
#include <time.h>


#define TEMACS "temacs"
#define XEMACS "xemacs"

#define DUMP ".\\" TEMACS " -batch -l loadup.el dump"
#define EMACS ".\\dumpfix -n " XEMACS ".1 " XEMACS ".2 emacs.ttp"

extern char *malloc ();

main (argc, argv)
int argc;
char **argv;
{
  int min_avail_space;
  char *ptr;
  time_t current_time;
  struct tm *ready;
  struct stat emacs_info;
  struct stat dumpfix_info;

  printf ("This is `dumpemac', the coffee break edition\n");
  printf ("\twritten by Frank Ridderbusch\n\n");

  /* Check, if we have temacs and dumpfix in the current directory */
  if (stat (TEMACS, &emacs_info)
      || (stat ("dumpfix.ttp", &dumpfix_info)
	  && stat ("dumpfix", &dumpfix_info)))
    {
      fprintf (stderr, "Either `" TEMACS "' or `dumpfix.ttp' are missing ");
      fprintf (stderr, "in the current directory\n");
      exit (1);
    }

  printf ("The dumping procedure takes about 13 minutes and 30 seconds\n");
  printf ("on a normal ST. So, it's time to have a coffee break. You\n");
  printf ("should be back at around ");

  time (&current_time);
  current_time += 13 * 60 + 30;
  ready = localtime (&current_time);
  printf ("%d:%02d o'clock.\n\n", ready->tm_hour, ready->tm_min);
  sleep (2);

  unlink ("emacs.ttp");
  unlink (XEMACS ".1");
  unlink (XEMACS ".2");

  printf ("First dump. Commandline: %s\n", DUMP);
  system (DUMP);

  if (!access (XEMACS, 0600))
    {
      fprintf (stderr, "First dump failed!!!\n");
      exit (1);
    }
  if (rename (XEMACS, XEMACS ".1"))
    {
      fprintf (stderr, "Couldn't rename first dump to " XEMACS ".1!!!\n");
      exit (1);
    }

  if ((ptr = malloc (1024 * 128L)) == NULL)
    {
      fprintf (stderr, "Malloc failed!!!\n");
      exit (2);
    }

  printf ("Second dump. Commandline: %s\n", DUMP);
  system (DUMP);

  if (!access (XEMACS, 0600))
    {
      fprintf (stderr, "Second dump failed!!!\n");
      exit (1);
    }
  if (rename (XEMACS, XEMACS ".2"))
    {
      fprintf (stderr, "Couldn't rename second dump to " XEMACS ".2!!!\n");
      exit (1);
    }

  free (ptr);

  printf ("Actually creating EMACS. Commandline: %s\n", EMACS);
  system (EMACS);
  exit (0);
}
