#include "../common/pangui.h"

/* Preference variables (local to dict range values) */
MOBJECT input,result;
MOBJECT manual_screen;

void QuitDecipherRemote(MOBJECT p, void *s, void *v)
{
 MShellDestroy(p);
}

void DecipherRemote(MOBJECT p, void *s, void *v)
{
 int err;
 char cipher[MAXPASSLEN*2+1],decipher[MAXPASSLEN+1];
 char temp[MAXPASSLEN+64];

 strncpy(cipher,MEditValue(input),MAXPASSLEN*2);
 strcpy(temp,"Password is : ");

 err=Pan_Decipher_RemoteNLM(cipher,decipher);
 if (err) MEditChangeText(result, 0, 65, Pan_error(err), 65);
 else
     {
      strcat(temp,decipher);
      MEditChangeText(result, 0, 65, temp, 65);
     }
 MEditSetCursorPos(result,0);
}

void Decipher_Remote(MOBJECT o, void *o_data, void *a_data)
{
 MOBJECT form_id;
 MOBJECT label;

 manual_screen = MCreateShell("Decipher Remote NLM password", SF_MODAL);
 MObjectSetBackgroundRGB(manual_screen, 56, 112, 112);

 form_id = MCreateRowForm(manual_screen);
 MObjectSetBackgroundRGB(form_id, 56, 112, 112);

 label = MCreateLabel(form_id, "Type ciphered remote password", FIXED_SMALL);
 MRightAttach(label, F_ATT_NONE, 3, NULL);
 MObjectSetBackgroundRGB(label, 56, 112, 112);
 MObjectSetForegroundRGB(label, 255, 255, 255);

 input = MCreateClippedEdit(form_id, "", MAXPASSLEN*2, 40, FIXED_SMALL);
 MRightAttach(input, F_ATT_NONE, 3, NULL);
 MObjectSetBackgroundRGB(input, 56, 112, 112);
 MObjectSetForegroundRGB(input, 192, 176, 160);

 result = MCreateClippedEdit(form_id, "Waiting for input...", MAXPASSLEN, 40, FIXED_SMALL);
 MRightAttach(result, F_ATT_NONE, 3, NULL);
 MObjectSetBackgroundRGB(result, 56, 112, 112);
 MObjectSetForegroundRGB(result, 192, 176, 160);
 MObjectSetUnsensitive(result);

 form_id = MCreateColForm(manual_screen);
 MObjectSetBackgroundRGB(form_id, 56, 112, 112);

 label = MCreatePButton(form_id, "Decipher", FIXED_SMALL);
 MPButtonSetCallback(label, DecipherRemote, 0L);

 label = MCreatePButton(form_id, "Quit", FIXED_SMALL);
 MPButtonSetCallback(label, QuitDecipherRemote, 0L);

 MShellRealize(manual_screen);
}
/****************************************************************************/
