/*
 * Program:	Main stand-alone Pine Composer routines
 *
 * Modifier:	Michael Seibel
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: mikes@cac.washington.edu
 *
 * Date:	Nov 1989
 * Last Edited:	9 September 1991
 *
 * Copyright 1991 by the University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both the
 * above copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the University of Washington not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  This software is made
 * available "as is", and
 * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
 * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *
 * WEEMACS/PICO NOTES:
 *
 * 08 Jan 92 - removed PINE defines to simplify compiling
 *
 * 08 Apr 92 - removed PINE stub calls
 *
 */

#include        <stdio.h>
#include	<setjmp.h>
#include	"osdep.h"	/* operating system dependent includes */
#include        "estruct.h"	/* global structures and defines */
#include	"efunc.h"	/* function declarations and sans name table */
#include	"edef.h"	/* global definitions */
#include	"pico.h"	/* pine composer definitions */


/*
 * this isn't defined in the library, because it's a pine global
 * which we use for GetKey's timeout
 */
int	timeout = 0;			/* global timeout value		*/

/*
 * function key mappings
 */
static int fkm[12][2] = {
    { F1,  (CTRL|'G')},
    { F2,  (CTRL|'X')},
    { F3,  (CTRL|'O')},
    { F4,  (CTRL|'J')},
    { F5,  (CTRL|'R')},
    { F6,  (CTRL|'W')},
    { F7,  (CTRL|'Y')},
    { F8,  (CTRL|'V')},
    { F9,  (CTRL|'K')},
    { F10, (CTRL|'U')},
    { F11, (CTRL|'C')},
#ifdef	SPELLER
    { F12, (CTRL|'T')}
#else
    { F12, (CTRL|'D')}
#endif
};


/*
 * main standalone pico routine
 */
main(argc, argv)
char    *argv[];
{
    register int    c;
    register int    f;
    register int    n;
    register BUFFER *bp;
    register int	carg;		/* current arg to scan 		*/
    extern   int    pico_new_mail();
    int	     viewflag = FALSE;		/* are we starting in view mode?*/
    int	     starton = 0;		/* where's dot to begin with?	*/
    int	     i;
    char     bname[NBUFN];		/* buffer name of file to read	*/
    char    *clerr = NULL;		/* garbage on command line	*/
    
    Pmaster = NULL;			/* turn OFF composer functionality */

    /*
     * Read command line flags before initializing, otherwise, we never
     * know to init for f_keys...
     */
    carg = 1;
    while(carg < argc){
	if(argv[carg][0] == '-'){
	    switch(argv[carg][1]){
	      case 'v':			/* -v for View File */
	      case 'V':
		viewflag = !viewflag;
		break;
	      case 'f':			/* -f for function key use */
		gmode ^= MDFKEY;
		break;
	      case 'n':			/* -n for new mail notification */
		timeout = 180;
		if(argv[carg][2] != '\0')
		  if((timeout = atoi(&argv[carg][2])) < 30)
		    timeout = 180;
		break;
	      case 't':			/* special shutdown mode */
		gmode ^= MDTOOL;
		rebindfunc(wquit, quickexit);
		break;
	      case 'z':			/* -z to suspend */
		gmode ^= MDSSPD;
		break;
	      case 'w':			/* -w turn off word wrap */
		gmode ^= MDWRAP;
		break;
	      default:			/* huh? */
		clerr = argv[carg];
		break;
	    }
	    carg++;
	}
	else if(argv[carg][0] == '+'){	/* leading '+' is special */
	    starton = atoi(&argv[carg][1]);
	    carg++;
	}
	else				/* pick up file name later... */
	  break;
    }

    vtinit();				/* Displays.            */
    strcpy(bname, "main");		/* default buffer name */
    edinit(bname);			/* Buffers, windows.   */

    update();				/* let the user know we are here */

#if	TERMCAP
    if(kpadseqs == NULL){		/* will arrow keys work ? */
	(*term.t_putchar)('\007');
	emlwrite("Warning: keypad keys may non-functional");
    }
#endif	/* TERMCAP */

    if(carg < argc){			/* Any file to edit? */

	makename(bname, argv[carg]);	/* set up a buffer for this file */

	bp = curbp;			/* read in first file */
	makename(bname, argv[carg]);
	strcpy(bp->b_bname, bname);
	strcpy(bp->b_fname, argv[carg]);
	if (readin(argv[carg], (viewflag==FALSE)) == ABORT) {
	    strcpy(bp->b_bname, "main");
	    strcpy(bp->b_fname, "");
	}
	bp->b_dotp = bp->b_linep;
	bp->b_doto = 0;

	if (viewflag)			/* set the view mode */
	  bp->b_mode |= MDVIEW;
    }

    /* setup to process commands */
    lastflag = 0;			/* Fake last flags.     */
    curbp->b_mode |= gmode;		/* and set default modes*/

    curwp->w_flag |= WFMODE;		/* and force an update	*/

    if(timeout)
      emlwrite("Checking for new mail every %D seconds", timeout);

    if(clerr){				/* post any errors on command line */
	if(mpresf)			/* show earlier message though! */
	  sleep(2);
	emlwrite("\007Unknown option: %s", clerr);
    }

    forwline(0, starton);		/* move dot to specified line */

    while(1){

	update();			/* Fix up the screen    */

	c = GetKey();	

	if(timeout && (c == NODATA || time_to_check())){
	    if(pico_new_mail())
	      emlwrite("You may possibly have new mail.");

	    if(c == NODATA)
	      continue;
	}

	if(mpresf){			/* erase message line? */
	    if(mpresf++ > MESSDELAY)
	      mlerase();
	}

	f = FALSE;
	n = 1;

	execute(normal(c, fkm, 1), f, n);	/* Do it.               */
    }
}
