/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	szcnstr.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Object Interface class declaration for size constraints
 *
 *	RCSid = "$Id: szcnstr.H,v 1.2.1.1 1993/06/01 22:57:02 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef	OI_szcnstr_H
#define OI_szcnstr_H

#ifndef OI_defs_H
#include <OI/defs.H>
#endif /* OI_defs_H */

		class	OI_size_constraints : public OI_callback {
			OI_number	hz_const;		/* horizontal constant */
			OI_number	hz_mult;		/* horizontal multiplier */
			OI_number	vt_const;		/* vertical constant */
			OI_number	vt_mult;		/* vertical multiplier */
		 public:
					OI_size_constraints()				{ hz_mult = vt_mult = 1; hz_const = vt_const = 0; }
					OI_size_constraints(OI_number hm, OI_number hc, OI_number vm, OI_number vc)
						{ hz_const=hc; hz_mult=hm; vt_const=vc; vt_mult=vm; }
		virtual			~OI_size_constraints();
			void		horz_constraints(OI_number *mp, OI_number *cp)	{ *cp=hz_const; *mp=hz_mult; }
			OI_number	horz_constant()					{ return(hz_const); }
			OI_number	horz_multiplier()				{ return(hz_mult); }
			void		vert_constraints(OI_number *mp, OI_number *cp)	{ *cp=vt_const; *mp=vt_mult; }
			OI_number	vert_constant()					{ return(vt_const); }
			OI_number	vert_multiplier()				{ return(vt_mult); }
			void		set_horz_constraints(OI_number m, OI_number c)	{ hz_const=c; hz_mult=m; }
			void		set_vert_constraints(OI_number m, OI_number c)	{ vt_const=c; vt_mult=m; }
		} ;

#endif /* OI_szcnstr_H */
