#include <OI/oi.H>
#if defined(ultrix) || defined(SVR4) || defined(hpux)
#include <unistd.h>
#else
#include <sysent.h>
#endif
#include <sys/param.h>
#include <string.h>

/*
 *	Callbacks
 *	
 *	This program demostrates the use of callbacks to achieve filename
 *	completetion inside a file dialog box.
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *		- OIIntro
 *			OI_init()
 *			OI_begin_interaction()
 *			OI_fini()
 *		- OI_d_tech (30)
 *			generic_type()
 *			layout_associated_object()
 *			parent()
 *			push_help_str()
 *			set_associated_object()
 *			set_layout()
 *		- OI_app_window (3O)
 *		- OI_entry_field (3O)
 *			insert_char()
 *			length()
 *			part_text()
 *			set_char_chk()
 *		- OI_file_dialog_box (3O)
 *			directory()
 *			entry_field()
 */

void parse_path_in_ef (OI_entry_field *, char *, char *);
int entry_field_complete (OI_entry_field *);


/*
 *	file_completion_chk_cb
 *
 *	This function gets called for each of the characters that gets
 *	entered into the keyboard.  It traps <Esc> and <Tab> (if the
 *	model dependent translations let them through) and then does a
 *	csh-like completion on the entry field.
 */
OI_ef_char_chk_status file_completion_chk_cb (OI_entry_field *efp, void *, OI_number, char ch)
{
	static int	entry_lock = 0;

	/*
	 *	Check to see if we are calling ourselves, and assume
	 *	that all characters are good.
	 */
	if (entry_lock)
		return OI_EF_CHAR_CHK_INSERT;
	
	/*
	 *	If it isn't printable, we punt for now.
	 */
	if (!isprint (ch) && ch != '\033' && ch != '\t')
		return OI_EF_CHAR_CHK_BAD;

	/*
	 *	If it isn't a <Esc> or a <Tab> then it is OK.
	 */
	if (ch != '\033' && ch != '\t')
		return OI_EF_CHAR_CHK_INSERT;

	entry_lock = 1;
	if (entry_field_complete (efp)) {
		entry_lock = 0;
		return OI_EF_CHAR_CHK_BAD;
	}
	else {
		entry_lock = 0;
		return OI_EF_CHAR_CHK_IGNORE;
	}
}

/*
 *	main
 *
 *	This program demonstrates
 *		- initializing OI, opening a connection to the server
 *		- fetching additional resources
 *		- create the file dialog box
 *		- add the callbacks to the 
 */
void
main (int argc, char **argv)
{
	OI_connection	*conp;			/* the connection to the server */
	OI_file_dialog_box *file_db;		/* File dialog box for example. */
	OI_entry_field	*efp;			/* Pointer to the file dialog box ef */
	OI_app_window	*awp;			/* Top level box */
	
	/*
	 *	Open a connection to the server.
	 *	OI_init also logs the command line arguments specified in the opTable.
	 */
	if ((conp = OI_init(&argc, argv, "callbacks", "Callbacks"))) {

		/*
		 *	Create the outermost app window
		 */
		awp = oi_create_app_window ("topLevel", 1, 1,"Callback Demo");
		awp -> set_layout (OI_layout_row);
		
		/*
		 *	Create the file dialog box, with the default menu cells.
		 */
		file_db = oi_create_file_dialog_box ("fileBox", ".", "*");
		file_db->layout_associated_object (awp, 1, 1, OI_ACTIVE);

		/*
		 *	Add an entry callback to the file dialog box's
	 	 *	entry field.  entry_filed doen't belong to
		 *	file_dialog_box, it belongs to prompt_dialog_box.
		 */
		efp = file_db->entry_field ();
		efp->set_char_chk (&file_completion_chk_cb);

		/*
		 *	display app window
		 */
		awp -> set_associated_object (awp -> root (), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE);
		OI_begin_interaction ();
	}

	/*
	 * Cleanup.  Make sure that we cleanup the library.
	 */
	OI_fini ();
}
