/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorHandler;
import net.sf.saxon.dom.DOMSender;
import net.sf.saxon.event.ContentEmitter;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Sender {
    Configuration config;

    public Sender(Configuration configuration) {
        this.config = configuration;
    }

    public void send(Source source, Receiver receiver, NamePool namePool, boolean bl) throws TransformerException {
        receiver.setNamePool(namePool);
        receiver.setSystemId(source.getSystemId());
        if (source instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)source;
            int n = nodeInfo.getNodeKind();
            if (n != 9 && n != 1) {
                throw new IllegalArgumentException("DocumentSender can only handle document or element nodes");
            }
            this.sendDocumentInfo(nodeInfo, receiver, namePool);
        } else if (source instanceof SAXSource) {
            this.sendSAXSource((SAXSource)source, receiver, namePool, bl);
        } else if (source instanceof DOMSource) {
            this.sendDOMSource((DOMSource)source, receiver, namePool);
        } else if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            String string = source.getSystemId();
            InputSource inputSource = new InputSource(string);
            inputSource.setCharacterStream(streamSource.getReader());
            inputSource.setByteStream(streamSource.getInputStream());
            SAXSource sAXSource = new SAXSource(bl ? this.config.getStyleParser() : this.config.getSourceParser(), inputSource);
            sAXSource.setSystemId(source.getSystemId());
            this.sendSAXSource(sAXSource, receiver, namePool, bl);
        } else {
            throw new IllegalArgumentException("Unknown type of source " + source.getClass());
        }
    }

    private void sendDocumentInfo(NodeInfo nodeInfo, Receiver object, NamePool namePool) throws TransformerException {
        Object object2;
        if (nodeInfo.getNamePool() != namePool) {
            object2 = new NamePoolConverter(nodeInfo.getNamePool(), namePool);
            ((NamePoolConverter)object2).setUnderlyingReceiver((Receiver)object);
            object = object2;
        }
        object2 = new DocumentSender(nodeInfo);
        ((DocumentSender)object2).send((Receiver)object);
    }

    private void sendDOMSource(DOMSource dOMSource, Receiver receiver, NamePool namePool) throws TransformerException {
        Node node = dOMSource.getNode();
        if (node instanceof DocumentInfo) {
            this.sendDocumentInfo((DocumentInfo)((Object)node), receiver, namePool);
        } else {
            DOMSender dOMSender = new DOMSender();
            dOMSender.setStartNode(node);
            dOMSender.setReceiver(receiver);
            dOMSender.setNamePool(namePool);
            dOMSender.setSystemId(dOMSource.getSystemId());
            dOMSender.send();
        }
    }

    private void sendSAXSource(SAXSource object, Receiver receiver, NamePool namePool, boolean bl) throws TransformerException {
        Object object2;
        XMLReader xMLReader = ((SAXSource)object).getXMLReader();
        if (xMLReader == null) {
            object2 = new SAXSource();
            ((SAXSource)object2).setInputSource(((SAXSource)object).getInputSource());
            ((SAXSource)object2).setSystemId(((SAXSource)object).getSystemId());
            xMLReader = bl ? this.config.getStyleParser() : this.config.getSourceParser();
            ((SAXSource)object2).setXMLReader(xMLReader);
            object = object2;
        }
        if (xMLReader.getErrorHandler() == null) {
            xMLReader.setErrorHandler(new StandardErrorHandler(this.config.getErrorListener()));
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new TransformerException("The SAX2 parser does not recognize a required namespace feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new TransformerException("The SAX2 parser does not support a required namespace feature");
        }
        if (this.config.isSchemaValidation() && !bl) {
            receiver = this.config.getDocumentValidator(receiver, ((SAXSource)object).getSystemId(), namePool, 1);
        }
        object2 = new ContentEmitter();
        ((ContentEmitter)object2).setReceiver(receiver);
        ((ContentEmitter)object2).setNamePool(namePool);
        xMLReader.setContentHandler((ContentHandler)object2);
        xMLReader.setDTDHandler((DTDHandler)object2);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object2);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        try {
            xMLReader.parse(((SAXSource)object).getInputSource());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof TransformerException) {
                throw (TransformerException)exception;
            }
            throw new TransformerException(sAXException);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }
}

