/*
 * Decompiled with CFR 0.152.
 */
package classycle.util;

import classycle.util.OrStringPattern;
import classycle.util.StringPattern;
import java.util.StringTokenizer;

public class WildCardPattern
implements StringPattern {
    private static final String WILD_CARD = "*";
    private final String _pattern;
    private final String[] _constantParts;
    private final boolean _startsWithAnything;
    private final boolean _endsWithAnything;

    public static StringPattern createFromsPatterns(String patterns, String delimiters) {
        if (delimiters.indexOf(WILD_CARD) >= 0) {
            throw new IllegalArgumentException("No wild card '*' are allowed as delimiters: " + delimiters);
        }
        OrStringPattern result = new OrStringPattern(new StringPattern[0]);
        StringTokenizer tokenizer = new StringTokenizer(patterns, delimiters);
        while (tokenizer.hasMoreTokens()) {
            result.appendPattern(new WildCardPattern(tokenizer.nextToken().trim()));
        }
        return result;
    }

    public WildCardPattern(String pattern) {
        this._pattern = pattern;
        this._startsWithAnything = pattern.startsWith(WILD_CARD);
        this._endsWithAnything = pattern.endsWith(WILD_CARD);
        StringTokenizer tokenizer = new StringTokenizer(pattern, WILD_CARD);
        this._constantParts = new String[tokenizer.countTokens()];
        for (int i = 0; i < this._constantParts.length; ++i) {
            this._constantParts[i] = tokenizer.nextToken();
        }
    }

    public String toString() {
        return this._pattern;
    }

    @Override
    public boolean matches(String string) {
        return string == null ? false : this.matches(string, 0, 0);
    }

    private boolean matches(String string, int indexInString, int indexInConstantParts) {
        boolean result = true;
        if (indexInConstantParts < this._constantParts.length) {
            int index;
            String constantPart = this._constantParts[indexInConstantParts];
            do {
                if ((index = string.indexOf(constantPart, indexInString)) >= 0 && (indexInString != 0 || this._startsWithAnything || index <= 0)) continue;
                result = false;
                break;
            } while (!(result = this.matches(string, indexInString = index + constantPart.length(), indexInConstantParts + 1)));
        } else {
            result = result && (this._endsWithAnything || indexInString == string.length());
        }
        return result;
    }
}

