;  DSP-93 Register Definitions  94.07.13 @ 15:47 EST
;  Version for TAPR/AMSAT DSP-93, 
;
;  Module Name:
;       REGS.ASM
;  Creator:
;       Mike Zingman N4IRR
;  Purpose:
;       This file defines the register replacements for the TASM assembler.
;       The register file AR0 through AR7 are defined as well as the memory
;       maped registers defined by the processor.
;  Used in:
;       All files should include this definition file.  This file will only
;       be included once.
;  Expected warnings:
;       None
;  Revision history:
;       Created: 94.07.13 By Mike Zingman N4IRR
;       Added conditional assembly for multiple inclusion
;       Added interupt register bit definitions (N4IRR)
;       Changed file name to REGS.INC (N4IRR)
;
; Copyright (c) 1994 by Tucson Amateur Packet Radio Corporation
; 
; This document, and it executable, are the property of the Tucson Amateur
; Packet Radio Corp., a Arizona non-profit corporation, and all are copyright
; 1994.  Permission is hereby granted for the non-commercial use of these
; properties only by licensed amateur radio operators.  All other rights are
; reserved  by the Tucson Amateur Packet Radio Corp. 
; 
; This software is provided for use only to non-commercial amateur radio
; users.  Commercial inquiries should be made to Tucson Amateur Packet Radio
; Corp.
; 
; TAPR (Tucson Amateur Packet Radio Corporation) makes no warranty of any
; kind, express or implied, including without limitation, any warranties
; and/or fitness for a particular purpose of this software.  TAPR shall not be
; liable for any damages, whether direct, indirect, special or consequential
; arising from a failure of this software to operate in the manner desired by
; the user.  TAPR shall not be liable for any damage to data or property that
; may be caused directly or indirectly by using the software.
; 
; IN NO EVENT WILL TUCSON AMATEUR PACKET RADIO CORP. BE LIABLE FOR ANY
; INCIDENTAL OR CONSEQUENTIAL DAMAGE ARISING OUT OF USE OR INABILITY TO USE
; THE PROGRAM, OR FOR ANY CLAIM BY ANY OTHER PARTY.
;

#IFNDEF __REGS__
#DEFINE __REGS__

; AUX register definitions

AR0       .EQU      00h       ;  aux register 0 (equate used by TASM)
AR1       .EQU      01h       ;  aux register 1 (equate used by TASM)
AR2       .EQU      02h       ;  aux register 2 (equate used by TASM)
AR3       .EQU      03h       ;  aux register 3 (equate used by TASM)
AR4       .EQU      04h       ;  aux register 4 (equate used by TASM)
AR5       .EQU      05h       ;  aux register 5 (equate used by TASM)
AR6       .EQU      06h       ;  aux register 6 (equate used by TASM)
AR7       .EQU      07h       ;  aux register 7 (equate used by TASM)

; Memory maped registers

DRR       .EQU      00h       ;  SIO (AIO) receive buffer
DXR       .EQU      01h       ;  SIO (AIO) transmit buffer
TIM       .EQU      02h       ;  TIMER countdown buffer
PRD       .EQU      03h       ;  TIMER period buffer
IMR       .EQU      04h       ;  INT mask buffer

; Interupt register bit definitions

IMR_INT0  .EQU      01h
IMR_INT1  .EQU      02h
IMR_INT2  .EQU      04h
IMR_TINT  .EQU      08h
IMR_RINT  .EQU      10h
IMR_XINT  .EQU      20h


BASE_PAGE .EQU      00h       ;  Base page of memory (internal)
USER_PAGE .EQU      08h       ;  Application memory @ 0400h

#ENDIF

