/*
** INFO.C - This is the ODBC sample driver code for
** executing information functions.
**
**	This code is furnished on an as-is basis as part of the ODBC SDK and is
**	intended for example purposes only.
**
*/

//	-	-	-	-	-	-	-	-	-

#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>

#include "gorta.h"
#include "states.h"

#include <msql.h>

#include "odbcinst.h"					// ODBC installer prototypes


//	-	-	-	-	-	-	-	-	-

static char far * ODBC_INI = "odbc.ini";

//	This is the list of all the functions supported / not supported by this
//	driver. This information is returned by SQLGetFunctions

static UWORD SupportedFunctions[100] = {
	FALSE,		// Not used
	TRUE,		// SQL_API_SQLALLOCCONNECT
	TRUE,		// SQL_API_SQLALLOCENV
	TRUE,		// SQL_API_SQLALLOCSTMT
	TRUE,		// SQL_API_SQLBINDCOL
	TRUE,		// SQL_API_SQLCANCEL
	TRUE,		// SQL_API_SQLCOLATTRIBUTES
	TRUE,		// SQL_API_SQLCONNECT
	TRUE,		// SQL_API_SQLDESCRIBECOL
	TRUE,		// SQL_API_SQLDISCONNECT
	TRUE,		// SQL_API_SQLERROR (10)
	TRUE,		// SQL_API_SQLEXECDIRECT
	TRUE,		// SQL_API_SQLEXECUTE
	TRUE,		// SQL_API_SQLFETCH
	TRUE,		// SQL_API_SQLFREECONNECT
	TRUE,		// SQL_API_SQLFREEENV
	TRUE,		// SQL_API_SQLFREESTMT
 	FALSE,		// SQL_API_SQLGETCURSORNAME
	TRUE,		// SQL_API_SQLNUMRESULTCOLS
	TRUE,		// SQL_API_SQLPREPARE
	TRUE,		// SQL_API_SQLROWCOUNT (20)
	FALSE,		// SQL_API_SQLSETCURSORNAME
 	FALSE,		// SQL_API_SQLSETPARAM
	FALSE,		// SQL_API_SQLTRANSACT

	
	FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, // Unused (30)
	FALSE, FALSE, FALSE, FALSE, FALSE, // Unused 
	FALSE, FALSE, FALSE, FALSE, // Unused

	TRUE,		// SQL_API_SQLCOLUMNS (40)
	TRUE,		// SQL_API_SQLDRIVERCONNECT
	FALSE,		// SQL_API_SQLGETCONNECTOPTION

	TRUE,		// SQL_API_SQLGETDATA
	TRUE,		// SQL_API_SQLGETFUNCTIONS
	TRUE,		// SQL_API_SQLGETINFO
	TRUE,		// SQL_API_SQLGETSTMTOPTION
	TRUE,		// SQL_API_SQLGETTYPEINFO
	TRUE,		// SQL_API_SQLPARAMDATA
	TRUE,		// SQL_API_SQLPUTDATA
	TRUE,		// SQL_API_SQLSETCONNECTOPTION (50)

	TRUE,		// SQL_API_SQLSETSTMTOPTION    51
	TRUE,		// SQL_API_SQLSPECIALCOLUMNS   52
	TRUE,		// SQL_API_SQLSTATISTICS       53
	TRUE,		// SQL_API_SQLTABLES           54

	FALSE,		// SQL_API_SQLBROWSECONNECT    55    /* Level 2 Functions        */
	FALSE,		// SQL_API_SQLCOLUMNPRIVILEGES 56
	FALSE,		// SQL_API_SQLDATASOURCES      57
	FALSE,		// SQL_API_SQLDESCRIBEPARAM    58
	FALSE,		// SQL_API_SQLEXTENDEDFETCH    59
	FALSE,		// SQL_API_SQLFOREIGNKEYS      60

	TRUE,		// SQL_API_SQLMORERESULTS      61
	FALSE,		// SQL_API_SQLNATIVESQL        62
	FALSE,		// SQL_API_SQLNUMPARAMS        63
	FALSE,		// SQL_API_SQLPARAMOPTIONS     64
	FALSE,		// SQL_API_SQLPRIMARYKEYS      65
	FALSE,		// SQL_API_SQLPROCEDURECOLUMNS 66
	FALSE,		// SQL_API_SQLPROCEDURES       67
	FALSE,		// SQL_API_SQLSETPOS           68
	FALSE,		// SQL_API_SQLSETSCROLLOPTIONS 69
	FALSE,		// SQL_API_SQLTABLEPRIVILEGES  70

	FALSE,		// SQL_API_SQLDRIVERS          71
	TRUE,		// SQL_API_SQLBINDPARAMETER	   72
	FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, // Unused (80)
	FALSE, FALSE, FALSE, FALSE, FALSE, // Unused
	FALSE, FALSE, FALSE, FALSE, FALSE, // Unused (90)
	FALSE, FALSE, FALSE, FALSE, FALSE, // Unused
	FALSE, FALSE, FALSE, FALSE 		   // Unused (99)
};

static RESULT_FORMAT RFTypes[15] = {
	{ CHAR_TYPE,  128, NOT_NULL_FLAG, 	"TYPE_NAME", NULL},
	{SHORT_TYPE,  2,   NOT_NULL_FLAG, 	"DATA_TYPE", NULL},
	{ INT_TYPE,   4,   0,           	"PRECISION", NULL},
	{ CHAR_TYPE,  128, 0,            	"LITERAL_PREFIX", NULL},
	{ CHAR_TYPE,  128, 0,            	"LITERAL_SUFFIX", NULL},
	{ CHAR_TYPE,  128, 0,            	"CREATE_PARAMS", NULL},
	{SHORT_TYPE,  2,   NOT_NULL_FLAG, 	"NULLABLE", NULL},
	{SHORT_TYPE,  2,   NOT_NULL_FLAG, 	"CASE_SENSITIVE", NULL},
	{SHORT_TYPE,  2,   NOT_NULL_FLAG, 	"SEARCHABLE", NULL},
	{SHORT_TYPE,  2,   0,           	"UNSIGNED_ATTRIBUTES", NULL},
	{SHORT_TYPE,  2,   NOT_NULL_FLAG, 	"MONEY", NULL},
	{SHORT_TYPE,  2,   0,            	"AUTO_INCREMENT", NULL},
	{ CHAR_TYPE,  128, 0,            	"LOCAL_TYPE_NAME", NULL},
	{SHORT_TYPE,  2,   0,             	"MINIMUM_SCALE", NULL},
	{SHORT_TYPE,  2,   0,              	"MAXIMUM_SCALE", NULL}
};

//	-	-	-	-	-	-	-	-	-

//	This function is intended to return a massive amount of information
//	about the driver.

RETCODE SQL_API SQLGetInfo(
	HDBC      hdbc,
	UWORD     fInfoType,
	PTR       rgbInfoValue,
	SWORD     cbInfoValueMax,
	SWORD FAR *pcbInfoValue)
{
	RETCODE retcode = SQL_SUCCESS;
	LPEI lpeiTmp;
	LPDBC lpdbc;
	
	lpdbc = (LPDBC)hdbc;
	
	switch (fInfoType)
	{
	case SQL_DATA_SOURCE_NAME:
		if (pcbInfoValue)
			*pcbInfoValue = sprintf(rgbInfoValue, "%.*s", cbInfoValueMax, 
				lpdbc->caDSN);
		else
			sprintf(rgbInfoValue, "%.*s", cbInfoValueMax, lpdbc->caDSN);
		break;
	case SQL_DRIVER_NAME:
		SQLGetPrivateProfileString(lpdbc->caDSN, "Driver", "", 
			rgbInfoValue, cbInfoValueMax, ODBC_INI);
		pcbInfoValue && (*pcbInfoValue = strlen(rgbInfoValue));
		break;
	case SQL_ACTIVE_CONNECTIONS:
	case SQL_ACTIVE_STATEMENTS:
		*(SWORD FAR *)rgbInfoValue = 15;
		pcbInfoValue && (*pcbInfoValue = sizeof(short));
		break;
	case SQL_CURSOR_COMMIT_BEHAVIOR:			// Transaction Tracking null behaviour
	case SQL_CURSOR_ROLLBACK_BEHAVIOR:
		*(SWORD FAR *)rgbInfoValue = SQL_CB_PRESERVE;
		pcbInfoValue && (*pcbInfoValue = sizeof(short));
		break;
	case SQL_ACCESSIBLE_PROCEDURES:
	case SQL_DATA_SOURCE_READ_ONLY:
	case SQL_OUTER_JOINS:
		strncpy (rgbInfoValue, "N", cbInfoValueMax);
		pcbInfoValue && (*pcbInfoValue = 1);
		break;
	case SQL_EXPRESSIONS_IN_ORDERBY:
	case SQL_COLUMN_ALIAS:
	case SQL_ACCESSIBLE_TABLES:
		strncpy (rgbInfoValue, "Y", cbInfoValueMax);
		pcbInfoValue && (*pcbInfoValue = 1);
		break;
	case SQL_DBMS_NAME:
		strncpy (rgbInfoValue, "Mini SQL", cbInfoValueMax);
		pcbInfoValue && (*pcbInfoValue = 8);
		break;
	case SQL_DRIVER_ODBC_VER:
		strncpy(rgbInfoValue, SQL_SPEC_STRING, cbInfoValueMax);
		pcbInfoValue && (*pcbInfoValue = strlen(SQL_SPEC_STRING));
		break;
	case SQL_IDENTIFIER_QUOTE_CHAR:
		strncpy (rgbInfoValue, " ", cbInfoValueMax);
		pcbInfoValue && (*pcbInfoValue = 1);
		break;
	case SQL_MAX_USER_NAME_LEN:
		*(/* UNALIGNED */ SWORD FAR *)rgbInfoValue = 0;
		pcbInfoValue && (*pcbInfoValue = sizeof(short));
		break;
	case SQL_ODBC_API_CONFORMANCE:
		*(SWORD FAR *)rgbInfoValue = SQL_OAC_LEVEL1;
		pcbInfoValue && (*pcbInfoValue = sizeof(short));
		break;
	case SQL_ALTER_TABLE:
	case SQL_CONVERT_FUNCTIONS:
	case SQL_NUMERIC_FUNCTIONS:
	case SQL_STRING_FUNCTIONS:
	case SQL_TIMEDATE_FUNCTIONS:
	case SQL_SYSTEM_FUNCTIONS:
		*(DWORD FAR *)rgbInfoValue = 0L;
		pcbInfoValue && (*pcbInfoValue = sizeof(long));
		break;
	case SQL_TXN_CAPABLE:
		/*
		 * Try this to make VB work
		 */
		*(SWORD FAR *)rgbInfoValue = SQL_TC_DML;
		pcbInfoValue && (*pcbInfoValue = sizeof(short));
		break;
	case SQL_BOOKMARK_PERSISTENCE:
		*(DWORD FAR *)rgbInfoValue = 0L;
		pcbInfoValue && (*pcbInfoValue = sizeof(long));
		break;
	case SQL_CONCAT_NULL_BEHAVIOR:
		*(SWORD FAR *)rgbInfoValue = SQL_CB_NON_NULL;
		pcbInfoValue && (*pcbInfoValue = sizeof(short));
		break;	
	case SQL_SEARCH_PATTERN_ESCAPE:
		memcpy((char FAR *)rgbInfoValue, "\\", 2);
		pcbInfoValue && (*pcbInfoValue = 2);
		break;		
	default:
		// Unsupported function
		retcode = SQL_ERROR;
		lpeiTmp = malloc(sizeof(EI));
		if (!lpeiTmp)
		{
			retcode = SQL_ERROR;
			goto Exit;
		}
		lpeiTmp->pNext = lpdbc->lpei;
		lpeiTmp->lErrorCode=-1;
		strncpy(lpeiTmp->szSqlState, MSQL_DRIVER_NOT_CAPABLE, 6);
		sprintf(lpeiTmp->szErrorMessage, 
			"[MSQLODBC]SQLGetInfo option [%d] not supported ", fInfoType);
		lpdbc->lpei=lpeiTmp;
		goto Exit;
	}
Exit:
	return(retcode);
}

//	-	-	-	-	-	-	-	-	-
//	Function sets up a result set containing details of the types
//	supported by MSQL.
//
//	Result set is in the format:
//
//		TYPE_NAME	varchar(128) not null
//		DATA_TYPE	smallint not null
//		PRECISION	integer
//		LITERAL_PREFIX varchar(128)
//		LITERAL_SUFFIX varchar(128)
//		CREATE_PARAMS  varchar(128)
//		NULLABLE	smallint not null
//		CASE_SENSITIVE smallint not null
//		SEARCHABLE  smallint not null
//		UNSIGNED_ATTRIBUTES smallint not null
//		MONEY smallint not null
//		AUTO_INCREMENT smallint
//		LOCAL_TYPE_NAME varchar(128)
//		MINIMUM_SCALE smallint
//		MAXIMUM_SCALE smallint
//
//	This is where the type information is extended.
//
//	Types for the initial system have to include
//	varchar, and integer
RETCODE SQL_API SQLGetTypeInfo(
	HSTMT	hstmt,
	SWORD	fSqlType)
{
	LPSTMT lpstmt;
	m_result *MResult;
	m_fdata *curField;
	m_data *curRow;
	int iLoop;
	
	lpstmt = (LPSTMT)hstmt;
	assert(lpstmt->lMagic == STATEMENT_MAGIC);
	
	if (lpstmt->pvdMResult) // Free previous result
	{
		MResult = (m_result*)lpstmt->pvdMResult;
		lpstmt->pvdMResult = NULL;
		msqlFreeResult(MResult);
	}
	
    /*
     * Set up result Data dictionary.
     */
	lpstmt->pvdMResult = MResult = malloc(sizeof(m_result));
	assert(MResult);
	MResult->numFields = 15;
	MResult->fieldData = MResult->fieldCursor = curField = malloc(sizeof(m_fdata));
	assert(curField);
	curField->field.type = RFTypes[0].iType;
	curField->field.length = RFTypes[0].iLength;
	curField->field.flags =  RFTypes[0].iFlags;
	curField->field.name = strdup(RFTypes[0].pcName);
	curField->field.table = NULL;
	for (iLoop = 1; iLoop < 15; iLoop++)
	{
		curField->next = malloc(sizeof(m_fdata));
		assert(curField->next);
		curField = curField->next;
		curField->next = NULL;
		curField->field.type = RFTypes[iLoop].iType;
		curField->field.length = RFTypes[iLoop].iLength;
		curField->field.flags =  RFTypes[iLoop].iFlags;
		curField->field.name = strdup(RFTypes[iLoop].pcName);
		curField->field.table = NULL;
	}
	MResult->cursor = NULL;
	
	/*	
	 * Now the catalog is set up. Can set up the fields
	 */
	MResult->queryData = NULL;
	MResult->numRows = 0;
	
	/*
	 * CHAR - variable length null delimited strings.
	 */
	if (fSqlType == SQL_ALL_TYPES || fSqlType == SQL_CHAR)
	{
		if (!MResult->queryData)
		{
			curRow = MResult->queryData = malloc(sizeof(m_data));
		}
		else
		{
			curRow->next = malloc(sizeof(m_data));
			curRow = curRow->next;
		}
		curRow->next = NULL;
		curRow->width = 15;
		curRow->data = calloc(15, sizeof(char *));
		curRow->data[0] = strdup("CHAR");
		//curRow->data[1] = strdup("1"); /* SQL_CHAR */
		curRow->data[1] = strdup("12"); /* SQL_VARCHAR */
		curRow->data[2] = strdup("1024");
		curRow->data[3] = strdup("'");
		curRow->data[4] = strdup("'");
		curRow->data[5] = strdup("max length");
		curRow->data[6] = strdup("1"); /* SQL_NULLABLE */
		curRow->data[7] = strdup("1"); /* TRUE */
		curRow->data[8] = strdup("3"); /* SQL_SEARCHABLE */
		curRow->data[10] = strdup("0"); /* FALSE */
		MResult->numRows++;
	}

	/*
	 * Type integer
	 */
	if (fSqlType == SQL_ALL_TYPES || fSqlType == SQL_INTEGER)
	{
		if (!MResult->queryData)
		{
			curRow = MResult->queryData = malloc(sizeof(m_data));
		}
		else
		{
			curRow->next = malloc(sizeof(m_data));
			curRow = curRow->next;
		}
		curRow->next = NULL;
		curRow->width = 15; 
		curRow->data = calloc(15, sizeof(char *));
		curRow->data[0] = strdup("INTEGER");
		curRow->data[1] = strdup("4"); /* SQL_INTEGER */
		curRow->data[2] = strdup("10"); /* display length */
		curRow->data[6] = strdup("1"); /* SQL_NULLABLE */
		curRow->data[7] = strdup("0"); /* FALSE */
		curRow->data[8] = strdup("2"); /* SQL_ALL_EXCEPT_LIKE */
		curRow->data[9] = strdup("1"); /* TRUE */
		curRow->data[10] = strdup("0"); /* FALSE */
		curRow->data[11] = strdup("0"); /* FALSE */
		MResult->numRows++;
	}
	
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

RETCODE SQL_API SQLGetFunctions(
	LPDBC     lpdbc,
	UWORD     fFunction,
	UWORD FAR *pfExists)
{
	if (fFunction == SQL_API_ALL_FUNCTIONS)
		memcpy(pfExists, SupportedFunctions, sizeof(SupportedFunctions));
	else
		*pfExists = SupportedFunctions[fFunction];
	return SQL_SUCCESS;
}
