(*--------------------------------------------------------------------------*)
(*                 TestInvt --- Test inverse chi-square                     *)
(*--------------------------------------------------------------------------*)

PROGRAM TestInvt;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*   Program:  TestInvt                                                     *)
(*                                                                          *)
(*   Purpose:  Demonstrate inverse t routine in PIBSIGS                     *)
(*                                                                          *)
(*   Usage:    This program prompts for a p-value and degrees of freedom.   *)
(*             It computes and prints the corresponding percentage points   *)
(*             (one-tailed and two-tailed) of the t distribution.           *)
(*                                                                          *)
(*             Note:  the input probability is the tail value, not the      *)
(*                    cumulative probability value.                         *)
(*                                                                          *)
(*             To stop the program, enter a negative p-value.               *)
(*                                                                          *)
(*   Calls:    Tinv                                                         *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   t1:       REAL;
   t2:       REAL;
   Df:       REAL;
   P:        REAL;
   Done:     BOOLEAN;

(*$I SIGCONST.PAS *)
(*$I LOGTEN.PAS   *)
(*$I POWTEN.PAS   *)
(*$I ALGAMA.PAS   *)
(*$I CDBETA.PAS   *)
(*$I BETAINV.PAS  *)
(*$I SIGT.PAS     *)
(*$I TINV.PAS     *)

BEGIN (* TestInvt *)

   Done := FALSE;
   ClrScr;

   REPEAT

      WRITE('Enter tail probability value and degrees of freedom: ');
      READLN( P , Df );

      IF ( P > 0.0 ) THEN
         BEGIN
            t1     := Tinv( P , Df );
            t2     := Tinv( P / 2.0 , Df );
            WRITELN('One-tailed percentage point = ',t1:12:5);
            WRITELN('Two-tailed percentage point = ',t2:12:5);
         END
      ELSE
         Done := TRUE;

   UNTIL Done;


END   (* TestInvt *).