(*--------------------------------------------------------------------------*)
(*                 TestInvC --- Test inverse chi-square                     *)
(*--------------------------------------------------------------------------*)

PROGRAM TestInvC;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*   Program:  TestInvC                                                     *)
(*                                                                          *)
(*   Purpose:  Demonstrate inverse chi-square routine in PIBSIGS            *)
(*                                                                          *)
(*   Usage:    This program prompts for a p-value and degrees of freedom.   *)
(*             It computes and prints the corresponding percentage point    *)
(*             of the chi-square distribution.   Note:  the input           *)
(*             probability is the tail value, not the cumulative value.     *)
(*                                                                          *)
(*             To stop the program, enter a negative p-value.               *)
(*                                                                          *)
(*   Calls:    Cinv                                                         *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   Chisq:    REAL;
   Df:       REAL;
   P:        REAL;
   Done:     BOOLEAN;
   Ierr:     INTEGER;

(*$I SIGCONST.PAS *)
(*$I LOGTEN.PAS   *)
(*$I POWER.PAS    *)
(*$I POWERI.PAS   *)
(*$I POWTEN.PAS   *)
(*$I ALGAMA.PAS   *)
(*$I GAMMAIN.PAS  *)
(*$I SIGCHI.PAS   *)
(*$I NINV.PAS     *)
(*$I CINV.PAS     *)

BEGIN (* TestInvC *)

   Done := FALSE;
   ClrScr;

   REPEAT

      WRITE('Enter tail probability value and degrees of freedom: ');
      READLN( P , Df );

      IF ( P > 0.0 ) THEN
         BEGIN
            Chisq := Cinv( P , Df , Ierr );
            WRITELN('Chi-square percentage point = ',Chisq:12:5);
         END
      ELSE
         Done := TRUE;

   UNTIL Done;


END   (* TestInvC *).