{----------------------------------------------------------------------------
 |  Program DEMOV2.PAS                                                      |
 |                                                                          |
 |  This program demonstrates some of the capabilities of TPHRT V2.00       |
 |                                                                          |
 |  (c) 1988 Ryle Design, P.O. Box 22, Mt. Pleasant, Michigan 48804         |
 ----------------------------------------------------------------------------}

uses
    CRT, TPHRT;

var
    hits, elapsed : longint;
    indx          : integer;


procedure sin_funct;
{----------------------------------------------------------------------------
 |  A simple procedure to time.   TPHRT will tell us how many this function |
 |  was called and how much time we spent here.                             |
 |                                                                          |
 |  Globals referenced: none                                                |
 |                                                                          |
 |  Arguments: void                                                         |
 |                                                                          |
 |  Returns  : void                                                         |
 ----------------------------------------------------------------------------}
var
    alpha : real;

begin
    
    t_entry(3);                                             { start a timer }

    alpha := sin(2.2734593);                                { do something  }

    t_exit(3);                                              { stop timer    }

end; { sin_funct }


{---------------------------------------------------------------------------}


begin

    t_start;                                                { turns on TPHRT }
    t_entry(1);                                             { use  timer 1 to time whole run }

    writeln('TPHRT V2.00 demonstration');
    writeln('Press any key ... ');

    t_entry(2);                                             { start timer # 2 }

    while (keypressed = FALSE) do;                          { wait for key }

    t_exit(2);                                              { stop timer # 2 }

    t_ask_timer(2,hits,elapsed);                            { query timer # 2 }

    writeln('Response time was ',elapsed,' microseconds, or ',(elapsed/1000000.0):10:6,' seconds.');

    write('Calling sin function with embedded timer 100 times ... ');
    for indx := 1 to 100 do sin_funct;
    writeln('complete.');

    t_exit(1);                                              { shut down main timer }
    t_stop;                                                 { disable TPHRT }

    t_rname('TPHRT Demonstration');                         { title timer report }
    t_name(1,'Total run time');                             { give each timer a name }
    t_name(2,'Keyboard response');
    t_name(3,'sin function');
    
    t_report(0);                                            { do report - 0 goes to CRT }

    writeln('TPHRT demo complete.');

end. { demov2 }
    
