{ED'S PASCAL BEAUTIFIER v2.55}
{Copyright 1993 by Edward Lee}
{edlee@chinet.chi.il.us}
{Compile with Turbo Pascal v4.0 or later}

{To compile this program as a Protected Mode application}
{with Borland Pascal v7.0:}
{  bpc /cp epb}

{31Jan1990 20:00  Program begun}
{1 Feb1990 16:41}
{2 Feb1990 16:47  v1.0 complete  Capitalizes keywords}
{4 Feb1990 22:34  v1.1 complete  -Lower case option added}
{7 Feb1990 00:29  v1.2 complete  Non-alphabetic token padding added}
{  Identifier parsing debugged}
{25Mar1990 21:15  v1.3 maintenance   ) append rule modified;}
{ (***) parsing debugged; REGISTERS and TEXT keywords added}
{26May1990 16:56  v1.4 complete  optimized loop in identifier parsing}
{  Added identifier substitution option}
{7 Sep1991 13:03  v1.5 maintenance}
{  The inputfile and outputfile may have the same name.}
{  If only the inputfile is specified, the outputfile is assumed to have}
{  the same name unless -o to STDOUT is specified.}
{  An extension of .PAS is assumed for filenames if the extension is not}
{  specified.}
{24Nov1991 21:30  v1.51 maintenance  corrected minor typos}
{25Nov1991 06:45  v1.52 maintenance  corrected -i and -o options}
{v1.6x were experimental hashing versions}
{26Jan1992 23:15  v1.7}
{  Added -m option for Mixed-case keywords.}
{  The first instance of a user-defined identifier sets the precedent in}
{  capitalization for all further instances of that identifier.}
{24Feb1992 4:46  v1.71  Removed -Lowercase normalization for user identifiers}
{19Mar1992  v2.0  Many rules have been added or modified.  This version}
{  variably nests compound IF THEN ELSE, WHILE, FOR, REPEAT operations + more}
{02May1992  v2.1  Bugfix.  Added pops for nested, non-compound FOR DOs}
{                 and WHILE DOs.  Restored '(' padding.}
{14Jun1992  v2.2  Bugfix.  Corrected indentation of nested IF THEN ELSE}
{                 constructs, indentation of nested WHILE DO constructs}
{16Jun1992        Added an ElseIndent that is independent from IfIndent}
{                 to allow:  ElseIndent=0 }
{03Jul1992  v2.3  Replaced binary searches and insertion sorting with hybrid}
{                 radix/child-sibling trees for faster average performance.}
{04Jul1992  v2.31 Bugfix.  Corrected an underflow associated with the}
{                 conditional line break after a RECORD identifier}
{           v2.32 Modified indentation behavior after line breaks, Added}
{                 a conditional line break after the OF keyword}
{23Jul1992  v2.33 Bugfix.  Exponential real and hexadecimal constants}
{                 are now mostly invisible to the indentation and identifier}
{                 replacement routines.  I extend my apologies to anyone}
{                 who was inconvenienced by the previous lack of this context}
{                 sensitivity.}
{24Jul1992        Added another error message for a full directory}
{12Nov1992  v2.34 Made sure ELSE keywords are on their own lines}
{13Nov1992        Added PutThenOnItsOwnLine variable and ThenIndent constant}
{15Nov1992        Modified the order of some keywords in keylist[] }
{27Nov1992        Added support for an external keyword file}
{ 3Jan1993        Added the ability to specify indentations in an external}
{                 keyword file}
{                 Modified tree search routines for possibly faster performance}
{ 5Jan1993  v2.35 Added ElseIndentIf to allow ElseIndentIf:=0}
{ 6Jan1993        Added the ability to specify indentations on the command line}
{ 7Jan1993  v2.36 Bugfix.  Corrected indentation of WITH..DO IF}
{                          Corrected indentation of CASE..END END }
{ 8Jan1993  v2.37 Added support for nested PROCEDUREs and FUNCTIONs}
{ 9Jan1993        Bugfix.  Corrected indentation of CASE..ELSE..END}
{ 9Jan1993  v2.38 If matching parentheses (...) are broken across multiple}
{                 lines, then their contents are now aligned(!) to a depth of 1}
{                 (because higher depths can get messy)}
{                 Added ParenthesesDepth variable}
{10Jan1993  v2.39 Replaced the single identifier substitution routine with}
{                 a multiple substitution algorithm using the user identifier}
{                 tree}
{11Jan1993  v2.40 Added support for OBJECT; it is treated like a RECORD}
{                 Added support for ASM; it is treated as a BEGIN}
{                 Added support for CONSTRUCTOR and DESTRUCTOR; they are}
{                 treated like PROCEDURE}
{                 Added support for PROCEDURE and FUNCTION TYPEs}
{                 Added support for double-quoted literal strings}
{                 Added support for FORWARD and EXTERNAL PROCEDURE and
{                 FUNCTION declarations}
{                 Added support for INTERFACE and IMPLEMENTATION}
{                 Added support for INLINE directives}
{                 Bugfix. NULL operations after DO, THEN, and ELSE caused}
{                 unintended indentation on subsequent lines}
{13Jan1993        Added the ability to specify substitution pairs in}
{                 configuration files, aka keyword files}
{17Jan1993  v2.50 Added support for parentheses-nested CASE variant}
{                 record syntax}
{18Jan1993  v2.51 Added an indented line counter display}
{                 Renamed PutThenOnItsOwnLine to BreakThen}
{20Jan1993        Added -q quiet option to shut off the indented line counter}
{25Jan1993  v2.52 Added alignment of BEGIN..END after a CASE colon}
{                 Added alignment of IF, FOR, REPEAT, WHILE, CASE and WITH}
{                 commands after a CASE colon}
{           v2.53 Added a CASECOLONindent variable}
{27Mar1993  v2.54 Corrected handling of indentation options in lower case}
{                 Corrected CASE..OF:FOR indentation}
{                 Added support for the OTHERWISE keyword in generic Pascal}
{ 7June1993 v2.55 Added checks for out-of-memory conditions after getmem()}
{                 Corrected some misbehavior in procedure ReadConfigurationFile}

USES crt;

CONST
  nkeys = 263;     (* The number of keywords in keylist[] *)
  maxkeylen = 17;  (* The maximum length of any keyword in keylist[] *)
  
  (*
If you want to insert or delete key words in the  following list,  you must
make sure  that the  constant NKEYS  is updated  so that  it indicates  the
number of keywords in the list  and update  the value  of MAXKEYLEN  if any
inserted key word changes the maximum length of the keywords  in the  list.
The order of the key words no longer matters, except that placing  the most
frequent keys at the start of the list  may speed up the processing of your
source programs.
 *)
  
  keylist : ARRAY [1..nkeys] OF
  STRING [maxkeylen] =
  (
   'And', 'Array', 'Assign', 'Asm', 'AssignCRT', 'Abs', 'Absolute', 'Addr',
   'Append', 'Arc', 'Arctan', 'Begin', 'Boolean', 'Byte', 'Bar', 'Bar3D',
   'BlockRead', 'BlockWrite', 'Char', 'Const', 'Constructor', 'Case',
   'Chdir', 'Chr', 'Circle', 'ClearDevice', 'ClearViewport', 'Close',
   'CloseGraph', 'ClrEOL', 'ClrScr', 'Comp', 'Concat', 'Copy', 'Cos',
   'CSeg', 'Do', 'Div', 'Dec', 'Destructor', 'Delay', 'Delete', 'DelLine',
   'DetectGraph', 'DiskFree', 'DiskSize', 'Dispose', 'DOSExitCode',
   'Double', 'DownTo', 'DrawPoly', 'DSeg', 'Else', 'End', 'Eof', 'Eoln',
   'Ellipse', 'Erase', 'Exec', 'Exit', 'Exp', 'Extended', 'External',
   'For', 'Function', 'False', 'Forward', 'File', 'FilePos', 'FileSize',
   'FillChar', 'FillPoly', 'FindFirst', 'FindNext', 'FloodFill', 'Flush',
   'Frac', 'FreeMem', 'GetArcCoords', 'GetAspectRatio', 'GetBkColor',
   'GetColor', 'GetDate', 'GetDir', 'GetFattr', 'GetFillPattern',
   'GetFillSettings', 'GetFTime', 'GetGraphMode', 'GetImage', 'GetIntVec',
   'GetLineSettings', 'GetMaxColor', 'GetMaxX', 'GetMaxY', 'GetMem',
   'GetModeRange', 'GetPallette', 'GetPixel', 'GetTextSettings', 'GetTime',
   'GetViewSettings', 'GetX', 'GetY', 'Goto', 'GotoXY', 'GraphDefaults',
   'GraphErrorMesg', 'GraphResult', 'Halt', 'Hi', 'HighVideo', 'If',
   'Integer', 'Inc', 'ImageSize', 'Implementation', 'In', 'InitGraph',
   'InLine', 'Insert', 'InsLine', 'Int', 'Interface', 'Interrupt', 'Intr',
   'IOResult', 'KeyPressed', 'Keep', 'Label', 'Length', 'Line', 'LineRel',
   'LineTo', 'Ln', 'Lo', 'LongInt', 'LowVideo', 'Mod', 'Mark', 'MaxAvail',
   'MemAvail', 'MkDir', 'Move', 'MoveRel', 'MoveTo', 'MSDOS', 'Not', 'New',
   'Nil', 'NormVideo', 'NoSound', 'Of', 'Or', 'Odd', 'Ofs', 'Ord',
   'Object', 'Otherwise', 'OutText', 'OutTextXY', 'Procedure', 'Pointer',
   'Packed', 'PackTime', 'ParamCount', 'ParamStr', 'Pi', 'PieSlice', 'Pos',
   'Pred', 'Program', 'Ptr', 'PutImage', 'PutPixel', 'Real', 'Read',
   'ReadLn', 'Repeat', 'Record', 'ReadKey', 'Random', 'Randomize',
   'Rectangle', 'RegisterBGIFont', 'RegisterBGIDriver', 'Registers',
   'Release', 'Rename', 'Reset', 'RestoreCRTMode', 'Rewrite', 'RmDir',
   'Round', 'String', 'Seek', 'SeekEOF', 'SeekEOLn', 'Seg', 'Set',
   'SetActivePage', 'SetAllPalette', 'SetBkColor', 'SetColor', 'SetDate',
   'SetFAttr', 'SetFillPattern', 'SetFillStyle', 'SetFTime',
   'SetGraphBufSize', 'SetGraphMode', 'SetIntVec', 'SetLineStyle',
   'SetPalette', 'SetTextBuf', 'SetTextJustify', 'SetTextStyle', 'SetTime',
   'SetUserCharSize', 'SetViewPort', 'SetVisualPage', 'ShL', 'ShortInt',
   'ShR', 'Sin', 'Single', 'SizeOf', 'Sound', 'SPtr', 'Sqr', 'Sqrt',
   'SSeg', 'Str', 'Succ', 'Swap', 'Then', 'To', 'True', 'Type', 'Text',
   'TextBackground', 'TextColor', 'TextHeight', 'TextMode', 'TextWidth',
   'Trunc', 'Truncate', 'Until', 'Unit', 'UnpackTime', 'UpCase', 'Uses',
   'Var', 'Val',  'Write', 'WriteLn', 'While', 'Word', 'With', 'WhereX',
   'WhereY', 'Window', 'Xor'
   );
  
  sizebuf = 64512;
  (* If you want to conserve memory at the price of  speed, you  can reduce
   * sizebuf to any amount down to 1 (not recommended), change  the maximum
   * index of mybuf[] to the value sizebuf-1, and recompile the program.
   *)
  
TYPE
  mybuf = ARRAY [0..64511] OF
  CHAR;
  
  KeyNode = RECORD
              character : CHAR;
              index : WORD;
              sibling : POINTER;
              child : POINTER;
            END;
  
  KeyNodePtr = ^KeyNode;
  
  StringPtr = ^STRING;
  
  UserNode = RECORD
               character : CHAR;
               instance : StringPtr;
               sibling : POINTER;
               child : POINTER;
             END;
  
  UserNodePtr = ^UserNode;
  
VAR
  a, b              (* Input and Output buffer pointers *)
  : ^mybuf;
  
  FirstKeyTreeLevel  (* Using more space than absolutely necessary, for speed *)
  : ARRAY [#0..#255] OF
  KeyNode;
  
  FirstUserTreeLevel  (* Using more space than absolutely necessary, for speed *)
  : ARRAY [#0..#255] OF
  UserNode;
  
  IndentationStack
  : ARRAY [0..255] OF
  WORD;
  
  KeyStack
  : ARRAY [0..255] OF
  WORD;
  
  BreakThen, istream, LineIsClear, NormalizeKeysToUpperCase, ostream,
  showbrackcom, showparencom, quiet
  : BOOLEAN;
  
  BeginIndent, CaseIndent, CaseColonIndent, ConstIndent, ElseIndent, 
  ElseIndentIf, ForIndent, IfIndent, indentPROCEDURE, LabelIndent, 
  LeftmostBeginIndent, RecordIndent, RepeatIndent, ThenIndent, TypeIndent, 
  UntilIndent, VarIndent, WhileIndent, WithIndent, digit, cx, cy
  : BYTE;
  
  ch, lastch
  : CHAR;
  
  infile, outfile
  : FILE;
  
  HeapPtr
  : POINTER;
  
  ext, filename, iname, CurrentIdentifier, oname, SearchIdent, path,
  ReplacementIdent, s, UpCaseIdent
  : STRING;
  
  UPtr
  : UserNodePtr;
  
  col,  iasm, ibegin,  icase,  iconst,  iconstructor, idestructor, ido,
  ielse,  iend, iexternal, ifor, iforward, ifunction,  iif,
  iimplementation, iinline, iinterface, ilabel, iobject, iof, iotherwise,
  iprocedure, iprogram, irecord,  irepeat, ithen,  itype, iuntil, ivar,
  iwhile, iwith, ia, ib, iks,  is, nread, nwrit,  index, index1, lastindex,
  lastkey, i, j, len, ParenthesesDepth, LinesIndented
  : WORD;
  
LABEL
  findasterisk, out, start;
  
  (* Returns a pointer to a newly constructed child-sibling node *)
FUNCTION NewKeyNode (c : CHAR) : KeyNodePtr;
VAR
  p : KeyNodePtr;
BEGIN
  NEW (p);
  IF (p = NIL) THEN
     BEGIN
     WRITELN ('EPB: Out of memory');
     {$ifndef DPMI}
     RELEASE (HeapPtr);
     {$endif}
     HALT;
     END;
  
  p^.character := c;
  p^.index := 0;
  p^.sibling := NIL;
  p^.child := NIL;
  NewKeyNode := p;
END;

(* Returns a pointer to a newly constructed child-sibling node *)
FUNCTION NewUserNode (c : CHAR) : UserNodePtr;
VAR
  p : UserNodePtr;
BEGIN
  NEW (p);
  IF (p = NIL) THEN
     BEGIN
     WRITELN ('EPB: Out of memory');
     {$ifndef DPMI}
     RELEASE (HeapPtr);
     {$endif}
     HALT;
     END;
  
  p^.character := c;
  p^.instance := NIL;
  p^.sibling := NIL;
  p^.child := NIL;
  NewUserNode := p;
END;

(* Initialize the first level for the child-sibling trees *)
PROCEDURE InitFirstTreeLevels;
VAR
  i : WORD;
  c : CHAR;
BEGIN
  FOR i := 0 TO 255 DO
      BEGIN
      c := CHR (i);
      
      FirstKeyTreeLevel [c] .character := c;
      FirstKeyTreeLevel [c] .index := 0;
      FirstKeyTreeLevel [c] .sibling := NIL;
      FirstKeyTreeLevel [c] .child := NIL;
      
      FirstUserTreeLevel [c] .character := c;
      FirstUserTreeLevel [c] .instance := NIL;
      FirstUserTreeLevel [c] .sibling := NIL;
      FirstUserTreeLevel [c] .child := NIL;
      END;
END;  (* InitFirstLevels *)

(* Inserts a string in the Pascal Keyword Tree *)
PROCEDURE InsertKeyTree (s : STRING;
                         slot : INTEGER);
VAR
  uc : CHAR;
  i, len : WORD;
  p : KeyNodePtr;
LABEL
  loop;
BEGIN
  len := LENGTH (s);
  
  IF (len = 0) THEN  (* There is nothing to insert *)
     EXIT;
  
  uc := UPCASE (s [1]);
  
  IF (uc <> FirstKeyTreeLevel [uc] .character) THEN
     FirstKeyTreeLevel [uc] .character := uc;
  
  IF (len = 1) THEN
     BEGIN
     FirstKeyTreeLevel [uc] .index := slot;
     EXIT;
     END;
  
  i := 2;
  p := FirstKeyTreeLevel [uc] .child;
  
  IF (p = NIL) THEN  (* If the first child does not exist, create it *)
     BEGIN
     p := NewKeyNode (UPCASE (s [2]) );
     FirstKeyTreeLevel [uc] .child := p;
     END;
  
  loop :
  IF (UPCASE (s [i]) = p^.character) THEN
     BEGIN
     IF (i = len) THEN  (* Indicate the termination of the string *)
        BEGIN
        IF (p^.index = 0) THEN
           p^.index := slot;
        EXIT;
        END;
     
     (* Assert: i < len *)
     INC (i);
     IF (p^.child = NIL) THEN
        p^.child := NewKeyNode (UPCASE (s [i]) );
     p := p^.child;
     GOTO loop;
     END
  ELSE
     BEGIN
     IF (p^.sibling = NIL) THEN
        p^.sibling := NewKeyNode (UPCASE (s [i]) );
     p := p^.sibling;
     GOTO loop;
     END;
  
END;  (* InsertKeyTree *)


(* Determines whether or not a string is in the Pascal Keyword Tree *)
(* Returns an index to the keylist[] element on success, a 0 on failure *)
FUNCTION SearchKeyTree (s : STRING) : INTEGER;
VAR
  i, len : INTEGER;
  headnode, nextnode, prednode, parentnode, p : KeyNodePtr;
LABEL
  loop;
  
BEGIN
  len := LENGTH (s);
  
  IF (len = 0) THEN  (* Should a null string be considered to be present? *)
     BEGIN
     SearchKeyTree := 0;  (* In this program, no *)
     EXIT;
     END;
  
  IF (s [1] <> FirstKeyTreeLevel [s [1] ] .character) THEN
     BEGIN
     SearchKeyTree := 0;  (* Because the length of the string is >= 1 *)
     EXIT;
     END;
  
  IF (len = 1) THEN
     BEGIN
     IF (FirstKeyTreeLevel [s [1] ] .index = 0) THEN
        SearchKeyTree := 0
     ELSE
        SearchKeyTree := FirstKeyTreeLevel [s [1] ] .index;
     EXIT;
     END;
  
  i := 2;
  parentnode := @FirstKeyTreeLevel [s [1] ];
  p := parentnode^ .child;
  headnode := p;
  prednode := headnode;  (* To avoid a pipeline break in future processors *)
  
  IF (p = NIL) THEN
     BEGIN
     SearchKeyTree := 0;  (* Because the tree terminated early *)
     EXIT;
     END;
  
  loop :
  IF (s [i] = p^.character) THEN
     BEGIN
     IF (i = len) THEN  (* Stop searching *)
        BEGIN
        IF (p^.index = 0) THEN
           SearchKeyTree := 0
        ELSE
           BEGIN
           SearchKeyTree := p^.index;
           parentnode^.child := p;  (* Gamble on locality of reference *)
           nextnode := p^.sibling;  (* for faster future access *)
           p^.sibling := headnode;
           prednode^.sibling := nextnode;
           END;
        EXIT;
        END;
     
     (* Assert: i < len *)
     parentnode := p;
     p := p^.child;
     IF (p = NIL) THEN
        BEGIN
        SearchKeyTree := 0;  (* Because the tree terminated early *)
        EXIT;
        END;
     headnode := p;
     prednode := headnode;  (* To avoid a pipeline break in future processors *)
     INC (i);
     GOTO loop;
     END
  ELSE
     BEGIN
     prednode := p;
     p := p^.sibling;
     IF (p = NIL) THEN
        BEGIN
        SearchKeyTree := 0;  (* Because the tree terminated early *)
        EXIT;
        END;
     GOTO loop;
     END;
  
END;  (* SearchKeyTree *)


(* Inserts a string in the User Identifier Tree *)
PROCEDURE InsertUserTree (s : STRING);
VAR
  uc : CHAR;
  i, len : WORD;
  p : UserNodePtr;
LABEL loop;
BEGIN
  len := LENGTH (s);
  
  IF (len = 0) THEN  (* There is nothing to insert *)
     EXIT;
  
  uc := UPCASE (s [1]);
  
  IF (uc <> FirstUserTreeLevel [uc] .character) THEN
     FirstUserTreeLevel [uc] .character := uc;
  
  IF (len = 1) THEN
     BEGIN
     GETMEM (FirstUserTreeLevel [uc] .instance, 2);  (* 1 for the length indicator, 1 for the string *)
     IF (FirstUserTreeLevel [uc] .instance = NIL) THEN
        BEGIN
        WRITELN ('EPB: Out of memory.');
        HALT;
        END;
     FirstUserTreeLevel [uc] .instance^ := s;
     EXIT;
     END;
  
  i := 2;
  p := FirstUserTreeLevel [uc] .child;
  
  IF (p = NIL) THEN  (* If the first child does not exist, create it *)
     BEGIN
     p := NewUserNode (UPCASE (s [2]) );
     FirstUserTreeLevel [uc] .child := p;
     END;
  
  loop :
  IF (UPCASE (s [i]) = p^.character) THEN
     BEGIN
     IF (i = len) THEN  (* Indicate the termination of the string *)
        BEGIN
        IF (p^.instance = NIL) THEN
           BEGIN
           GETMEM (p^.instance, 1 + len);
           IF (p^.instance = NIL) THEN
              BEGIN
              WRITELN ('EPB: Out of memory.');
              HALT;
              END;
           p^.instance^ := s;
           END;
        EXIT;
        END;
     
     (* Assert: i < len *)
     INC (i);
     IF (p^.child = NIL) THEN
        p^.child := NewUserNode (UPCASE (s [i]) );
     p := p^.child;
     GOTO loop;
     END
  ELSE
     BEGIN
     IF (p^.sibling = NIL) THEN
        p^.sibling := NewUserNode (UPCASE (s [i]) );
     p := p^.sibling;
     GOTO loop;
     END;
  
END;  (* InsertUserTree *)


(* Determines whether or not a string is in the User Identifier Tree *)
(* Returns a pointer to the final node on success, a NIL pointer on failure *)
FUNCTION SearchUserTree (s : STRING) : UserNodePtr;
VAR
  i, len : INTEGER;
  parentnode, headnode, prednode, nextnode, p : UserNodePtr;
LABEL
  loop;
BEGIN
  len := LENGTH (s);
  
  IF (len = 0) THEN  (* Should a null string be considered to be present? *)
     BEGIN
     SearchUserTree := NIL;  (* In this program, no *)
     EXIT;
     END;
  
  IF (s [1] <> FirstUserTreeLevel [s [1] ] .character) THEN
     BEGIN
     SearchUserTree := NIL;  (* Because the length of the string is >= 1 *)
     EXIT;
     END;
  
  IF (len = 1) THEN
     BEGIN
     IF (FirstUserTreeLevel [s [1] ] .instance = NIL) THEN
        SearchUserTree := NIL
     ELSE
        SearchUserTree := @FirstUserTreeLevel [s [1] ];
     EXIT;
     END;
  
  i := 2;
  parentnode := @FirstUserTreeLevel [s [1] ];
  p := parentnode^ .child;
  headnode := p;
  prednode := headnode;  (* To avoid a pipeline break in future processors *)
  
  IF (p = NIL) THEN
     BEGIN
     SearchUserTree := NIL;  (* Because the tree terminated early *)
     EXIT;
     END;
  
  loop :
  IF (s [i] = p^.character) THEN
     BEGIN
     IF (i = len) THEN  (* Stop searching *)
        BEGIN
        IF (p^.instance = NIL) THEN
           SearchUserTree := NIL
        ELSE
           BEGIN
           SearchUserTree := p;
           parentnode^.child := p;  (* Gamble on locality of reference *)
           nextnode := p^.sibling;  (* for faster future access *)
           p^.sibling := headnode;
           prednode^.sibling := nextnode;
           END;
        EXIT;
        END;
     
     (* Assert: i < len *)
     parentnode := p;
     p := p^. child;
     IF (p = NIL) THEN
        BEGIN
        SearchUserTree := NIL;  (* Because the tree terminated early *)
        EXIT;
        END;
     headnode := p;
     prednode := headnode;  (* To avoid a pipeline break in future processors *)
     INC (i);
     GOTO loop;
     END
  ELSE
     BEGIN
     prednode := p;
     p := p^.sibling;
     IF (p = NIL) THEN
        BEGIN
        SearchUserTree := NIL;  (* Because the tree terminated early *)
        EXIT;
        END;
     GOTO loop;
     END;
  
END;  (* SearchUserTree *)

(* Inserts a string, r, in the User Identifier Tree *)
PROCEDURE InsertReplacementInUserTree (s, r : STRING);
VAR
  uc : CHAR;
  i, len : WORD;
  p : UserNodePtr;
LABEL loop;
BEGIN
  len := LENGTH (s);
  
  IF (len = 0) THEN  (* There is nothing to insert *)
     EXIT;
  
  uc := UPCASE (s [1]);
  
  IF (uc <> FirstUserTreeLevel [uc] .character) THEN
     FirstUserTreeLevel [uc] .character := uc;
  
  IF (len = 1) THEN
     BEGIN
     GETMEM (FirstUserTreeLevel [uc] .instance, 1 + LENGTH (r) );  (* 1 for the length indicator *)
     IF (FirstUserTreeLevel [uc] .instance = NIL) THEN
        BEGIN
        WRITELN ('EPB: Out of memory.');
        HALT;
        END;
     FirstUserTreeLevel [uc] .instance^ := r;
     EXIT;
     END;
  
  i := 2;
  p := FirstUserTreeLevel [uc] .child;
  
  IF (p = NIL) THEN  (* If the first child does not exist, create it *)
     BEGIN
     p := NewUserNode (UPCASE (s [2]) );
     FirstUserTreeLevel [uc] .child := p;
     END;
  
  loop :
  IF (UPCASE (s [i]) = p^.character) THEN
     BEGIN
     IF (i = len) THEN  (* Indicate the termination of the string *)
        BEGIN
        IF (p^.instance = NIL) THEN
           BEGIN
           GETMEM (p^.instance, 1 + LENGTH (r) );
           IF (p^.instance = NIL) THEN
              BEGIN
              WRITELN ('EPB: Out of memory.');
              HALT;
              END;
           p^.instance^ := r;
           END;
        EXIT;
        END;
     
     (* Assert: i < len *)
     INC (i);
     IF (p^.child = NIL) THEN
        p^.child := NewUserNode (UPCASE (s [i]) );
     p := p^.child;
     GOTO loop;
     END
  ELSE
     BEGIN
     IF (p^.sibling = NIL) THEN
        p^.sibling := NewUserNode (UPCASE (s [i]) );
     p := p^.sibling;
     GOTO loop;
     END;
  
END;  (* InsertReplacementInUserTree *)

{$F+}
FUNCTION HeapFunc (size : WORD) : INTEGER; {$F-}
BEGIN
  HeapFunc := 1;  (* Make NEW return a NIL pointer when out of memory *)
END;

PROCEDURE PushIndent (indent : WORD);
BEGIN
  IF (is < 256) THEN
     BEGIN
     INC (is);
     IndentationStack [is] := IndentationStack [is - 1] + indent;
     END;
END;

PROCEDURE PopIndent;
BEGIN
  IF (is > 0) THEN
     DEC (is);
END;

PROCEDURE PushKey (key : WORD);
BEGIN
  IF (iks < 256) THEN
     BEGIN
     INC (iks);
     KeyStack [iks] := key;
     END;
END;

PROCEDURE PopKey;
BEGIN
  IF (iks > 0) THEN
     DEC (iks);
END;

PROCEDURE writeblock;
BEGIN
  BLOCKWRITE (outfile, b^, ib, nwrit);
  
  IF (nwrit <> ib) AND (oname <> '') THEN  (* Don't check output to STDOUT *)
     BEGIN
     WRITELN ('EPB:  Cannot finish outputting (out of disk space?)');
     CLOSE (infile);
     CLOSE (outfile);
     {$ifndef DPMI}
     RELEASE (HeapPtr);
     {$endif}
     HALT;
     END;
  
  ib := 0;
END;  (* writeblock *)

PROCEDURE getblock;
BEGIN
  ia := 0;
  BLOCKREAD (infile, a^, sizebuf, nread);
  
  IF (nread = 0) THEN
     BEGIN
     writeblock;
     CLOSE (infile);
     CLOSE (outfile);
     {$ifndef DPMI}
     RELEASE (HeapPtr);
     {$endif}
     IF (NOT quiet) THEN
        BEGIN
        GOTOXY (cx, cy);
        WRITE (LinesIndented : 9);
        END;
     HALT;
     END;
END;  (* getblock *)

PROCEDURE OutPaddedChar (c : CHAR);  (* Output a character, possibly w/ padding *)
BEGIN
  CASE c OF
       '[', '(', '<', '+', '/', '*', '-', ':' :
         IF (lastch <> #32) THEN
            BEGIN
            b^ [ib] := #32;
            INC (ib);
            IF (ib = sizebuf) THEN
               writeblock;
            INC (col);
            END;
       
       '=' :
         IF (lastch > #32) AND
            (lastch <> ':') AND (lastch <> '<') AND (lastch <> '>') THEN
            BEGIN
            b^ [ib] := #32;
            INC (ib);
            IF (ib = sizebuf) THEN
               writeblock;
            INC (col);
            END;
       
       '>' :
         IF (lastch > #32) AND
            (lastch <> '<') THEN
            BEGIN
            b^ [ib] := #32;
            INC (ib);
            IF (ib = sizebuf) THEN
               writeblock;
            INC (col);
            END;
       
       ')' :
         IF (lastch = ')') THEN
            BEGIN
            b^ [ib] := #32;
            INC (ib);
            IF (ib = sizebuf) THEN
               writeblock;
            INC (col);
            END;
       
  ELSE  (* case c *)
       
  IF (c > #32) THEN
     CASE lastch OF
          ':' :
            IF (c <> '=') THEN
               BEGIN
               b^ [ib] := #32;
               INC (ib);
               IF (ib = sizebuf) THEN
                  writeblock;
               INC (col);
               END;
          
          '<' :
            IF (c <> '>') AND (c <> '=') THEN
               BEGIN
               b^ [ib] := #32;
               INC (ib);
               IF (ib = sizebuf) THEN
                  writeblock;
               INC (col);
               END;
          
          '>' :
            IF (c <> '=') THEN
               BEGIN
               b^ [ib] := #32;
               INC (ib);
               IF (ib = sizebuf) THEN
                  writeblock;
               INC (col);
               END;
          
          ')' :
            IF (c <> ';') AND (c <> ',') THEN
               BEGIN
               b^ [ib] := #32;
               INC (ib);
               IF (ib = sizebuf) THEN
                  writeblock;
               INC (col);
               END;
          
          '=', '+', '/', '*', '-', ',' :
            BEGIN
            b^ [ib] := #32;
            INC (ib);
            IF (ib = sizebuf) THEN
               writeblock;
            INC (col);
            END;
          
          ']' :
            IF (c <> ')') AND (c <> ';') AND (c <> ',') AND (c <> '^') THEN
               BEGIN
               b^ [ib] := #32;
               INC (ib);
               IF (ib = sizebuf) THEN
                  writeblock;
               INC (col);
               END;
          
     END;  (* case lastch *)
  END;  (* case c *)
  
  b^ [ib] := c;
  INC (ib);
  IF (ib = sizebuf) THEN
     writeblock;
  INC (col);
  LineIsClear := (LineIsClear AND (c <= #32) );
  lastch := c;
END;  (* OutPaddedChar *)

PROCEDURE OutLiteralChar (c : CHAR);  (* Output a character without padding *)
BEGIN
  b^ [ib] := c;
  INC (ib);
  IF (ib = sizebuf) THEN
     writeblock;
  INC (col);
  LineIsClear := (LineIsClear AND (c <= #32) );
  lastch := c;
END;  (* OutLiteralChar *)

PROCEDURE OutIdent (s : STRING);  (* Output an identifier *)
VAR
  i, len
  : INTEGER;
BEGIN
  len := LENGTH (s);
  IF (len <> 0) THEN
     OutPaddedChar (s [1]);
  
  FOR i := 2 TO len DO
      BEGIN
      b^ [ib] := s [i];
      INC (ib);
      IF (ib = sizebuf) THEN
         writeblock;
      INC (col);
      END;
  
  lastch := s [len];
END;  (* OutIdent *)

(* Split up a Path, Filename, Extension string *)
PROCEDURE SplitPFE (pf : STRING;
                    VAR p : STRING;
                    VAR f : STRING;
                    VAR e : STRING);
VAR i : INTEGER;
BEGIN
  p := '';
  f := '';
  e := '';
  i := LENGTH (pf);
  
  WHILE ( (POS (COPY (pf, i, 1), ':/\') = 0) AND (i > 0) ) DO
        DEC (i);
  
  p := COPY (pf, 1, i);
  f := COPY (pf, i + 1, 255);
  
  i := POS ('.', f);
  
  IF (i > 0) THEN
     BEGIN
     e := COPY (f, i + 1, 3);
     f := COPY (f, 1, i);
     END;
END;

PROCEDURE breakline;
BEGIN
  b^ [ib] := #13;
  INC (ib);
  IF (ib = sizebuf) THEN
     writeblock;
  b^ [ib] := #10;
  INC (ib);
  IF (ib = sizebuf) THEN
     writeblock;
  lastch := #10;
  col := 0;
  LineIsClear := TRUE;
END;

PROCEDURE skipwhitespace;
BEGIN
  WHILE (a^ [ia] < #33) DO
        BEGIN
        INC (ia);
        IF (ia >= nread) THEN
           getblock;
        END;
END;  (* skipwhitespace *)

PROCEDURE skipspace;
BEGIN
  WHILE (a^ [ia] < #33) AND (a^ [ia] <> #13) AND (a^ [ia] <> #10) DO
        BEGIN
        INC (ia);
        IF (ia >= nread) THEN
           getblock;
        END;
END;  (* skipspace *)

PROCEDURE indent;
VAR i : WORD;
BEGIN
  IF (NOT quiet) THEN
     BEGIN
     GOTOXY (cx, cy);
     INC (LinesIndented);
     IF (LinesIndented MOD 16) = 0 THEN  (* Display in intervals of 16 *)
        WRITE (LinesIndented : 9);
     END;
  
  FOR i := 1 TO IndentationStack [is] DO
      BEGIN
      b^ [ib] := #32;
      INC (ib);
      IF (ib = sizebuf) THEN
         writeblock;
      END;
  
  IF (IndentationStack [is] <> 0) THEN  (* Keep track of the current column *)
     BEGIN
     col := col + IndentationStack [is];
     lastch := #32;
     END;
END;  (* indent *)

PROCEDURE condbreakline;
VAR
  ch : CHAR;
  s : STRING;
  i, len : WORD;
BEGIN
  ch := a^ [ia];
  IF (ch <> #13) THEN
     BEGIN
     s := '';
     WHILE (a^ [ia] < #33) AND (a^ [ia] <> #13) AND (a^ [ia] <> #10) DO
           BEGIN
           s := s + a^ [ia];  (* Save spaces *)
           INC (ia);
           IF (ia >= nread) THEN
              getblock;
           END;
     len := LENGTH (s);
     ch := a^ [ia];
     IF (ch = '(') OR (ch = '{') THEN
        FOR i := 1 TO len DO  (* Write saved spaces *)
            BEGIN
            b^ [ib] := s [i];
            INC (ib);
            IF (ib = sizebuf) THEN
               writeblock;
            INC (col);
            END
     ELSE
        breakline;
     END;
END;  (* condbreakline *)

(* Returns the upper case form of a string *)
FUNCTION UpStr (s : STRING) : STRING;
VAR
  TempStr : STRING;
  i : INTEGER;
BEGIN
  TempStr := '';
  FOR i := 1 TO LENGTH (s) DO
      TempStr := TempStr + UPCASE (s [i]);
  UpStr := TempStr;
END;  (* UpStr *)


PROCEDURE ReadConfigurationFile;
LABEL 1;
VAR
  digit : BYTE;
  SearchStr, ReplacementStr : STRING;
  
  (* All of the following nested functions return TRUE when EOF is reached *)
  FUNCTION getblock : BOOLEAN;
  BEGIN
    ia := 0;
    BLOCKREAD (infile, a^, sizebuf, nread);
    IF (nread = 0) THEN
       BEGIN
       CLOSE (infile);
       getblock := TRUE;
       EXIT;
       END;
    getblock := FALSE;
  END;  (* getblock *)

  FUNCTION skipspace : BOOLEAN;
  BEGIN
    WHILE (a^ [ia] < #33) AND (a^ [ia] <> #13) AND (a^ [ia] <> #10) DO
          BEGIN
          INC (ia);
          IF (ia >= nread) THEN
             IF (getblock) THEN
                BEGIN
                skipspace := TRUE;
                EXIT;
                END;
          END;
    skipspace := FALSE;
  END;  (* skipspace *)

  FUNCTION GetIdentifier (VAR s : STRING) : BOOLEAN;
  BEGIN
    s := '';
    IF skipspace THEN
       BEGIN
       GetIdentifier := TRUE;
       EXIT;
       END;
    ch := a^ [ia];
    IF ( (ch >= 'A') AND (ch <= 'Z') ) OR
       ( (ch >= 'a') AND (ch <= 'z') ) OR
       (ch = '_') THEN
       BEGIN
       REPEAT
         s := s + ch;
         INC (ia);
         IF (ia >= nread) THEN
            IF (getblock) THEN
               BEGIN
               GetIdentifier := TRUE;
               EXIT;
               END;
         ch := a^ [ia];
       UNTIL ( (ch < 'A') OR (ch > 'Z') ) AND
             ( (ch < 'a') OR (ch > 'z') ) AND
             ( (ch < '0') OR (ch > '9') ) AND
             (ch <> '_');
       END;  (* if *)
    GetIdentifier := FALSE;
  END;  (* GetIdentifier *)

  FUNCTION GetField (VAR s : STRING) : BOOLEAN;
  BEGIN
    s := '';
    IF skipspace THEN
       BEGIN
       GetField := TRUE;
       EXIT;
       END;
    ch := a^ [ia];
    WHILE (ch <> #32) AND (ch <> #13) AND (ch <> #10) DO
          BEGIN
          s := s + ch;
          INC (ia);
          IF (ia >= nread) THEN
             IF (getblock) THEN
                BEGIN
                GetField := TRUE;
                EXIT;
                END;
          ch := a^ [ia];
          END;  (* while *)
    GetField := FALSE;
  END;  (* GetField *)

  FUNCTION GetEquate : BOOLEAN;
  BEGIN
    IF (ch = '=') THEN
       BEGIN
       REPEAT
         INC (ia);
         IF (ia >= nread) THEN
            BEGIN
            ia := 0;
            BLOCKREAD (infile, a^, sizebuf, nread);
            IF (nread = 0) THEN
               BEGIN
               CLOSE (infile);
               GetEquate := TRUE;
               EXIT;
               END;
            END;
         ch := a^ [ia];
       UNTIL (ch >= '0') AND (ch <= '9');
       digit := ORD (ch) - ORD ('0');
       IF (CurrentIdentifier = 'BEGININDENT') THEN
          BeginIndent := digit
       ELSE
       IF (CurrentIdentifier = 'CASECOLONINDENT') THEN
          CaseColonIndent := digit
       ELSE
       IF (CurrentIdentifier = 'CASEINDENT') THEN
          CaseIndent := digit
       ELSE
       IF (CurrentIdentifier = 'CONSTINDENT') THEN
          ConstIndent := digit
       ELSE
       IF (CurrentIdentifier = 'ELSEINDENT') THEN
          ElseIndent := digit
       ELSE
       IF (CurrentIdentifier = 'ELSEINDENTIF') THEN
          ElseIndentIf := digit
       ELSE
       IF (CurrentIdentifier = 'FORINDENT') THEN
          ForIndent := digit
       ELSE
       IF (CurrentIdentifier = 'IFINDENT') THEN
          IfIndent := digit
       ELSE
       IF (CurrentIdentifier = 'LABELINDENT') THEN
          LabelIndent := digit
       ELSE
       IF (CurrentIdentifier = 'LEFTMOSTBEGININDENT') THEN
          LeftmostBeginIndent := digit
       ELSE
       IF (CurrentIdentifier = 'INDENTPROCEDURE') THEN
          indentPROCEDURE := digit
       ELSE
       IF (CurrentIdentifier = 'RECORDINDENT') THEN
          RecordIndent := digit
       ELSE
       IF (CurrentIdentifier = 'REPEATINDENT') THEN
          RepeatIndent := digit
       ELSE
       IF (CurrentIdentifier = 'THENINDENT') THEN
          ThenIndent := digit
       ELSE
       IF (CurrentIdentifier = 'TYPEINDENT') THEN
          TypeIndent := digit
       ELSE
       IF (CurrentIdentifier = 'UNTILINDENT') THEN
          UntilIndent := digit
       ELSE
       IF (CurrentIdentifier = 'VARINDENT') THEN
          VarIndent := digit
       ELSE
       IF (CurrentIdentifier = 'WHILEINDENT') THEN
          WhileIndent := digit
       ELSE
       IF (CurrentIdentifier = 'WITHINDENT') THEN
          WithIndent := digit;
       END; (* if *)
    GetEquate := FALSE;
  END;  (* GetEquate *)

  FUNCTION GetFlag : BOOLEAN;
  VAR i : WORD;
  BEGIN
    IF (CurrentIdentifier [1] <> '-') THEN
       InsertUserTree (CurrentIdentifier)
    ELSE
       BEGIN
       CurrentIdentifier := UpStr (COPY (CurrentIdentifier, 2, 255) );
       IF (CurrentIdentifier = 'BREAKTHEN') THEN
          BreakThen := TRUE
       ELSE
       IF (CurrentIdentifier <> 'BEGININDENT') AND
          (CurrentIdentifier <> 'CASECOLONINDENT') AND
          (CurrentIdentifier <> 'CASEINDENT') AND
          (CurrentIdentifier <> 'CONSTINDENT') AND
          (CurrentIdentifier <> 'ELSEINDENT') AND
          (CurrentIdentifier <> 'ELSEINDENTIF') AND
          (CurrentIdentifier <> 'FORINDENT') AND
          (CurrentIdentifier <> 'IFINDENT') AND
          (CurrentIdentifier <> 'LABELINDENT') AND
          (CurrentIdentifier <> 'LEFTMOSTBEGININDENT') AND
          (CurrentIdentifier <> 'INDENTPROCEDURE') AND
          (CurrentIdentifier <> 'RECORDINDENT') AND
          (CurrentIdentifier <> 'REPEATINDENT') AND
          (CurrentIdentifier <> 'THENINDENT') AND
          (CurrentIdentifier <> 'TYPEINDENT') AND
          (CurrentIdentifier <> 'UNTILINDENT') AND
          (CurrentIdentifier <> 'VARINDENT') AND
          (CurrentIdentifier <> 'WHILEINDENT') AND
          (CurrentIdentifier <> 'WITHINDENT') THEN
          FOR i := 1 TO LENGTH (CurrentIdentifier) DO
              BEGIN
              IF (CurrentIdentifier [i] = 'M') THEN
                 NormalizeKeysToUpperCase :=  FALSE
              ELSE
              IF (CurrentIdentifier [i] = 'S') THEN
                 BEGIN
                 IF GetIdentifier (SearchStr) THEN
                    BEGIN
                    GetFlag := TRUE;
                    EXIT;
                    END;
                 IF GetField (ReplacementStr) THEN
                    BEGIN
                    GetFlag := TRUE;
                    EXIT;
                    END;
                 InsertReplacementInUserTree (SearchStr, ReplacementStr);
                 END
              ELSE
              IF (CurrentIdentifier [i] = 'I') THEN
                 istream := TRUE
              ELSE
              IF (CurrentIdentifier [i] = 'O') THEN
                 BEGIN
                 ostream := TRUE;
                 quiet := TRUE;
                 END
              ELSE
              IF (CurrentIdentifier [i] = 'B') THEN
                 showbrackcom := FALSE
              ELSE
              IF (CurrentIdentifier [i] = 'P') THEN
                 showparencom := FALSE
              ELSE
              IF (CurrentIdentifier [i] = 'Q') THEN
                 quiet := TRUE;
              END; (* for *)
       END;  (* if *)
    GetFlag := FALSE;
  END;  (* GetFlag *)

BEGIN  (* ReadConfigurationFile *)
  ASSIGN (infile, s);
  {$I-}
  RESET (infile, 1); {$I+}
  IF (IORESULT <> 0) THEN
     BEGIN
     WRITELN ('EPB:  Cannot open configuration file, ', s);
     HALT;
     END;
  
  IF getblock THEN
     EXIT;
  
  1 :
  ch := a^ [ia];
  IF ( (ch >= 'A') AND (ch <= 'Z') ) OR
     ( (ch >= 'a') AND (ch <= 'z') ) OR
     (ch = '_') OR (ch = '-') THEN
     BEGIN
     CurrentIdentifier := '';
     REPEAT
       CurrentIdentifier := CurrentIdentifier + ch;
       INC (ia);
       IF (ia >= nread) THEN
          BEGIN
          ia := 0;
          BLOCKREAD (infile, a^, sizebuf, nread);
          IF (nread = 0) THEN
             BEGIN
             IF GetFlag THEN
                EXIT;
             IF GetEquate THEN
                EXIT;
             CLOSE (infile);
             EXIT;
             END;
          END;
       ch := a^ [ia];
     UNTIL ( (ch < 'A') OR (ch > 'Z') ) AND
           ( (ch < 'a') OR (ch > 'z') ) AND
           ( (ch < '0') OR (ch > '9') ) AND
           (ch <> '_');
     
     IF GetFlag THEN
        EXIT;
     END;
  
  IF GetEquate THEN
     EXIT;
  
  INC (ia);
  IF (ia >= nread) THEN
     BEGIN
     ia := 0;
     BLOCKREAD (infile, a^, sizebuf, nread);
     IF (nread = 0) THEN
        BEGIN
        CLOSE (infile);
        EXIT;
        END;
     END;
  
  GOTO 1;
END;  (* ReadConfigurationFile *)

PROCEDURE more;
VAR ch : CHAR;
BEGIN
  WRITE ('(MORE)');
  ch := READKEY;
  WRITE (#13'      '#13);
END;

{---- MAIN PROGRAM ----}
BEGIN
  (* Indentations after various keywords, in spaces *)
  BeginIndent := 0;   (* See LeftmostBeginIndent, below *)
  CaseColonIndent := 2;
  CaseIndent := 5;
  ConstIndent := 2;
  ElseIndent := 3;
  ElseIndentIf := 0;
  ForIndent := 4;
  IfIndent := 3;
  LabelIndent := 2;
  LeftmostBeginIndent := 2;
  indentPROCEDURE := 2;
  RecordIndent := 2;
  RepeatIndent := 2;
  ThenIndent := 0;
  TypeIndent := 2;
  UntilIndent := 6;
  VarIndent := 2;
  WhileIndent := 6;
  WithIndent := 5;
  
  IF (PARAMCOUNT = 0) THEN
     BEGIN
     WRITELN ('ED''S PASCAL BEAUTIFIER v2.55, Copyright 1993 by Edward Lee, All Rights Reserved');
     WRITELN ('edlee@chinet.chi.il.us        THIS PROGRAM MAY NOT BE DISTRIBUTED FOR PROFIT');
     WRITELN;
     WRITELN ('EPB formats (Turbo) Pascal source code, including complicated IF THEN  ELSE');
     WRITELN ('constructs,  and   standardizes  the   capitalization  of   (Turbo)  Pascal');
     WRITELN ('identifiers.  The capitalization of  (Turbo) Pascal  key words  defaults to');
     WRITELN ('upper case.  The first instance of  each non-(Turbo)  Pascal identifier  or');
     WRITELN ('identifier  that  is not  specified in  a configuration  file will  set the');
     WRITELN ('standard for its later capitalization.');
     WRITELN;
     WRITELN ('Invocation parameters may be in any order.  The square brackets  [ ]  below');
     WRITELN ('indicate  optional  parameters,  and  the ellipses  ...  indicate  possible');
     WRITELN ('iterations.   You  can  specify  multiple configuration  files or  multiple');
     WRITELN ('substitution pairs.  Neither the square brackets or the ellipses are  meant');
     WRITELN ('to be entered from the keyboard:');
     WRITELN;
     WRITELN (' EPB [-OPTIONS]  [INPUT_file[.PAS]]  [OUTPUT_file[.PAS]]');
     WRITELN ('     [Configuration_file.CFG] ...');
     WRITELN ('     [-s  Original_identifier  Replacement_string] ...');
     WRITELN;
     WRITELN ('OPTIONS are flexible in case, grouping, and positioning on the command line:');
     WRITELN (' -m  Normalize all key words to Mixed case rather than the default upper case');
     WRITELN (' -i  Use the standard Input  (StdIn)  stream for input  instead of InputFile');
     WRITELN (' -o  Use the standard Output (StdOut) stream for output instead of OutputFile');
     more;
     WRITELN (' -s  Search for and Substitute all occurrences of an Original_identifier');
     WRITELN ('     with a Replacement_string during formatting.  Partial string matches,');
     WRITELN ('     comments, and literal strings  are ignored.   A Replacement_string');
     WRITELN ('     does not have to be another identifier.  The Replacement_string can be');
     WRITELN ('     a reserved Pascal word surrounded by print codes to highlight the');
     WRITELN ('     reserved word on a printed copy, for example.');
     WRITELN (' -b  Shut off the output of Bracket comments:  { ... }');
     WRITELN (' -p  Shut off the output of Parentheses comments:  (* ... *)');
     WRITELN (' -q  Quiet.  Makes EPB not show the number of lines that have been indented.');
     WRITELN;
     WRITELN ('INDENTATION CONTROL OPTIONS are  case insensitive.   Below, X  is a  number');
     WRITELN ('from 0 to 9  to let  EPB know  how many  spaces to  indent before  or after');
     WRITELN ('certain key words. Default values for X are shown in parentheses.');
     WRITELN;
     WRITELN (' -LeftmostBEGINindent=X (', LeftmostBeginIndent, ') Indentation after PROGRAM/PROCEDURE/FUNCTION..BEGIN');
     WRITELN ('                                           or CONSTRUCTOR/DESTRUCTOR  ..  BEGIN');
     WRITELN (' -BEGINindent=X         (', BeginIndent, ') Indentation after a nested BEGIN or ASM directive');
     WRITELN (' -CASECOLONindent=X     (', CaseColonIndent, ') Indentation after a ":" in CASE .. OF constant:op;');
     WRITELN (' -CASEindent=X          (', CaseIndent, ') Indentation after CASE');
     WRITELN (' -CONSTindent=X         (', ConstIndent, ') Indentation after CONST');
     WRITELN (' -ELSEindent=X          (', ElseIndent, ') Indentation after ELSE');
     WRITELN (' -ELSEindentIF=X        (', ElseIndentIf, ') Indentation after ELSE in an ELSE..IF');
     WRITELN (' -FORindent=X           (', ForIndent, ') Indentation after FOR');
     WRITELN (' -IFindent=X            (', IfIndent, ') Indentation after IF');
     more;
     WRITELN (' -LABELindent=X         (', LabelIndent, ') Indentation after LABEL');
     WRITELN (' -indentPROCEDURE=X     (', indentPROCEDURE, ') Indentation before nested PROCEDUREs and FUNCTIONs');
     WRITELN (' -RECORDindent=X        (', RecordIndent, ') Indentation after RECORD or OBJECT');
     WRITELN (' -REPEATindent=X        (', RepeatIndent, ') Indentation after REPEAT');
     WRITELN (' -THENindent=X          (', ThenIndent, ') Indentation after THEN.  Use with -breakTHEN');
     WRITELN (' -TYPEindent=X          (', TypeIndent, ') Indentation after TYPE');
     WRITELN (' -UNTILindent=X         (', UntilIndent, ') Indentation after UNTIL');
     WRITELN (' -VARindent=X           (', VarIndent, ') Indentation after VAR');
     WRITELN (' -WHILEindent=X         (', WhileIndent, ') Indentation after WHILE');
     WRITELN (' -WITHindent=X          (', WithIndent, ') Indentation after WITH');
     WRITELN (' -breakTHEN             Break the line before THEN if the line is not clear');
     WRITELN;
     WRITELN ('A configuration file may contain a list of the options above and a list  of ');
     WRITELN ('key words.  The key words in a configuration  file effectively  replace any ');
     WRITELN ('identical key  words such  as "Procedure"  and "WriteLn"  that are  already ');
     WRITELN ('built into EPB.  If you do not want all key words to  appear in  upper case ');
     WRITELN ('in formatted source code, then insert  a "-m"  in a  configuration file  or ');
     WRITELN ('specify the "-m" option on the command line.');
     HALT;
     END;
  
  HeapError := @HeapFunc;
  
  {$ifndef DPMI}
  MARK (HeapPtr);
  {$endif}
  
  NEW (a);
  NEW (b);
  
  IF (a = NIL) OR (b = NIL) THEN
     BEGIN
     WRITELN ('EPB: There is not enough free conventional memory for EPB to run.');
     {$ifndef DPMI}
     RELEASE (HeapPtr);
     {$endif}
     HALT;
     END;
  
  InitFirstTreeLevels;
  
  (* Copy keylist[] in a normalized form to the Key Tree *)
  FOR i := 1 TO nkeys DO
      InsertKeyTree (keylist [i], i);
  
  cx := WHEREX;
  cy := WHEREY;
  showparencom := TRUE;
  showbrackcom := TRUE;
  istream := FALSE;
  ostream := FALSE;
  quiet := FALSE;
  NormalizeKeysToUpperCase := TRUE;
  BreakThen := FALSE;
  
  SearchIdent := '';
  ReplacementIdent := '';
  
  (* Read any configuration files *)
  i := 1;
  REPEAT
    s := PARAMSTR (i);
    IF (s [1] <> '-') THEN
       BEGIN
       SplitPFE (s, path, filename, ext);
       IF UpStr (ext) = 'CFG' THEN
          ReadConfigurationFile;
       END;
    INC (i);
  UNTIL i > PARAMCOUNT;
  
  (* Process options *)
  i := 1;
  REPEAT
    s := PARAMSTR (i);
    IF (s [1] = '-') THEN
       BEGIN
       s := UpStr (s);
       j := POS ('=', s);
       IF (j > 0) THEN
          BEGIN
          digit := 0;
          IF (j + 1 <= LENGTH (s) ) THEN
             IF (s [j + 1] >= '0') AND (s [j + 1] <= '9') THEN
                digit := ORD (s [j + 1]) - ORD ('0');
          s := COPY (s, 2, j - 2);
          IF (s = 'BEGININDENT') THEN
             BeginIndent := digit
          ELSE
          IF (s = 'CASECOLONINDENT') THEN
             CaseColonIndent := digit
          ELSE
          IF (s = 'CASEINDENT') THEN
             CaseIndent := digit
          ELSE
          IF (s = 'CONSTINDENT') THEN
             ConstIndent := digit
          ELSE
          IF (s = 'ELSEINDENT') THEN
             ElseIndent := digit
          ELSE
          IF (s = 'ELSEINDENTIF') THEN
             ElseIndentIf := digit
          ELSE
          IF (s = 'FORINDENT') THEN
             ForIndent := digit
          ELSE
          IF (s = 'IFINDENT') THEN
             IfIndent := digit
          ELSE
          IF (s = 'LABELINDENT') THEN
             LabelIndent := digit
          ELSE
          IF (s = 'LEFTMOSTBEGININDENT') THEN
             LeftmostBeginIndent := digit
          ELSE
          IF (s = 'INDENTPROCEDURE') THEN
             indentPROCEDURE := digit
          ELSE
          IF (s = 'RECORDINDENT') THEN
             RecordIndent := digit
          ELSE
          IF (s = 'REPEATINDENT') THEN
             RepeatIndent := digit
          ELSE
          IF (s = 'THENINDENT') THEN
             ThenIndent := digit
          ELSE
          IF (s = 'TYPEINDENT') THEN
             TypeIndent := digit
          ELSE
          IF (s = 'UNTILINDENT') THEN
             UntilIndent := digit
          ELSE
          IF (s = 'VARINDENT') THEN
             VarIndent := digit
          ELSE
          IF (s = 'WHILEINDENT') THEN
             WhileIndent := digit
          ELSE
          IF (s = 'WITHINDENT') THEN
             WithIndent := digit;
          END
       ELSE
       IF (s = 'BREAKTHEN') THEN
          BreakThen := TRUE
       ELSE
          BEGIN
          IF (POS ('B', s) > 0) THEN
             showbrackcom := FALSE;
          IF (POS ('P', s) > 0) THEN
             showparencom := FALSE;
          IF (POS ('I', s) > 0) THEN
             istream := TRUE;
          IF (POS ('O', s) > 0) THEN
             ostream := TRUE;
          IF (POS ('M', s) > 0) THEN
             NormalizeKeysToUpperCase := FALSE;
          IF (POS ('Q', s) > 0) THEN
             quiet := TRUE;
          IF (POS ('S', s) > 0) THEN
             BEGIN
             INC (i);
             IF (i > PARAMCOUNT) THEN
                BEGIN
                WRITELN ('EPB:  The -s option has been used without enough parameters.');
                HALT;
                END;
             SearchIdent := PARAMSTR (i);
             INC (i);
             IF (i > PARAMCOUNT) THEN
                BEGIN
                WRITELN ('EPB:  The -s option has been used without enough parameters.');
                HALT;
                END;
             ReplacementIdent := PARAMSTR (i);
             InsertReplacementInUserTree (SearchIdent, ReplacementIdent);
             END;  (* if (pos ('s' ... *)
          END;  (* if *)
       END;  (* if (s [1] ... *)
    INC (i);
  UNTIL (i > PARAMCOUNT);
  
  iname := '';
  oname := '';
  
  (* Prepare to open the appropriate streams *)
  IF NOT (istream AND ostream) THEN
     BEGIN
     i := 1;
     REPEAT  (* Get filenames *)
       s := UpStr (PARAMSTR (i) );
       IF (s [1] <> '-') THEN   (* Skip option flags *)
          BEGIN
          SplitPFE (s, path, filename, ext);
          IF (ext <> 'CFG') THEN (* Skip configuration filenames *)
             IF (istream) THEN     (* Input is from STDIN *)
                BEGIN
                oname := s;
                GOTO out;
                END
             ELSE
             IF (ostream) THEN     (* Output is to STDOUT *)
                BEGIN
                iname := s;
                GOTO out;
                END
             ELSE
             IF (iname = '') THEN  (* Input is from infile *)
                iname := s
             ELSE
                BEGIN
                oname := s;        (* Output is to outfile *)
                GOTO out;
                END;
          END  (* if (s [1] ... *)
       ELSE
       IF (COPY (s, 2, LENGTH ('BEGININDENT') ) <> 'BEGININDENT') AND
          (COPY (s, 2, LENGTH ('CASECOLONINDENT') ) <> 'CASECOLONINDENT') AND
          (COPY (s, 2, LENGTH ('CASEINDENT') ) <> 'CASEINDENT') AND
          (COPY (s, 2, LENGTH ('CONSTINDENT') ) <> 'CONSTINDENT') AND
          (COPY (s, 2, LENGTH ('ELSEINDENT') ) <> 'ELSEINDENT') AND
          (COPY (s, 2, LENGTH ('ELSEINDENTIF') ) <> 'ELSEINDENTIF') AND
          (COPY (s, 2, LENGTH ('FORINDENT') ) <> 'FORINDENT') AND
          (COPY (s, 2, LENGTH ('IFINDENT') ) <> 'IFINDENT') AND
          (COPY (s, 2, LENGTH ('LABELINDENT') ) <> 'LABELINDENT') AND
          (COPY (s, 2, LENGTH ('LEFTMOSTBEGININDENT') ) <> 'LEFTMOSTBEGININDENT') AND
          (COPY (s, 2, LENGTH ('INDENTPROCEDURE') ) <> 'INDENTPROCEDURE') AND
          (COPY (s, 2, LENGTH ('RECORDINDENT') ) <> 'RECORDINDENT') AND
          (COPY (s, 2, LENGTH ('REPEATINDENT') ) <> 'REPEATINDENT') AND
          (COPY (s, 2, LENGTH ('THENINDENT') ) <> 'THENINDENT') AND
          (COPY (s, 2, LENGTH ('TYPEINDENT') ) <> 'TYPEINDENT') AND
          (COPY (s, 2, LENGTH ('UNTILINDENT') ) <> 'UNTILINDENT') AND
          (COPY (s, 2, LENGTH ('VARINDENT') ) <> 'VARINDENT') AND
          (COPY (s, 2, LENGTH ('WHILEINDENT') ) <> 'WHILEINDENT') AND
          (COPY (s, 2, LENGTH ('WITHINDENT') ) <> 'WITHINDENT') AND
          (COPY (s, 2, LENGTH ('BREAKTHEN') ) <> 'BREAKTHEN') THEN
          IF (POS ('s', s) > 0) OR (POS ('S', s) > 0) THEN
             i := i + 2;
       INC (i);
     UNTIL (i > PARAMCOUNT);
     END;  (* if not *)
  
  out :
  SplitPFE (iname, path, filename, ext);
  
  IF (filename <> '') THEN
     IF (COPY (filename, LENGTH (filename), 1) <> '.') THEN
        BEGIN
        filename := filename + '.';
        iname := path + filename + 'PAS';
        END;
  
  s := path + filename + 'BAK';
  
  SplitPFE (oname, path, filename, ext);
  
  IF (filename <> '') THEN
     IF (COPY (filename, LENGTH (filename), 1) <> '.') THEN
        oname := path + filename + '.PAS';
  
  IF (iname <> '') THEN
     IF (iname = oname) OR
        ( (oname = '') AND NOT ostream) THEN
        BEGIN
        ASSIGN (infile, s);  (* If a backup file already exists, erase it *)
        {$I-}
        RESET (infile, 1); {$I+}
        IF (IORESULT = 0) THEN
           BEGIN
           CLOSE (infile);
           ERASE (infile);
           END;
        
        ASSIGN (infile, iname);
        {$I-}
        RESET (infile, 1); {$I+}
        IF (IORESULT = 0) THEN
           BEGIN
           CLOSE (infile);
           RENAME (infile, s);
           END
        ELSE
           BEGIN
           WRITELN ('EPB:  Cannot rename original file, ', iname, ', to ', s, '.');
           HALT;
           END;
        
        oname := iname;
        iname := s;
        END;
  
  ASSIGN (infile, iname);
  {$I-}
  RESET (infile, 1); {$I+}
  IF (IORESULT <> 0) THEN
     BEGIN
     WRITELN ('EPB:  Cannot open input file, ', iname);
     HALT;
     END;
  
  ASSIGN (outfile, oname);
  {$I-}
  REWRITE (outfile, 1); {$I+}
  IF (IORESULT <> 0) THEN
     BEGIN
     WRITELN ('EPB:  Error opening output file, ', oname, '.  DOS file limit reached?');
     HALT;
     END;
  
  col := 0;
  ib := 0;
  iks := 0;
  KeyStack [iks] := 0;
  is := 0;
  IndentationStack [is] := 0;
  index := 0;
  lastch := #0;
  LinesIndented := 0;
  CurrentIdentifier := '';
  LineIsClear := TRUE;
  ParenthesesDepth := 0;
  UpCaseIdent := '';
  
  (* Soft-coded indexes to some keywords of interest *)
  iasm := SearchKeyTree ('ASM');
  ibegin := SearchKeyTree ('BEGIN');
  icase := SearchKeyTree ('CASE');
  iconst := SearchKeyTree ('CONST');
  iconstructor := SearchKeyTree ('CONSTRUCTOR');
  idestructor := SearchKeyTree ('DESTRUCTOR');
  ido := SearchKeyTree ('DO');
  iend := SearchKeyTree ('END');
  iexternal := SearchKeyTree ('EXTERNAL');
  ifor := SearchKeyTree ('FOR');
  iforward := SearchKeyTree ('FORWARD');
  ifunction := SearchKeyTree ('FUNCTION');
  iif := SearchKeyTree ('IF');
  iimplementation := SearchKeyTree ('IMPLEMENTATION');
  iinline := SearchKeyTree ('INLINE');
  iinterface := SearchKeyTree ('INTERFACE');
  ithen := SearchKeyTree ('THEN');
  ielse := SearchKeyTree ('ELSE');
  ilabel := SearchKeyTree ('LABEL');
  iobject := SearchKeyTree ('OBJECT');
  iof := SearchKeyTree ('OF');
  iotherwise := SearchKeyTree ('OTHERWISE');
  iprocedure := SearchKeyTree ('PROCEDURE');
  iprogram := SearchKeyTree ('PROGRAM');
  irecord := SearchKeyTree ('RECORD');
  irepeat := SearchKeyTree ('REPEAT');
  itype := SearchKeyTree ('TYPE');
  iuntil := SearchKeyTree ('UNTIL');
  ivar := SearchKeyTree ('VAR');
  iwhile := SearchKeyTree ('WHILE');
  iwith := SearchKeyTree ('WITH');
  
  IF (NOT quiet) THEN
     BEGIN
     GOTOXY (cx, cy);
     WRITE (0 : 9, ' lines indented.');
     END;
  
  getblock;
  skipwhitespace;
  PushKey (iprogram);
  
  start :
  ch := a^ [ia];
  
  IF (lastch = #10) THEN
     BEGIN
     col := 0;
     LineIsClear := TRUE;
     skipspace;
     ch := a^ [ia];
     IF ( (ch < 'A') OR (ch > 'Z') ) AND
        ( (ch < 'a') OR (ch > 'z') ) AND
        (ch <> '_') THEN
        indent;
     END;
  
  CASE ch OF
       ';' :
         BEGIN
         OutLiteralChar (';');
         INC (ia);
         IF (ia >= nread) THEN
            getblock;
         
         IF (index = iprocedure) THEN  {We have a procedural type because the}
            BEGIN                      {procedure() or function() has no name}
            IF (KeyStack [iks] <> iinterface) AND (KeyStack [iks] <> iprogram) THEN
               PopKey;        {Pop the iprocedure/ifunction}
            index := 0;       {Erase its tracks}
            PopIndent;        {Undo the indentPROCEDURE that was pushed}
            PushKey (itype);  {Restore the itype that was popped and   }
            PushIndent (TypeIndent);
            END;
         
         IF (KeyStack [iks] = iuntil) THEN
            BEGIN
            PopIndent;
            PopKey;
            END;
         
         condbreakline;
         
         lastkey := KeyStack [iks];
         IF (lastkey = ithen) OR (lastkey = ielse) OR
            (lastkey = ido) THEN
            BEGIN
            index := 0;  (* Cover tracks for null statements *)
            REPEAT
              PopIndent;
              PopKey;
              lastkey := KeyStack [iks];
            UNTIL (lastkey <> ithen) AND (lastkey <> ielse) AND (lastkey <> ido);
            END;
         
         IF (lastkey = iif) THEN
            PopKey;
         
         IF (KeyStack [iks] = icase) THEN
            IndentationStack [is] := IndentationStack [is - 1] + CaseIndent;
         
         GOTO start;
         END;  (* ';' *)
       
       
       #39 :   (* Do not process the contents of literal strings *)
         BEGIN
         OutPaddedChar (#39);
         INC (ia);
         IF (ia >= nread) THEN
            getblock;
         WHILE (a^ [ia] <> #39) DO
               BEGIN
               OutLiteralChar (a^ [ia]);
               INC (ia);
               IF (ia >= nread) THEN
                  getblock;
               END;
         OutLiteralChar (a^ [ia]);
         INC (ia);
         IF (ia >= nread) THEN
            getblock;
         GOTO start;
         END;  (* ' single quoted literal strings *)
       
       
       '"' :   (* Do not process the contents of literal strings *)
         BEGIN
         OutPaddedChar ('"');
         INC (ia);
         IF (ia >= nread) THEN
            getblock;
         WHILE (a^ [ia] <> '"') DO
               BEGIN
               OutLiteralChar (a^ [ia]);
               INC (ia);
               IF (ia >= nread) THEN
                  getblock;
               END;
         OutLiteralChar (a^ [ia]);
         INC (ia);
         IF (ia >= nread) THEN
            getblock;
         GOTO start;
         END;  (* " double quoted literal strings *)
       
       
       '{' :   (* Do not process the contents of { ... } comments *)
         BEGIN
         IF (showbrackcom) THEN
            BEGIN
            OutLiteralChar ('{');
            INC (ia);
            IF (ia >= nread) THEN
               getblock;
            WHILE (a^ [ia] <> '}') DO
                  BEGIN
                  OutLiteralChar (a^ [ia]);
                  INC (ia);
                  IF (ia >= nread) THEN
                     getblock;
                  END;
            OutLiteralChar (a^ [ia]);
            INC (ia);
            IF (ia >= nread) THEN
               getblock;
            END
         ELSE
            BEGIN
            INC (ia);
            IF (ia >= nread) THEN
               getblock;
            WHILE (a^ [ia] <> '}') DO
                  BEGIN
                  INC (ia);
                  IF (ia >= nread) THEN
                     getblock;
                  END;
            INC (ia);
            IF (ia >= nread) THEN
               getblock;
            END;
         {       IF (a^ [ia] <> #13) AND (a^ [ia] <> ';') THEN
          BEGIN
          breakline;
          skipspace;
          END;}
         GOTO start;
         END;  (* {} *)
       
       
       '(' :   { Do not process the contents of (* ... *) comments }
         BEGIN
         INC (ia);
         IF (ia >= nread) THEN
            getblock;
         IF (a^ [ia] <> '*') THEN
            BEGIN
            OutPaddedChar ('(');  (* Just an ordinary '(' *)
            IF (index = iprocedure) THEN  {We have a procedural type because the}
               BEGIN                      {procedure() or function() has no name}
               IF (KeyStack [iks] <> iinterface) AND (KeyStack [iks] <> iprogram) THEN
                  PopKey;        {Pop the iprocedure/ifunction}
               index := 0;       {Erase its tracks}
               PopIndent;        {Undo the indentPROCEDURE that was pushed}
               PushKey (itype);  {Restore the itype that was popped and   }
               PushIndent (TypeIndent);
               END;
            INC (ParenthesesDepth);
            IF (ParenthesesDepth > 1) THEN
               PushIndent (0)
            ELSE
            IF (a^ [ia] = '(') OR (a^ [ia] = #32) THEN
               PushIndent (col - IndentationStack [is] + 1)  (* Gamble *)
            ELSE
               PushIndent (col - IndentationStack [is]);  (* Align contents *)
            PushKey (0); (* Has to be done for detecting nested variant case records *)
            GOTO start;
            END
         ELSE   (* A comment has begun *)
            BEGIN
            IF (showparencom) THEN
               BEGIN
               OutLiteralChar ('(');
               OutLiteralChar (a^ [ia]);
               END;
            
            INC (ia);
            IF (ia >= nread) THEN
               getblock;
            IF (showparencom) THEN
               OutLiteralChar (a^ [ia]);
            
            findasterisk :
            WHILE (a^ [ia] <> '*') DO
                  BEGIN
                  INC (ia);
                  IF (ia >= nread) THEN
                     getblock;
                  IF (showparencom) THEN
                     OutLiteralChar (a^ [ia]);
                  END;  (* a^[ia] = '*' *)
            
            INC (ia);
            IF (ia >= nread) THEN
               getblock;
            IF (showparencom) THEN
               OutLiteralChar (a^ [ia]);
            
            IF (a^ [ia] <> ')') THEN
               GOTO findasterisk;
            INC (ia);
            IF (ia >= nread) THEN
               getblock;
            {          IF (a^ [ia] <> #13) AND (a^ [ia] <> ';') THEN
             BEGIN
             breakline;
             skipspace;
             END;}
            GOTO start;
            END;
         END;  { (* *) }
       
       ')' :
         BEGIN
         OutPaddedChar (')');
         IF (KeyStack [iks] = icase) THEN  (* For variant records *)
            BEGIN
            PopIndent;
            PopKey;
            END;
         INC (ia);
         IF (ia >= nread) THEN
            getblock;
         DEC (ParenthesesDepth);
         PopIndent;
         PopKey;  (* Pop the 0 *)
         GOTO start;
         END;
       
       ':' :
         BEGIN
         OutPaddedChar (':');
         INC (ia);
         IF (ia >= nread) THEN
            getblock;
         IF (KeyStack [iks] = icase) THEN
            BEGIN
            IndentationStack [is] := IndentationStack [is] + CaseColonIndent;
            END 
         ELSE
         IF (index = iprocedure) THEN  {We have a procedural type because the}
            BEGIN                      {function :  has no name}
            IF (KeyStack [iks] <> iinterface) AND (KeyStack [iks] <> iprogram) THEN
               PopKey;        {Pop the ifunction}
            index := 0;       {Erase its tracks}
            PopIndent;        {Undo the indentPROCEDURE that was pushed}
            PushKey (itype);  {Restore the itype that was popped and   }
            PushIndent (TypeIndent);
            END;
         GOTO start;
         END;
       
       'A'..'Z', 'a'..'z', '_' :  (* Collect and process identifiers *)
         BEGIN
         REPEAT
           UpCaseIdent := UpCaseIdent + UPCASE (ch);
           CurrentIdentifier := CurrentIdentifier + ch;
           INC (ia);
           IF (ia >= nread) THEN
              getblock;
           ch := a^ [ia];
         UNTIL ( (ch < 'A') OR (ch > 'Z') ) AND
               ( (ch < 'a') OR (ch > 'z') ) AND
               ( (ch < '0') OR (ch > '9') ) AND
               (ch <> '_');  {Turbo Pascal Sets are too slow}
         
         lastindex := index;
         
         index := SearchKeyTree (UpCaseIdent);
         
         lastkey := KeyStack [iks];
         
         IF (index <> 0) THEN
            IF (index = iif) AND (lastindex = ielse) THEN
               BEGIN
               PopIndent;
               PushIndent (ElseIndentIf);
               END
            ELSE
            IF (BreakThen) AND (index = ithen) AND
               (LineIsClear = FALSE) THEN
               breakline
            ELSE
            IF (index = iend) THEN
               BEGIN
               PopIndent;
               IF (KeyStack [iks] = icase) THEN
                  BEGIN
                  PopKey;
                  IF (KeyStack [iks] = irecord) THEN
                     PopIndent
                  ELSE
                     PushKey (icase);
                  END;
               END
            ELSE
            IF (index = iuntil) THEN
               BEGIN
               PopIndent;
               PopKey;
               END
            ELSE
            IF (index = iotherwise) AND (KeyStack [iks] = icase) THEN
               PopIndent
            ELSE
            IF (index = ielse) THEN
               BEGIN
               IF (KeyStack [iks] = icase) THEN
                  PopIndent
               ELSE
                  BEGIN
                  IF (BreakThen) THEN
                     IndentationStack [is] := IndentationStack [is] + IfIndent;
                  IF (LineIsClear = FALSE) THEN
                     breakline;
                  END;
               END
            ELSE
            IF (index = iprocedure) OR (index = ifunction) OR
               (index = iconstructor) OR (index = idestructor) THEN
               BEGIN
               IF (lastkey = iconst) OR (lastkey = itype) OR
                  (lastkey = ivar) OR (lastkey = ilabel) THEN
                  BEGIN
                  PopKey;  {The iconst, itype, ivar, or ilabel}
                  PopIndent;
                  IF (KeyStack [iks] <> iprogram) AND
                     (KeyStack [iks] <> iinterface) THEN
                     PushIndent (indentPROCEDURE);
                  END
               ELSE
               IF (lastkey = iprocedure) OR (lastkey = ifunction) THEN
                  PushIndent (indentPROCEDURE);
               END
            ELSE
            IF (index = iconst) OR (index = itype) OR
               (index = ivar) OR (index = ilabel) THEN
               BEGIN
               IF (lastkey = iconst) OR (lastkey = itype) OR
                  (lastkey = ivar) OR (lastkey = ilabel) THEN
                  BEGIN
                  PopIndent;
                  PopKey;
                  END;
               END
            ELSE
            IF ( (lastkey = iconst) OR (lastkey = itype) OR
                 (lastkey = ivar) OR (lastkey = ilabel) ) AND
               ( (index = ibegin) OR (index = iasm) ) THEN
               BEGIN
               PopIndent;
               PopKey;  (* The iconst, itype, ivar, or ilabel *)
               END
            ELSE
            IF (index = iimplementation) AND
               ( (lastkey = iinterface) OR (lastkey = iconst) OR
                 (lastkey = itype) OR (lastkey = ivar) ) THEN
               BEGIN
               PopIndent;
               PopKey;
               IF (KeyStack [iks] = iinterface) THEN
                  PopKey;
               END;
         
         IF (lastch = #10) THEN
            indent;
         
         (* Output Identifier *)
         UPtr := SearchUserTree (UpCaseIdent);
         
         IF (UPtr <> NIL) THEN
            OutIdent (UPtr^.instance^)
         ELSE
         IF (index <> 0) THEN
            IF (NormalizeKeysToUpperCase) THEN
               OutIdent (UpCaseIdent)
            ELSE
               OutIdent (keylist [index])
         ELSE
            BEGIN
            InsertUserTree (CurrentIdentifier);
            OutIdent (CurrentIdentifier);
            END;
         
         IF (lastindex <> 0) THEN
            IF (lastindex = ido) AND
               (index <> iasm) AND
               (index <> ibegin) AND
               (index <> iif) AND
               (index <> ifor) AND
               (index <> irepeat) AND
               (index <> iwhile) AND
               (index <> iwith) AND
               (index <> icase) THEN
               BEGIN
               REPEAT
                 PopIndent;
                 PopKey;
               UNTIL (KeyStack [iks] <> ido);
               
               WHILE (KeyStack [iks] = ielse) DO
                     BEGIN
                     PopIndent;
                     PopKey;
                     END;
               
               IF (KeyStack [iks] = ithen) THEN
                  BEGIN
                  PopIndent;
                  PopKey;
                  END;
               END
            ELSE
            IF (lastindex = ielse) AND
               (index <> iasm) AND
               (index <> ibegin) AND
               (index <> iif) AND
               (index <> ifor) AND
               (index <> irepeat) AND
               (index <> iwhile) AND
               (index <> icase) AND
               (index <> iwith) AND (KeyStack [iks] <> icase) THEN
               BEGIN
               REPEAT
                 PopIndent;
                 PopKey;
               UNTIL (KeyStack [iks] <> ielse);
               IF (KeyStack [iks] = ithen) THEN
                  BEGIN
                  PopIndent;
                  PopKey;
                  END;
               END
            ELSE
            IF (lastindex = ithen) AND
               (index <> iasm) AND
               (index <> ibegin) AND
               (index <> iif) AND
               (index <> ifor) AND
               (index <> irepeat) AND
               (index <> iwhile) AND
               (index <> icase) AND
               (index <> iwith) THEN
               BEGIN
               PopIndent;
               PopKey;
               END;
         
         IF (index <> 0) THEN
            IF (index = iend) THEN
               BEGIN
               IF (KeyStack [iks] = ibegin) OR
                  (KeyStack [iks] = icase) THEN
                  BEGIN
                  PopKey;
                  
                  WHILE (KeyStack [iks] = ido) DO
                        BEGIN
                        PopIndent;
                        PopKey;
                        END;
                  
                  WHILE (KeyStack [iks] = ielse) DO
                        BEGIN
                        PopIndent;
                        PopKey;
                        END;
                  
                  IF (KeyStack [iks] = ithen) THEN
                     BEGIN
                     PopIndent;
                     PopKey;
                     END;
                  
                  lastkey := KeyStack [iks];
                  IF (lastkey = iprocedure) OR (lastkey = ifunction) THEN
                     BEGIN
                     PopIndent;
                     PopKey;
                     END;
                  END
               ELSE
               IF (KeyStack [iks] = icase) THEN
                  PopKey
               ELSE
               IF (KeyStack [iks] = irecord) OR (KeyStack [iks] = iobject) THEN
                  BEGIN
                  PopIndent;
                  PopKey;
                  END;
               END
            ELSE
            IF (index = ibegin) OR (index = iasm) THEN
               BEGIN
               lastkey := KeyStack [iks];
               IF (lastkey <> iprocedure) AND (lastkey <> ifunction) AND
                  (lastkey <> iprogram) THEN
                  BEGIN
                  IF (lastkey = icase) THEN
                     IndentationStack [is] := col - LENGTH (CurrentIdentifier);
                  PushIndent (BeginIndent);
                  END
               ELSE
                  PushIndent (LeftmostBeginIndent);
               PushKey (ibegin);
               condbreakline;
               END
            ELSE
            IF (index = iif) THEN
               BEGIN
               IF (lastkey = icase) THEN
                  IndentationStack [is] := col - 2;
               PushIndent (IfIndent);
               IF (KeyStack [iks] = icase) THEN
                  PushKey (iif);  {To differentiate between ELSE for IF and CASE}
               END
            ELSE
            IF (index = ithen) THEN
               BEGIN
               condbreakline;
               IndentationStack [is] := IndentationStack [is] + ThenIndent;
               PushKey (ithen);
               END
            ELSE
            IF (index = ielse) THEN
               BEGIN
               condbreakline;
               IF (KeyStack [iks] <> icase) THEN
                  BEGIN
                  PushIndent (ElseIndent);
                  PushKey (ielse);
                  END
               ELSE
                  PushIndent (CaseIndent)
               END
            ELSE
            IF (index = iwhile) THEN
               BEGIN
               IF (lastkey = icase) THEN
                  IndentationStack [is] := col - 5;
               PushIndent (WhileIndent);
               END
            ELSE
            IF (index = ifor) THEN
               BEGIN
               IF (lastkey = icase) THEN
                  IndentationStack [is] := col - 3 - CaseColonIndent;
               PushIndent (ForIndent);
               END
            ELSE
            IF (index = ido) THEN
               BEGIN
               condbreakline;
               PushKey (ido)
               END
            ELSE
            IF (index = irepeat) THEN
               BEGIN
               IF (lastkey = icase) THEN
                  IndentationStack [is] := col - 6;
               PushIndent (RepeatIndent);
               PushKey (irepeat);
               condbreakline;
               END
            ELSE
            IF (index = iuntil) THEN
               BEGIN
               PushIndent (UntilIndent);
               PushKey (iuntil);
               END
            ELSE
            IF (index = iconst) AND (ParenthesesDepth = 0) THEN
               BEGIN
               PushIndent (ConstIndent);
               PushKey (iconst);
               END
            ELSE
            IF (index = itype) AND (ParenthesesDepth = 0) THEN
               BEGIN
               PushIndent (TypeIndent);
               PushKey (itype);
               END
            ELSE
            IF (index = ivar) AND (ParenthesesDepth = 0) THEN
               BEGIN
               PushIndent (VarIndent);
               PushKey (ivar);
               END
            ELSE
            IF (index = irecord) THEN
               BEGIN
               PushIndent (col - 6 - IndentationStack [is]);
               PushIndent (RecordIndent);
               PushKey (irecord);
               condbreakline;
               END
            ELSE
            IF ( (index = iprocedure) OR
                 (index = iconstructor) OR (index = idestructor) ) THEN
               BEGIN
               IF (KeyStack [iks] = iobject) OR
                  (KeyStack [iks] = iinterface) OR
                  (KeyStack [iks] = irecord) THEN
                  index := 0 (* Hide its tracks *)
               ELSE
                  PushKey (iprocedure);
               END
            ELSE
            IF (index = ifunction) THEN  (* Make it look like a procedure *)
               BEGIN
               index := iprocedure;
               IF (KeyStack [iks] = irecord) OR
                  (KeyStack [iks] = iobject) OR
                  (KeyStack [iks] = iinterface) THEN
                  index := 0 (* So that it's not mistaken for a procedural type *)
               ELSE
                  PushKey (iprocedure);
               END
            ELSE
            IF (index = iobject) THEN
               BEGIN
               PushIndent (col - 6 - IndentationStack [is]);
               PushIndent (RecordIndent);
               PushKey (iobject);
               END
            ELSE
            IF (index = ilabel) THEN
               BEGIN
               PushIndent (LabelIndent);
               PushKey (ilabel);
               END
            ELSE
            IF (index = icase) THEN
               BEGIN
               IF (lastkey = icase) THEN
                  IndentationStack [is] := col - 4;
               PushIndent (CaseIndent);
               PushKey (icase);
               END
            ELSE
            IF (index = iof) THEN
               BEGIN
               IF (KeyStack [iks] = icase) THEN
                  IndentationStack [is] := IndentationStack [is - 1] + CaseIndent;
               condbreakline;
               END
            ELSE
            IF (index = iwith) THEN
               BEGIN
               IF (lastkey = icase) THEN
                  IndentationStack [is] := col - 4;
               PushIndent (WithIndent);
               END
            ELSE
            IF ( (index = iforward) OR (index = iexternal) ) AND
               ( (KeyStack [iks] = iprocedure) OR (KeyStack [iks] = ifunction) )
               THEN
               PopKey
            ELSE
            IF (index = iinterface) THEN
               PushKey (iinterface)
            ELSE
            IF (index = iinline) AND
               ( (KeyStack [iks] = iprocedure) OR (KeyStack [iks] = ifunction) ) THEN
               PopKey
            ELSE
            IF (index = iotherwise) THEN
               PushIndent (CaseIndent);
         
         CurrentIdentifier := '';
         UpCaseIdent := '';
         GOTO start;
         END;  (* 'A'..'Z', 'a'..'z', '_' *)
       
       
       '0'..'9' :  (* Process decimal integer or real constants *)
         BEGIN
         OutPaddedChar (a^ [ia]);
         INC (ia);
         IF (ia >= nread) THEN
            getblock;
         
         WHILE ( (a^ [ia] >= '0') AND (a^ [ia] <= '9') ) OR
               (a^ [ia] = '.') DO
               BEGIN
               OutLiteralChar (a^ [ia]);
               INC (ia);
               IF (ia >= nread) THEN
                  getblock;
               END;
         
         IF (a^ [ia] = 'e') OR (a^ [ia] = 'E') THEN
            BEGIN
            OutLiteralChar ('e');
            
            INC (ia);                   (* Go to the next character *)
            IF (ia >= nread) THEN
               getblock;
            
            OutLiteralChar (a^ [ia]);   (* Output the sign or digit or (?) *)
            
            INC (ia);                   (* Go to the next character *)
            IF (ia >= nread) THEN
               getblock;
            
            IF ( (lastch >= '0') AND (lastch <= '9') ) OR
               (lastch = '-') OR
               (lastch = '+') THEN
               WHILE ( (a^ [ia] >= '0') AND (a^ [ia] <= '9') ) OR
                     (a^ [ia] = '.') DO
                     BEGIN
                     OutLiteralChar (a^ [ia]);
                     INC (ia);
                     IF (ia >= nread) THEN
                        getblock;
                     END;
            END; (* if *)
         GOTO start;
         END;  (* '0'..'9' *)
       
       
       '$' :  (* Process hexadecimal constants, specific to Turbo Pascal *)
         BEGIN
         OutPaddedChar ('$');
         INC (ia);
         IF (ia >= nread) THEN
            getblock;
         WHILE ( (a^ [ia] >= 'a') AND (a^ [ia] <= 'f') ) OR
               ( (a^ [ia] >= 'A') AND (a^ [ia] <= 'F') ) OR
               ( (a^ [ia] >= '0') AND (a^ [ia] <= '9') ) DO
               BEGIN
               OutLiteralChar (a^ [ia]);
               INC (ia);
               IF (ia >= nread) THEN
                  getblock;
               END;
         GOTO start;
         END;  (* '$' *)
       
  ELSE
       
       OutPaddedChar (ch);
       INC (ia);
       IF (ia >= nread) THEN
          getblock;
       GOTO start;
       
  END;  (* CASE ch *)
END.
