#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/* services for enhanced keyboards */
#define _NKEYBRD_READ		0x10
#define _NKEYBRD_READY		0x11
#define _NKEYBRD_SHIFTSTATUS	0x12
/* XT -like keyboard */
#define _KEYBRD_READ		0
#define _KEYBRD_READY		1
#define _KEYBRD_SHIFTSTATUS	2


/*
** _BIOS_KEYBRD() FOR GCC ; must support bios int 0x10
*/
int _bios_keybrd(int mode)
{
    register int _AX;

    __asm__ __volatile__(
	    "movb   %%ah,%%dl \n\t"
	    "andb   $0x0F,%%dl \n\t"
	    "int    $0x16 \n\t"
	    "jne    1f \n\t"
	    "cmpb   $0x01,%%dl \n\t"
	    "jne    1f \n\t"
	    "xorl   %%eax,%%eax \n\t"
	    "jmp    2f \n\t"
	    "1:     \n\t"
	    "cmpb   $0x02,%%dl \n\t"
	    "je     2f \n\t"
	    "orl    %%eax,%%eax \n\t"
	    "jne    2f \n\t"
	    "decl   %%eax \n\t"
	    "2:     \n\t"
	    : "=a" (_AX)
	    : "a" (mode)
	    : "ax","dx" );
    return _AX ;
}


int get_input(char *str, int size)
{
    static char oldstr[40];
    char ins_flag;
    int strpos;
    int strend;

    unsigned int key, scan;
    unsigned char ascii = 0;
    int i;

    strpos = 0;
    strend = 0;
    ins_flag = 1;
    memset(str, 0, size);

    for (;;) {
	key = _bios_keybrd(_NKEYBRD_READ );

	scan = (key >> 8) & 0xFF;
	ascii = (unsigned char) (key & 0xFF);

	if (ascii == 0xE0)
	    ascii = 0;

	if (ascii >= 32) {	/* show char */
	    if (strpos == strend) {
		putchar(ascii);
		*(str + strpos) = ascii;
		strend++;
	    } else if (ins_flag) {	/* shift right chars */
		for (i = strend; i >= strpos; --i)
		    *(str + i + 1) = *(str + i);
		*(str + strpos) = ascii;
		printf("%s",str + strpos);
		for (i = strend; i > strpos; i--)
		    putchar('\b');
		strend++;
	    } else {
		putchar(ascii);
		*(str + strpos) = ascii;
	    }
	    strpos++;
	    fflush(stdout);
	    continue;
	}
	/* backspace or delete */
	else if ((ascii == '\b' && strpos != 0)
		 || (scan == 0x53 && strend != strpos)) {
	    if (ascii == '\b') {
		putchar('\b');
		strpos--;
	    }
	    for (i = strpos; i < strend; ++i)
		*(str + i) = *(str + i + 1);
	    strend--;
	    *(str + strend) = '\0';
	    printf("%s",str + strpos);
	    putchar(' ');
	    putchar('\b');
	    for (i = strend; i > strpos; i--)
		putchar('\b');
	    fflush(stdout);
	    continue;
	} else if (ascii == 13) {
	    strcpy(oldstr, str);
	    break;
	} else if (ascii == 27) {
	    for (; strpos != 0; strpos--) {
		putchar('\b');
		putchar(' ');
		putchar('\b');
	    }
	    memset(str, 0, size);
	    strcpy(str, oldstr);
	    strpos = strend = 0;
	    fflush(stdout);
	    continue;
	} else if (scan == 0x4b && strpos != 0) {
	    putchar('\b');
	    strpos--;
	    fflush(stdout);
	    continue;
	} else if (scan == 0x48) {	/* up */
	    for (; strpos != 0; strpos--) {
		putchar('\b');
		putchar(' ');
		putchar('\b');
	    }
	    memset(str, 0, size);
	    strcpy(str, oldstr);
	    printf("%s",str);
	    strpos = strend = strlen(str);
	    fflush(stdout);
	    continue;
	} else if (scan == 0x4d && strpos < strend) {	/* -> */
	    putchar(*(str + strpos));
	    strpos++;
	    fflush(stdout);
	    continue;
	} else if (scan == 0x47) {	/* home */
	    for (; strpos != 0; strpos--)
		putchar('\b');
	    strpos = 0;
	    fflush(stdout);
	    continue;
	} else if (scan == 0x4F) {	/* end */
	    printf("%s",str + strpos);
	    strpos = strend;
	    fflush(stdout);
	    continue;
	} else if (scan == 0x52)/* ins */
	    ins_flag ^= 1;
    fflush(stdout);
    }
    return strend;
}

