import com.jxcell.ChartData;
import com.jxcell.ChartException;
import com.jxcell.GRChart;
import com.jxcell.JCChart;

import javax.swing.*;
import java.awt.*;
import java.awt.event.WindowEvent;

public class ChartDemo extends JFrame
        implements java.awt.event.ActionListener
{
    BorderLayout borderLayout1 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout(1,4,15,15);
    JButton btnBar = new JButton();
    JButton btnColumn = new JButton();
    JButton btnPie = new JButton();
    JButton btnLine = new JButton();
    JButton btnArea = new JButton();
    GRChart chart;

  //Construct the frame
  public ChartDemo()
  {
      enableEvents(AWTEvent.WINDOW_EVENT_MASK);
      try
      {
          jbInit();
      }
      catch(Exception e)
      {
        e.printStackTrace();
      }
  }


  static public void main(String args[])
	{
        ChartDemo frame = new ChartDemo();
        frame.validate();
        frame.setVisible(true);
	}

  //Component initialization
  private void jbInit() throws Exception
  {
      this.getContentPane().setLayout(borderLayout1);
      this.setSize(new Dimension(522, 493));
      this.setTitle("Chart Component Demo");
      btnBar.setText("Bar Chart");
      btnBar.setSize(40,40);
      btnBar.addActionListener(this);
      btnColumn.setText("Column Chart");
      btnColumn.setSize(40,40);
      btnColumn.addActionListener(this);
      btnPie.setText("Pie Chart");
      btnPie.setSize(40,40);
      btnPie.addActionListener(this);
      btnLine.setText("Line Chart");
      btnLine.setSize(40,40);
      btnLine.addActionListener(this);
      btnArea.setText("Area Chart");
      btnArea.setSize(40,40);
      btnArea.addActionListener(this);

      chart = new GRChart();
      ChartData m_chartdata = new ChartData();
      m_chartdata.setDataSize(7,5);
      m_chartdata.setText(0,1,"Jan");
      m_chartdata.setText(0,2,"Feb");
      m_chartdata.setText(0,3,"Mar");
      m_chartdata.setText(0,4,"Apr");
      m_chartdata.setText(1,0,"Bananas");
      m_chartdata.setText(2,0,"Papaya");
      m_chartdata.setText(3,0,"Mango");
      m_chartdata.setText(4,0,"Lilikoi");
      m_chartdata.setText(5,0,"Comfrey");
      m_chartdata.setText(6,0,"Total");
      for(int col = 1; col < 5; col++)
          for(int row = 1; row < 7; row++)
              m_chartdata.setNumber(row, col, row + col);
      m_chartdata.setNumber(6, 1, 20);
      m_chartdata.setNumber(6, 2, 25);
      m_chartdata.setNumber(6, 3, 30);
      m_chartdata.setNumber(6, 4, 35);
      chart.resetAll();
      chart.setTitle("Sample Chart");
//      chart.setChartType(com.jxcell.GRChart.eChartColumn);
      chart.setChartType(com.jxcell.GRChart.eChartBar);
      chart.setChartData(m_chartdata);
      JCChart jcChart = chart.getJChart();
//      jcChart.setViewScale(200);
//      jcChart.setAllowSelections(false);
//      jcChart.setAllowUserChanges(false);
      JPanel jPanel1 = new JPanel();
      jPanel1.setLayout(gridLayout1);
      jPanel1.add(btnBar);
      jPanel1.add(btnColumn);
      jPanel1.add(btnPie);
      jPanel1.add(btnLine);
      jPanel1.add(btnArea);
      this.getContentPane().add(jPanel1, BorderLayout.SOUTH);
      this.getContentPane().add(jcChart, BorderLayout.CENTER);
  }

  protected void processWindowEvent(WindowEvent e)
  {
    super.processWindowEvent(e);
    if(e.getID() == WindowEvent.WINDOW_CLOSING)
    {
      System.exit(0);
    }
  }

    //just as demo,you can change chart type by mouse right click menu
  public void actionPerformed(java.awt.event.ActionEvent e)
  {
      Object buttonObj = e.getSource();
      try
      {
          if(buttonObj==btnBar)
          {
              chart.setChartType(GRChart.eChartBar);
          }
          else if(buttonObj==btnColumn)
          {
              chart.setChartType(GRChart.eChartColumn);
          }
          else if(buttonObj==btnPie)
          {
              chart.setChartType(GRChart.eChartPie);
          }
          else if(buttonObj==btnLine)
          {
              chart.setChartType(GRChart.eChartLine);
          }
          else if(buttonObj==btnArea)
          {
              chart.setChartType(GRChart.eChartArea);
          }
      }
      catch (ChartException e1)
      {
      }
  }
}
