/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.DateModel;
import cc.gammasoft.date.DatePanel;
import cc.gammasoft.date.DefaultDateModel;
import cc.gammasoft.date.MonthYearPanel;
import cc.gammasoft.date.StatusPanel;
import cc.gammasoft.date.WeekDayPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MonthView
extends JComponent
implements ChangeListener {
    private SimpleDateFormat dateFormat;
    private DatePanel datePanel = new DatePanel();
    private WeekDayPanel weekDayPanel = new WeekDayPanel();
    private MonthYearPanel monthYearPanel = new MonthYearPanel();
    private JComponent statusPanel = new StatusPanel();
    private JPanel monthPanel;
    private DateModel dateModel;
    private boolean isDemo = true;

    public MonthView() {
        this((SimpleDateFormat)DateFormat.getDateInstance(3), Calendar.getInstance());
    }

    public MonthView(SimpleDateFormat dateFormat) {
        this(dateFormat, Calendar.getInstance());
    }

    public MonthView(Calendar calendar) {
        this((SimpleDateFormat)DateFormat.getDateInstance(3), calendar);
    }

    public MonthView(SimpleDateFormat dateFormat, Calendar calendar) {
        this.initComponents();
        this.setDateFormat(dateFormat);
        this.dateModel = new DefaultDateModel();
        this.setDateModel(this.dateModel);
        this.initListener();
        this.dateModel.addChangeListener(this);
        this.dateModel.setValue(calendar);
        this.initStatusListener();
        this.setFont(new Font("Dialog", 0, 11));
    }

    private void initStatusListener() {
        this.statusPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                Calendar calendar = Calendar.getInstance();
                MonthView.this.dateModel.setValue(calendar.get(1), calendar.get(2), calendar.get(5));
            }
        });
        if (this.isDemo) {
            new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            int sleepTime = (int)(Math.random() * 20.0);
                            Thread.sleep(sleepTime * 20 * 1000);
                            JOptionPane.showMessageDialog(null, "Gammasoft, Inc\n www.gammasoft.cc", "Demo Date Picker", 0);
                        }
                        catch (Exception ex) {
                        }
                    }
                }
            }).start();
        }
    }

    private void initComponents() {
        this.monthPanel = new JPanel();
        this.monthPanel.setLayout(new BorderLayout());
        this.monthPanel.add(this.datePanel);
        this.monthPanel.add((Component)this.weekDayPanel, "North");
        this.monthPanel.add((Component)this.statusPanel, "South");
        this.setLayout(new BorderLayout());
        this.add(this.monthPanel);
        this.add((Component)this.monthYearPanel, "North");
        this.setBorder(new LineBorder(Color.BLACK));
    }

    private void initListener() {
        this.monthYearPanel.getMonthModel().addChangeListener(this);
        this.monthYearPanel.getYearModel().addChangeListener(this);
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.weekDayPanel.setWeekDayNames(dateFormat, 0);
        this.monthYearPanel.setMonthNames(dateFormat, 0);
        if (this.dateModel != null) {
            this.dateModel.setValue(this.dateModel.getValue());
        }
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateModel(DateModel dateModel) {
        if (dateModel == null) {
            throw new NullPointerException("Null Date Model");
        }
        this.dateModel = dateModel;
        this.datePanel.setDateModel(dateModel);
        this.monthYearPanel.setDateModel(dateModel);
    }

    public DateModel getDateModel() {
        return this.dateModel;
    }

    public void stateChanged(ChangeEvent e) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, this.monthYearPanel.getMonth());
        calendar.set(1, this.monthYearPanel.getYear());
        this.datePanel.setView(calendar);
    }

    public Calendar getValue() {
        return this.dateModel.getValue();
    }

    public void setValue(Calendar calendar) {
        this.dateModel.setValue(calendar);
    }

    public void setSQLDate(String SQLDate) {
        this.dateModel.setSQLDate(SQLDate);
    }

    public void setTimestamp(String timeStamp) {
        this.dateModel.setTimestamp(timeStamp);
    }

    public String getSQLDateValue() {
        return this.dateModel.getSQLDateValue();
    }

    public String getTimestampValue() {
        return this.dateModel.getTimestampValue();
    }

    public ArrayList getWeekDayLabels() {
        return this.weekDayPanel.getWeekDayLabels();
    }

    public void enableSelectionTracking(boolean value) {
        this.dateModel.enableSelectionTracking(value);
    }

    public boolean isSelectionTrackingEnabled() {
        return this.dateModel.isSelectionTrackingEnabled();
    }

    public void enableReselection(boolean value) {
        this.dateModel.enableReselection(value);
    }

    public boolean isReSelectionEnabled() {
        return this.dateModel.isReselectionEnabled();
    }

    public void setMonthNames(SimpleDateFormat dateFormat, int type) {
        this.monthYearPanel.setMonthNames(dateFormat, type);
        if (this.dateModel != null) {
            this.dateModel.fireValueChanged();
        }
    }

    public void setWeekDayNames(SimpleDateFormat dateFormat, int weekDayType) {
        this.weekDayPanel.setWeekDayNames(dateFormat, weekDayType);
        if (this.dateModel != null) {
            this.dateModel.fireValueChanged();
        }
    }

    public JSpinner getYearSpinner() {
        return this.monthYearPanel.getYearSpinner();
    }

    public JSpinner getMonthSpinner() {
        return this.monthYearPanel.getMonthSpinner();
    }

    public JLabel getYearEditor() {
        return this.monthYearPanel.getYearEditor();
    }

    public JLabel getMonthEditor() {
        return this.monthYearPanel.getMonthEditor();
    }

    public void setFont(Font monthViewFont) {
        super.setFont(monthViewFont);
        this.weekDayPanel.setFont(monthViewFont);
        this.getYearEditor().setFont(monthViewFont);
        this.getMonthEditor().setFont(monthViewFont);
        this.statusPanel.setFont(monthViewFont);
        this.datePanel.setFont(monthViewFont);
        this.dateModel.fireValueChanged();
    }

    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        this.weekDayPanel.setForeground(foreground);
        this.getYearEditor().setForeground(foreground);
        this.getMonthEditor().setForeground(foreground);
        this.statusPanel.setForeground(foreground);
        this.datePanel.setForeground(foreground);
        this.dateModel.fireValueChanged();
    }

    public DatePanel getDatePanel() {
        return this.datePanel;
    }

    public WeekDayPanel getWeekDayPanel() {
        return this.weekDayPanel;
    }

    public MonthYearPanel getMonthYearPanel() {
        return this.monthYearPanel;
    }

    public JComponent getStatusPanel() {
        return this.statusPanel;
    }

    public void setStatusPanel(JComponent component) {
        if (component == null) {
            throw new RuntimeException("Null Status Panel");
        }
        this.monthPanel.remove(component);
        this.statusPanel = component;
        this.monthPanel.add((Component)this.statusPanel, "South");
        this.revalidate();
    }
}

