rem : Module     - ssrepair.bat
rem : Updated    - 01/22/2004
rem : Purpose    - Repair the SourceSafe database
rem :              The script ensures that no-one is logged into
rem :              SourceSafe when 'analyze' is running

rem : Run From   - c:\Program Files\Microsoft Visual Studio\Common\Vss\Utilities
rem                (Create as peer of ....\Vss\Win32 directory)

rem : Parameters  NOTE! Full path parameters MUST be quoted strings!
rem : - %1 Drive letter of drive containing the ...\vss\data directory e.g: X
rem : - %2 Full path to data directory e.g: X:\....\vss\data
rem : - %3 Drive letter of drive containing ...\Common\vss\win32 directory e.g.: C
rem : - %4 Full path to the vss install directory e.g.: c:\Program Files\...\Common\vss
rem : - %5 Configuration engineer email name
rem : - %6 Yourcompany.com

rem : Outputs    - Analyze.bad and analyze.log files and emails the log to you.
rem :            - ssutility.log : record of utility processing.

rem : Pre-Req #0 - 'vssdata' share set on the ...\vss\data directory
rem : Pre-Req #1 - Make sure a FULL SourceSafe backup has completed properly!
rem : Pre-Req #2 - Modify calling parameters for genstats

rem -------------------------------------------------------------------------

rem : Remove quotes from parameter 2
set ssparm2=%2
set ssparm2=%ssparm2:"=%
set ssparm2=%ssparm2:"=%

rem : Remove quotes from parameter 4
set ssparm4=%4
set ssparm4=%ssparm4:"=%
set ssparm4=%ssparm4:"=%

rem : switch to the vss program drive utility directory
%3%:
cd "%ssparm4%\Utilities"

net send %5% ssrepair.bat started.
echo exit|cmd /q /k prompt $D $T ssrepair.bat : started. >> ssutility.log

rem : generate PRE-repair database-logical file stats
call genstats.bat null null %3 %4 %5 PRE_REPAIR

echo exit|cmd /q /k prompt $D $T ssrepair.bat : Check ssrights.txt to ensure that the user running this file has destroy rights. >> ssutility.log
echo exit|cmd /q /k prompt $D $T ssrepair.bat : If the user does not have destroy rights analyze -d will not complain but will not delete anything either. >> ssutility.log
ss whoami >> ssutility.log
pause

rem : switch to the vss database tree drive
%1%:

rem : Remove old analyze.log, analyze.bad and DB backup files
cd "%ssparm2%\backup"
erase /Q *.*
dir

rem : Set admin lock
cd "%ssparm2%\loggedin"
copy Nul ADMIN.LCK
dir ADMIN.LCK

rem : Terminate User sessions
REM Sleep 300
Net Share vssdata /Delete /Y

rem : This trick automates the yes response
echo y | Net Session /Delete
REM Sleep 30

rem : Remove admin and user x.log session files
erase *.log
dir
rem : user .log files should be gone. Are they?

rem : switch to the vss program drive utility directory
%3%:
cd "%ssparm4%\Utilities"

rem : list open files
net files > ss_openfiles.txt
wmailto %5%@%6 "-sSourceSafe Open Files immediately prior to analyze -x run" --<ss_openfiles.txt

rem : Run Microsoft built-in analyze utility
net send %5% ssrepair.bat analyze run started
echo exit|cmd /q /k prompt $D $T ssrepair.bat : analyze started in -f [fix] mode. >> ssutility.log

rem : v3 show all errors and inconsistencies
rem : -f to fix the database
rem : -d to compact it
rem : OUTPUTS analyze.log analyze.bad

analyze %2% -d -v3 -i-

net send %5% ssrepair.bat built-in analyze run completed
echo exit|cmd /q /k prompt $D $T ssrepair.bat : analyze ended. >> ssutility.log

rem : when analyze has completed Pass 4
rem : close the Analyze window &  press any key to continue the main batch file
rem PAUSE

copy "%ssparm2%\backup\analyze.*"

rem : switch to the vss database tree drive
%1%:

rem : reinstate user access to the database
cd "%ssparm2%\data\loggedin"
erase ADMIN.LCK
Net Share vssdata="%ssparm2%"
net send %5% User's can login again now.
dir

rem : switch to the vss program drive utility directory
%3%:
cd "%ssparm4%\Utilities"

rem : generate POST-repair database-logical file stats
call genstats.bat null null %3 %4 %5 POST_REPAIR

:Exit
net send %5% ssrepair.bat completed.
echo exit|cmd /q /k prompt $D $T ssrepair.bat : ended. >> ssutility.log
exit
