/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.IOException;
import unity.relational.Relation;
import unity.relational.Tuple;
import unity.util.StringFunc;

public abstract class Operator {
    protected Operator[] input;
    protected int numInputs;
    protected Relation outputRelation;
    protected int BUFFER_SIZE;
    protected int BLOCKING_FACTOR;
    protected int tuplesOutput;
    protected int tuplesRead;
    protected int pagesRead;
    protected int internalTupleIOs;
    protected int internalPageIOs;

    Operator() {
        this(null, 0, 0);
    }

    Operator(Operator[] in, int bfr, int bs) {
        this.numInputs = in == null ? 0 : in.length;
        this.input = in;
        this.BLOCKING_FACTOR = bfr;
        this.BUFFER_SIZE = bs;
        this.tuplesOutput = 0;
        this.tuplesRead = 0;
        this.pagesRead = 0;
        this.internalTupleIOs = 0;
        this.internalPageIOs = 0;
    }

    public abstract void init() throws IOException;

    public abstract Tuple next() throws IOException;

    public boolean hasNext() throws IOException {
        return false;
    }

    public void close() throws IOException {
        int i = 0;
        while (i < this.numInputs) {
            this.input[i].close();
            ++i;
        }
    }

    public boolean isBuffered() {
        return false;
    }

    public void setOutputRelation(Relation r) {
        this.outputRelation = r;
    }

    public Relation getOutputRelation() {
        return this.outputRelation;
    }

    protected void incrementTuplesOutput() {
        ++this.tuplesOutput;
    }

    protected void incrementTuplesRead() {
        ++this.tuplesRead;
    }

    protected void incrementPagesRead() {
        ++this.pagesRead;
    }

    protected void incrementTupleIOs() {
        ++this.internalTupleIOs;
    }

    protected void incrementPageIOs() {
        ++this.internalPageIOs;
    }

    protected void incrementTuplesRead(int i) {
        this.tuplesRead += i;
    }

    protected void incrementPagesRead(int i) {
        this.pagesRead += i;
    }

    protected void incrementTuplesOutput(int i) {
        this.tuplesOutput += i;
    }

    protected void incrementTupleIOs(int i) {
        this.internalTupleIOs += i;
    }

    protected void incrementPageIOs(int i) {
        this.internalPageIOs += i;
    }

    public int getTuplesOutput() {
        return this.tuplesOutput;
    }

    public int getTuplesRead() {
        return this.tuplesRead;
    }

    public int getPagesRead() {
        return this.pagesRead;
    }

    public int getTupleIOs() {
        return this.internalTupleIOs;
    }

    public int getPageIOs() {
        return this.internalPageIOs;
    }

    public static void printTree(Operator root, int depth) {
        if (root == null) {
            return;
        }
        System.out.println(String.valueOf(StringFunc.spaces(depth * 3)) + root.toString());
        if (root.input == null) {
            return;
        }
        int newDepth = depth;
        ++newDepth;
        int i = 0;
        while (i < root.input.length) {
            Operator.printTree(root.input[i], newDepth);
            ++i;
        }
    }
}

