/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.annotation.AttributeValueSource;
import unity.functions.Expression;
import unity.functions.MatchFunction;
import unity.query.GQDatabaseRef;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class M_MinRef
extends MatchFunction {
    protected GQDatabaseRef source1;
    protected GQDatabaseRef source2;

    public M_MinRef(Expression exp1, Expression exp2, GQDatabaseRef src1, GQDatabaseRef src2) {
        super(exp1, exp2);
        this.returnType = exp1.getReturnType();
        this.source1 = src1;
        this.source2 = src2;
    }

    public Object evaluate(Tuple t) {
        Object val1 = this.attr1Expr.evaluate(t);
        Object val2 = this.attr2Expr.evaluate(t);
        GQDatabaseRef src1 = this.source1;
        GQDatabaseRef src2 = this.source2;
        if (val1 instanceof AttributeValueSource) {
            src1 = ((AttributeValueSource)val1).getSource();
            val1 = ((AttributeValueSource)val1).getValue();
        }
        if (val2 instanceof AttributeValueSource) {
            src2 = ((AttributeValueSource)val2).getSource();
            val2 = ((AttributeValueSource)val2).getValue();
        }
        if (val1 == null) {
            return new AttributeValueSource(val2, src2);
        }
        if (val2 == null) {
            return new AttributeValueSource(val1, src1);
        }
        if (((Comparable)val1).compareTo(val2) < 0) {
            return new AttributeValueSource(val1, src1);
        }
        return new AttributeValueSource(val2, src2);
    }

    public String toString(Relation relation, Attribute outputAttribute) {
        String st = "MINREF(" + this.attr1Expr.toString(relation) + ", " + this.attr2Expr.toString(relation) + ")";
        if (outputAttribute != null) {
            return String.valueOf(st) + " AS " + outputAttribute.getName();
        }
        return st;
    }
}

