.code
;
; ****************************
; *****  %_rshift.giant  *****  logical right shift giant
; ****************************
;
; in:	edx:eax = source operand
;	ecx = number of bits to shift
; out:	edx:eax = result
;
; destroys: nothing
;
%_rshift.giant:
cmp	ecx,0													; shifting zero or fewer bits?
jle	> rshift_ret									; yes: result = input
cmp	ecx,64												; shifting 64 or more bits?
jge	> rshift_ret									; yes: result = input
cmp	cl,32
je	> grshift32										; shifting exactly 32 bits
ja	> grshift33										; shifting more than 32 bits
;																	; shifting less than 32 bits
shrd	eax,edx,cl
shr	edx,cl
ret
grshift32:												; shift right exactly 32 bits
mov	eax,edx												; copy most significant half to least signif.
xor	edx,edx												; clear most significant half
ret
grshift33:												; shift right more than 32 bits
mov	eax,edx												; copy most significant half to least signif.
xor	edx,edx												; clear most significant half
shr	eax,cl												; shift (cl - 32) bits
ret
rshift_ret:
ret
