'====================================================================
'                H I M E T e s t b e n c h . b a s
'                       Testprogram for:
'                        H I M E . d l l
'          Huge Integer Math and Encryption library dll
'                            V 1.03
'                 (C) 2002-2004 DevOTechS
'                 e-mail: support@devotechs.com
'
' This is a testprogram for testing the HIME.dll
' It is free for everyone to study and modify in able to get acquainted
' with the use and functioning of the HIME.dll
' DevOTechS does not accept responsibility for loss of data or 
' unexpected results from using this program.
' Use this program at your own risk!
'====================================================================
'
'====================================================================
'               H I M E  battery of tests
' The purpose of this code is to test all or most of the HIME functions for their proper
' functioning.
' You can enter a time in minutes. During this time, new random data is generated to feed the
' battery of tests and the tests are performed.
' After the prescribed time, the result of the tests is shown.
'
'               H I M E  random data generation
' You can generate a file with random data using the Blum-Blum-Shub or the RSA generator
'====================================================================

#PBFORMS Created
#COMPILE EXE
#DIM ALL



'--------------------------------------------------------------------------------
'   ** Includes **
'--------------------------------------------------------------------------------
#INCLUDE "HIME.inc"         'Include header file for HIME.dll


'--------------------------------------------------------------------------------
'   ** Globals **
'--------------------------------------------------------------------------------
GLOBAL hMain AS LONG



'--------------------------------------------------------------------------------
'   ** Constants **
'--------------------------------------------------------------------------------
$ProgramName          = "HIME - Testbench V1.03"
%TestBenchVersion     = 103
$BBSFile              = "BBS.txt"    
$RSAFile              = "RSA.txt"    
%WINAPI               = 1            
%TRUE                 = 1            
%FALSE                = 0            
%NULL                 = 0            
%STD_OUTPUT_HANDLE    = -11&         
%FOREGROUND_BLUE      = &H1          ' text color contains blue.
%FOREGROUND_GREEN     = &H2          ' text color contains green.
%FOREGROUND_RED       = &H4          ' text color contains red.
%WM_COMMAND           = &H111        
%WS_POPUP             = &H80000000   
%WS_CHILD             = &H40000000   
%WS_VISIBLE           = &H10000000   
%WS_CLIPSIBLINGS      = &H04000000   
%WS_CAPTION           = &H00C00000   ' WS_BORDER OR WS_DLGFRAME
%WS_BORDER            = &H00800000   
%WS_DLGFRAME          = &H00400000   
%WS_VSCROLL           = &H00200000   
%WS_HSCROLL           = &H00100000   
%WS_SYSMENU           = &H00080000   
%WS_TABSTOP           = &H00010000   
%WS_MINIMIZEBOX       = &H00020000   
%WS_MAXIMIZEBOX       = &H00010000   
%WS_EX_WINDOWEDGE     = &H00000100   
%WS_EX_CLIENTEDGE     = &H00000200   
%WS_EX_LEFT           = &H00000000   
%WS_EX_LTRREADING     = &H00000000   
%WS_EX_RIGHTSCROLLBAR = &H00000000   
%WS_EX_CONTROLPARENT  = &H00010000   
%HWND_DESKTOP         = 0            
%MB_YESNO             = &H00000004&  
%IDYES                = 6            
%ES_LEFT              = &H0&         
%ES_MULTILINE         = &H4&         
%ES_AUTOHSCROLL       = &H80&        
%EM_SETSEL            = &HB1         
%EM_SCROLLCARET       = &HB7         
%BN_CLICKED           = 0            
%SS_CENTER            = &H00000001   
%SS_CENTERIMAGE       = &H00000200   
%DS_3DLOOK            = &H0004&      
%DS_NOFAILCREATE      = &H0010&      
%DS_SETFONT           = &H0040&      ' User specified font for Dlg controls
%DS_MODALFRAME        = &H0080&      ' Can be combined with WS_CAPTION



#PBFORMS BEGIN CONSTANTS 
%IDD_DIALOG1        = 101
%IDC_LABEL1         = 1001
%IDC_BUTTON1        = 1002
%IDC_TestBatButt    = 1002
%IDC_LABEL2         = 1003
%IDC_BUTTON2        = 1004
%IDC_BBSfile        = 1004
%IDC_BBSalgo        = 1004
%IDC_BUTTON3        = 1005
%IDC_RSAalgo        = 1005
%IDC_RICHEDIT1      = 1006
%IDC_RTF            = 1006
%IDC_TEXTBOX1       = 1007
#PBFORMS END CONSTANTS
'--------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
'   ** Declarations **
'--------------------------------------------------------------------------------
DECLARE CALLBACK FUNCTION ShowDIALOG1Proc()
DECLARE FUNCTION ShowDIALOG1(BYVAL hParent AS DWORD) AS LONG

DECLARE FUNCTION ALLOCCONSOLE LIB "KERNEL32.DLL" ALIAS "AllocConsole" () AS LONG
DECLARE FUNCTION FREECONSOLE LIB "KERNEL32.DLL" ALIAS "FreeConsole" () AS LONG
DECLARE FUNCTION FREELIBRARY LIB "KERNEL32.DLL" ALIAS "FreeLibrary" (BYVAL hLibModule AS DWORD) AS LONG
DECLARE FUNCTION GETSTDHANDLE LIB "KERNEL32.DLL" ALIAS "GetStdHandle" (BYVAL nStdHandle AS DWORD) AS DWORD
DECLARE FUNCTION LOADLIBRARY LIB "KERNEL32.DLL" ALIAS "LoadLibraryA" (lpLibFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION SETCONSOLETEXTATTRIBUTE LIB "KERNEL32.DLL" ALIAS "SetConsoleTextAttribute" (BYVAL hConsoleOutput AS DWORD, BYVAL dwAttributes AS DWORD) AS LONG
DECLARE FUNCTION SETCONSOLETITLE LIB "KERNEL32.DLL" ALIAS "SetConsoleTitleA" (lpConsoleTitle AS ASCIIZ) AS LONG
DECLARE FUNCTION WRITECONSOLE LIB "KERNEL32.DLL" ALIAS "WriteConsoleA" (BYVAL hConsoleOutput AS DWORD, lpBuffer AS ASCIIZ, BYVAL nNumberOfCharsToWrite AS LONG, lpNumberOfCharsWritten AS LONG, BYVAL lpReserved AS LONG) AS LONG

#PBFORMS DECLARATIONS
'--------------------------------------------------------------------------------



'--------------------------------------------------------------------------------
'Print data in the textbox
SUB PrintData(Txt AS STRING)
    LOCAL T AS STRING
    
    CONTROL GET TEXT hMain, %IDC_TEXTBOX1 TO T
    T = T + $CRLF + Txt
    CONTROL SET TEXT hMain, %IDC_TEXTBOX1, T
    CONTROL SEND hMain, %IDC_TEXTBOX1, %EM_SETSEL, LEN(T), LEN(T)  'Cursor to end of text
    CONTROL SEND hMain, %IDC_TEXTBOX1, %EM_SCROLLCARET, 0, 0       'send window down to the cursor
END SUB



'--------------------------------------------------------------------------------
'Run HIME battery of tests. 
'This is a series of tests to check proper functioning of the various HIME.dll functions.
SUB BatteryOfTests
    LOCAL StartTime        AS SINGLE
    LOCAL h                AS STRING
    LOCAL h1               AS STRING
    LOCAL DH_P             AS STRING    
    LOCAL DH_G             AS STRING
    LOCAL One              AS STRING
    LOCAL DH_Bitlength     AS LONG
    LOCAL i                AS LONG
    LOCAL j                AS LONG
    LOCAL Result           AS LONG
    LOCAL Tests            AS QUAD
    LOCAL Errors           AS QUAD
    LOCAL BitLength        AS LONG
    LOCAL TestTime         AS SINGLE
    LOCAL shouldbe$
    LOCAL pdword           AS DWORD POINTER
    LOCAL t$
        
    DIM   h(10)     AS LOCAL STRING


                'Enter time for battery of tests
    h1 = INPUTBOX$("For how long do you want to perform tests (in minutes):",$ProgramName,"1")
    TestTime  = VAL(h1) * 60
        
                'Store values "0", "1" and "2" in registers 7, 8 and 9
    CALL hi_PutReg(MKL$(0), 7)
    CALL hi_PutReg(MKL$(1), 8)
    CALL hi_PutReg(MKL$(2), 9)

    PrintData "Tests started..."
    PrintData "One-time tests running.."
    MOUSEPTR 11
    FOR i = 1 TO 10
        DIALOG DOEVENTS
    NEXT i
    
    StartTime = TIMER
            'Check testvectors for AES
    INCR Tests
    PrintData "Checking AES testvectors"
    i = hi_CheckTestVectors_AES
    IF i <> 0 THEN
        PrintData "Error(s) in hi_CheckTestVectors_AES:" + STR$(i) + " error(s)"
        INCR Errors
        SLEEP 10000        
    END IF     



            'Check testvectors for ArcFour
    INCR Tests
    PrintData "Checking ArcFour testvectors"
    i = hi_CheckTestVectors_Arc4
    IF i <> 0 THEN
        PrintData "Error(s) in hi_CheckTestVectors_Arc4:" + STR$(i) + " error(s)"
        INCR Errors
        SLEEP 10000        
    END IF
    

            'Check testvectors for SHA-1
    INCR Tests
    PrintData "Checking SHA-1 testvectors"
    i = hi_CheckTestVectors_SHA_1
    IF i <> 0 THEN
        PrintData "Error(s) in hi_CheckTestVectors_SHA_1:" + STR$(i) + " error(s)"
        INCR Errors
        SLEEP 10000        
    END IF
    
        
      
            'Check testvectors for SHA-256
    INCR Tests
    PrintData "Checking SHA-256 testvectors"
    i = hi_CheckTestVectors_SHA_256
    IF i <> 0 THEN
        PrintData "Error(s) in hi_CheckTestVectors_SHA_256:" + STR$(i) + " error(s)"
        INCR Errors
        SLEEP 10000        
    END IF    


      
            'Check testvectors for MD5
    INCR Tests
    PrintData "Checking MD5 testvectors"
    i = hi_CheckTestVectors_MD5
    IF i <> 0 THEN
        PrintData "Error(s) in hi_CheckTestVectors_MD5:" + STR$(i) + " error(s)"
        INCR Errors
        SLEEP 10000        
    END IF
    
    
    

            'Diffie-Hellman step 0: generate parameters P and G
    PrintData "Diffie-Hellman: Generating parameters P and G"
    DH_Bitlength = 96                   'Bitlength of parameter P   
    hi_DH_GenParams(DH_Bitlength, 1, 2) '(lBitLength AS LONG, lRegP AS LONG, lRegG AS LONG)
    DH_P = hi_GetReg(1)                 'Diffie-Hellman parameter P (a safe prime number)
    DH_G = hi_GetReg(2)                 'Diffie-Hellman parameter G (a generator for P)
    

    PrintData ""
    PrintData "Continuous tests running.."
    DO
        DIALOG DOEVENTS
                '(1)a: hi_Add , hi_Sub
        INCR Tests
        BitLength = RND(3, 14) * 8        'Generate a random bitlength of variables to create
        CALL hi_GenerateRandom(BitLength, 1) 'Calculate a random number        --> h1
        CALL hi_GenerateRandom(BitLength, 2) 'Calculate a second random number --> h2
        CALL hi_Add(1,2,3)                   'h3 = h1 + h2
        CALL hi_Sub(3,2,4)                   'h4 = h3 - h2
                                        'So, h4 should equal h1
        IF hi_IsNotEqual(1,4) THEN
            PrintData "Error in (1)a hi_Add , hi_Sub"
            INCR Errors
            SLEEP 10000
        END IF

                '(1)b: hi_Add , hi_MulBy2
        INCR Tests
        BitLength = RND(3, 14) * 8        'Generate a random bitlength of variables to create
        CALL hi_GenerateRandom(BitLength, 1) 'Calculate a random number        --> h1
        CALL hi_Add(1, 1, 2)                 'h2 = h1 + h1
        CALL hi_MulBy2(1, 3)                 'h3 = h1 * 2
                                        'So, h2 should equal h3
        IF hi_IsNotEqual(2, 3) THEN
            PrintData "Error in (1)b hi_Add , hi_MulBy2"
            INCR Errors
            SLEEP 10000
        END IF


                '(2)a hi_Mul , hi_Div
        INCR Tests
        BitLength = RND(4, 32) * 8
        CALL hi_GenerateRandom(BitLength, 1) 'Calculate a random number        --> h1
        CALL hi_GenerateRandom(BitLength, 2) 'Calculate a second random number --> h2

        IF hi_IsLess(1, 2) = 1 THEN CALL hi_SwapReg(1, 2)

        CALL hi_Div(1, 2, 3, 4)     'h1 \ h2 = h3, h4 is remainder
        CALL hi_Mul(3, 2, 5)        'h3 * h2 = h5
        CALL hi_Add(5, 4, 6)        'h5 + h4 = h6
        IF hi_IsNotEqual(1, 6) THEN
            PrintData "Error in (2)a hi_Mul, hi_Div"
            INCR Errors
        END IF


                '(2)b hi_Div , hi_DivBy2
        INCR Tests
        BitLength = RND(4, 32) * 8
        CALL hi_GenerateRandom(BitLength, 1) 'Calculate a random number        --> h1
        CALL hi_GenerateRandom(BitLength, 2) 'Calculate a second random number --> h2

        CALL hi_Div(1, 9, 3, 4)      'h1 \ Two = h3, h4 is remainder
        CALL hi_DivBy2(1, 5, 6)      'h1 \ 2   = h5, h6 is remainder
        IF (hi_IsNotEqual(3, 5)) OR (hi_IsNotEqual(4, 6)) THEN
            PrintData "Error in (2)b hi_Div , hi_DivBy2"
            INCR Errors
        END IF


                '(3) hi_Mul , hi_MulBy2
        INCR Tests
        BitLength = RND(4, 64) * 8
        CALL hi_GenerateRandom(BitLength, 1)
        CALL hi_Mul   (1, 9, 2)    'h1 * Two = h2
        CALL hi_MulBy2(1, 3)       'h1 * 2   = h3
        IF hi_IsNotEqual(2, 3) THEN
            PrintData "Error in (3) hi_Mul, hi_MulBy2"
            INCR Errors
        END IF


                '(4) hi_Div , hi_DivBy2
        INCR Tests
        BitLength = RND(4, 64) * 8
        CALL hi_GenerateRandom(BitLength, 1)
        CALL hi_Div   (1, 9, 2, 5)   'h1 \ Two = h2, h5 is remainder
        CALL hi_DivBy2(1, 3, 6)      'h1 \ 2   = h3, h6 is remainder
        IF (hi_IsNotEqual(2, 3)) OR (hi_IsNotEqual(5, 6)) THEN
            PrintData "Error in (4) hi_Div, hi_DivBy2"
            INCR Errors
        END IF

                '(5) hi_Huge2Dec , hi_Dec2Huge
        INCR Tests
        BitLength = RND(4, 5) * 8
        CALL hi_GenerateRandom(BitLength, 1)
        CALL hi_Huge2Dec(1, 2)    'h1 (binary) --> h2 (ascii decimal)
        CALL hi_Dec2Huge(2, 3)    'h2 (ascii decimal) --> h2 (binary)
        IF hi_IsNotEqual(1, 3) THEN
            PrintData "Error in (5) hi_Huge2Dec , hi_Dec2Huge"
            INCR Errors
        END IF

                '(6) hi_Pow
        INCR Tests
        BitLength = RND(4, 16) * 8
        CALL hi_GenerateRandom(BitLength, 1)
        i  = RND(2,10)          'Exponent
        CALL hi_PutReg(MKL$(i), 2)
        CALL hi_Pow(1, 2, 3)         'h1 ^ h2 = h3
        CALL hi_CopyReg(8, 4)        'h4 = One
        FOR j = 1 TO i
            CALL hi_Mul(4, 1, 4)     'h4 * h1 = h4
        NEXT j
        IF hi_IsNotEqual(3, 4) THEN
            PrintData "Error in (6) hi_Pow"
            INCR Errors
            SLEEP 2000
        END IF


                '(7) hi_PowMod
        INCR Tests
        BitLength = RND(16, 64) * 8
        CALL hi_GenerateRandom(BitLength, 1)

        i  = RND(2,10)          'Exponent
        CALL hi_PutReg(MKL$(i), 2)

        BitLength = RND(8, 64) * 8
        CALL hi_GenerateRandom(BitLength, 3)

        CALL hi_Pow(1, 2, 4)         'h1 ^ h2   = h4
        CALL hi_Mod(4, 3, 5)         'h4 mod h3 = h5

        CALL hi_PowMod(1, 2, 3, 6)   'h1 ^ h2 mod h3 = h6
        IF hi_IsNotEqual(5, 6) THEN
            PrintData "Error in (7) hi_PowMod"
            INCR Errors
            SLEEP 2000
        END IF

                '(8) hi_IsLess
        INCR Tests
        BitLength = RND(4, 16) * 8
        CALL hi_GenerateRandom(BitLength, 1)
        CALL hi_CopyReg(1, 2)            'h2 = h1
        CALL hi_Add(2, 8, 2)             'h2 = h2 + 1
        IF hi_IsLess(1, 2) = 0 THEN
            PrintData "Error in (8a) hi_IsLess"
            INCR Errors
            SLEEP 2000
        END IF

        IF hi_IsLess(2, 1) = 1 THEN
            PrintData "Error in (8b) h_IsLess"
            INCR Errors
            SLEEP 2000
        END IF

                '(9) hi_IsZero
        INCR Tests
        BitLength = RND(4, 16) * 8
        CALL hi_GenerateRandom(BitLength, 1)
        IF (hi_IsZero(1) = %True) OR (hi_IsZero(7) = %False)THEN
            PrintData "Error in (9) hi_IsZero"
            INCR Errors
            SLEEP 2000
        END IF

                '(10) hi_IsOdd
        INCR Tests
        BitLength = RND(4, 16) * 8
        CALL hi_GenerateRandom(BitLength, 1)
        CALL hi_MulBy2(1, 1)         'Make sure h1 is even
        CALL hi_Add(1, 8, 2)         'Make it odd: h2 = h1 + 1
        IF (hi_IsOdd(1) = %True) OR (hi_IsOdd(2) = %False) THEN
            PrintData "Error in (10) hi_IsOdd"
            INCR Errors
            SLEEP 2000
        END IF

                '(11) hi_IsEqual
        INCR Tests
        BitLength = RND(4, 16) * 8
        CALL hi_GenerateRandom(BitLength, 1)
        CALL hi_CopyReg(1, 2)            'h2 = h1
        CALL hi_MulBy2(2, 3)             'h3 = h2 * 2
        IF (hi_IsEqual(1, 2) = %False) OR (hi_IsEqual(3, 2) = %True) THEN
            PrintData "Error in (11) hi_IsEqual"
            INCR Errors
            SLEEP 2000
        END IF

                '(12) hi_GCD
        INCR Tests
        BitLength = RND(4, 12) * 8
        CALL hi_GeneratePrime(BitLength, 9, 1)   'h1 is a prime
        CALL hi_GeneratePrime(BitLength, 9, 2)   'h2 is a prime
                'So the GCD of these two should be 1
        CALL hi_GCD(1, 2, 3)                     'h3 is GCD, h8 is One
        IF hi_IsEqual(3, 8) = %False THEN
            PrintData "Error in (12) hi_GCD"
            INCR Errors
            SLEEP 2000
        END IF

                '(13) hi_ModInv
        INCR Tests
        BitLength = RND(4, 8) * 8
                'Generate 2 randoms that are relative primes, otherwise 'hi_ModInv' doesn't
                'deliver a result
        CALL hi_GenerateRandom(BitLength, 1)
        DO
            CALL hi_GenerateRandom(BitLength, 2)
        LOOP UNTIL hi_IsRelPrime(1, 2) = %True

        Result = hi_ModInv(1, 2, 3)      'h3 = h1^-1 MOD h2
        IF Result = 0 THEN          'h1 and h2 are relative primes
            CALL hi_Mul(1, 3, 4)         'h4 = h1 * h3
            CALL hi_Mod(4, 2, 5)         'h5 = h4 mod h2
                        'h5 should be equal to One..
            IF hi_IsEqual(5, 8) = %False THEN
                PrintData "Error in (13) hi_ModInv"
                CALL hi_Huge2Hex(1, 6)
                PrintData hi_GetReg(6)
                CALL hi_Huge2Hex(2, 6)
                PrintData hi_GetReg(6)
                CALL hi_Huge2Hex(3, 6)
                PrintData hi_GetReg(6)

                INCR Errors
                SLEEP 2000
            END IF
        END IF

        DIALOG DOEVENTS    
        
                '(14) hi_GeneratePrimes, hi_GCD
        INCR Tests
                'Generate 2 randoms that are relative primes, otherwise 'hi_ModInv' doesn't
                'deliver a result
        BitLength = RND(5, 16) * 8
        CALL hi_GeneratePrime(32, 8, 1)      'Generate 3 primes, h1, h2 and h3..
        BitLength = RND(5, 16) * 8
        CALL hi_GeneratePrime(BitLength, 8, 2)
        BitLength = RND(5, 16) * 8
        CALL hi_GeneratePrime(BitLength, 8, 3)

                'Create 2 numbers by multiplying 2 primes
        CALL hi_Mul(1, 2, 4)                 'h4 = h1 * h2
        CALL hi_Mul(1, 3, 5)                 'h5 = h1 * h3
                'GCD of h4 and h5 must be h1 !
        CALL hi_GCD(4, 5, 6)                 'So, h6 should be equal to h1

        IF hi_IsNotEqual(1, 6) THEN
            PrintData "Error in (14) hi_GeneratePrimes, hi_GCD"
            INCR Errors
            SLEEP 2000
        END IF


                '(15) hi_IsPrime_Div, hi_IsPrime_F, hi_IsPrime_RB
        INCR Tests
                'In previous test, a prime was generated. We are going to test this variable to see
                'if it is really prime.
        IF  (hi_IsPrime_Div(1)   = %False) OR _
            (hi_IsPrime_F(4, 1)  = %False) OR _
            (hi_IsPrime_RB(4, 1) = %False) THEN
                PrintData "Error in (15) (hi_IsPrime_Div, hi_IsPrime_F, hi_IsPrime_RB"
                INCR Errors
                SLEEP 2000
        END IF

                '(16) hi_IsPrime_Div, hi_IsPrime_F, hi_IsPrime_RB
        INCR Tests
                'Generate a number that is definitely NOT prime:
        BitLength = RND(4, 16) * 8
        CALL hi_GenerateRandom(BitLength, 1)
        CALL hi_MulBy2(1, 1)                 'h1 = h1 * 2
                'Test it for primality:
        IF  (hi_IsPrime_Div(1)   = %True) OR _
            (hi_IsPrime_F(4, 1)  = %True) OR _
            (hi_IsPrime_RB(4, 1) = %True) THEN
                PrintData "Error in (16) (hi_IsPrime_Div, hi_IsPrime_F, hi_IsPrime_RB"
                INCR Errors
                SLEEP 2000
        END IF


                '(17) hi_IsPrime_Slow
        INCR Tests
                'Generate a small prime:
        CALL hi_GeneratePrime(32, 8, 1)
        IF  hi_IsPrime_Slow(1) = %False THEN
            PrintData "Error in (17) hi_IsPrime_Slow"
            INCR Errors
            SLEEP 2000
        END IF


                '(18) hi_IsPrime_Slow
        INCR Tests
                'Generate a number that is definitely NOT prime:
        BitLength = 32
        CALL hi_GenerateRandom(BitLength, 1)
        CALL hi_MulBy2(1, 1)                 'h1 = h1 * 2
        IF  hi_IsPrime_Slow(1) = %True THEN
            PrintData "Error in (18) hi_IsPrime_Slow"
            INCR Errors
            SLEEP 2000
        END IF


                '(19) hi_Encrypt_RSA, hi_Decrypt_RSA
        INCR Tests
        BitLength = RND(6, 16) * 8
                    'Generate a RSA keypair (he, hd, hn)
        CALL hi_GenerateRSAKeys(BitLength, 5,1,2,3) 'Bitlength, Primetests, he, hd, hn
                    'Generate some random plaintext in register 4 (that is smaller
                    'than the modulus of the keypair..)
        DO
            CALL hi_GenerateRandom(BitLength - 8, 4)
        LOOP UNTIL hi_IsLess(4, 3)

                    'Encrypt plaintext
        i = hi_Encrypt_RSA(4,1,3,5)     'plaintext, he, hn, ciphertext
        SELECT CASE i
            CASE 1
                PrintData "Plaintext length is not a multiple of 4 bytes!"
                SLEEP 2000
            CASE 2
                PrintData "Plaintext is larger than modulus!"
                SLEEP 2000
        END SELECT
                    'Decrypt ciphertext into plaintext
        i = hi_Decrypt_RSA(5,2,3,6)         'ciphertext, hd, hn, new plaintext

        SELECT CASE i
            CASE 1
                PrintData "Ciphertext length is not a multiple of 4 bytes!"
                SLEEP 2000
            CASE 2
                PrintData "Ciphertext is larger than modulus!"
                SLEEP 2000
        END SELECT

                    'Check if encryption/decryption was succesfull
        IF hi_IsNotEqual(4, 6) THEN
                'Decrypted ciphertext does not equal original plaintext...
            PrintData "Error in (19) hi_Encrypt_RSA, hi_Decrypt_RSA"
            PrintData "Decrypted ciphertext does not equal original plaintext..."
            INCR Errors
            SLEEP 2000
        END IF


                '(21) hi_Encrypt_AES_CBC, hi_Decrypt_AES_CBC
                '=====128 bits key (16 bytes)===============
        INCR Tests
                'Generate a random number to serve as plaintext:
        i = RND(2, 50)
        h = ""
        FOR j = 1 TO i
            h = h + CHR$(RND(0, 255))
        NEXT j
        hi_PutReg h, 1
        
                'Generate a random number to serve as key:
        BitLength = 16 * 8
        CALL hi_GenerateRandom(BitLength, 2)
                'Generate a random number to serve as IV:
        BitLength = 16 * 8
        CALL hi_GenerateRandom(BitLength, 3)
                'Encrypt plaintext
        hi_Encrypt_AES_CBC 1, 2, 3, 4   'Register 4 contains ciphertext
                'Decrypt ciphertext
        hi_Decrypt_AES_CBC 4, 2, 5      'Register 5 contains decrypted plaintext
        
                'Compare original and decrypted plaintext
        IF  hi_IsNotEqual(5, 1) THEN
            PrintData "(21) hi_Encrypt_AES_CBC, hi_Decrypt_AES_CBC, 128 bit key"
            INCR Errors
            SLEEP 2000
        END IF

                '=====192 bits key (24 bytes)===============
        INCR Tests
                'Generate a random number to serve as plaintext:
        i = RND(2, 50)
        h = ""
        FOR j = 1 TO i
            h = h + CHR$(RND(0, 255))
        NEXT j
        hi_PutReg h, 1
        
                'Generate a random number to serve as key:
        BitLength = 24 * 8
        CALL hi_GenerateRandom(BitLength, 2)
                'Generate a random number to serve as IV:
        BitLength = 16 * 8
        CALL hi_GenerateRandom(BitLength, 3)
                'Encrypt plaintext
        hi_Encrypt_AES_CBC 1, 2, 3, 4   'Register 4 contains ciphertext
                'Decrypt ciphertext
        hi_Decrypt_AES_CBC 4, 2, 5      'Register 5 contains decrypted plaintext
        
                'Compare original and decrypted plaintext
        IF  hi_IsNotEqual(5, 1) THEN
            PrintData "(21) hi_Encrypt_AES_CBC, hi_Decrypt_AES_CBC, 192 bit key"
            INCR Errors
            SLEEP 2000
        END IF

                '=====256 bits key (32 bytes)===============
        INCR Tests
                'Generate a random number to serve as plaintext:
        i = RND(2, 150)
        h = ""
        FOR j = 1 TO i
            h = h + CHR$(RND(0, 255))
        NEXT j
        'PrintData "len plaintext:" + STR$(LEN(h))
        hi_PutReg h, 1
        
                'Generate a random number to serve as key:
        BitLength = 32 * 8
        CALL hi_GenerateRandom(BitLength, 2)
                'Generate a random number to serve as IV:
        BitLength = 16 * 8
        CALL hi_GenerateRandom(BitLength, 3)
                'Encrypt plaintext
        hi_Encrypt_AES_CBC 1, 2, 3, 4   'Register 4 contains ciphertext
                'Decrypt ciphertext
        hi_Decrypt_AES_CBC 4, 2, 5      'Register 5 contains decrypted plaintext
        
                'Compare original and decrypted plaintext
        IF  hi_IsNotEqual(5, 1) THEN
            PrintData "(21) hi_Encrypt_AES_CBC, hi_Decrypt_AES_CBC, 256 bit key"
            INCR Errors
            SLEEP 2000
        END IF



                '(22) hi_Encrypt_AES_ECB, hi_Decrypt_AES_ECB
                '=====128 bits key (16 bytes)===============
        INCR Tests
                'Generate a random number to serve as plaintext:
        i = RND(2, 50)
        h = ""
        FOR j = 1 TO i
            h = h + CHR$(RND(0, 255))
        NEXT j
        hi_PutReg h, 1      'Store plaintext in register 1
        
                'Generate a random number to serve as key:
        BitLength = 16 * 8
        CALL hi_GenerateRandom(BitLength, 2)

                'Encrypt plaintext
        hi_Encrypt_AES_ECB 1, 2, 4   'Register 4 contains ciphertext
                'Decrypt ciphertext
        hi_Decrypt_AES_ECB 4, 2, 5      'Register 5 contains decrypted plaintext
        
                'Compare original and decrypted plaintext
        IF  hi_IsNotEqual(5, 1) THEN
            PrintData "(21) hi_Encrypt_AES_ECB, hi_Decrypt_AES_ECB, 128 bit key"
            INCR Errors
            SLEEP 2000
        END IF

                '=====192 bits key (24 bytes)===============
        INCR Tests
                'Generate a random number to serve as plaintext:
        i = RND(2, 50)
        h = ""
        FOR j = 1 TO i
            h = h + CHR$(RND(0, 255))
        NEXT j
        hi_PutReg h, 1      'Store plaintext in register 1
        
                'Generate a random number to serve as key:
        BitLength = 24 * 8
        CALL hi_GenerateRandom(BitLength, 2)

                'Encrypt plaintext
        hi_Encrypt_AES_ECB 1, 2, 4   'Register 4 contains ciphertext
                'Decrypt ciphertext
        hi_Decrypt_AES_ECB 4, 2, 5      'Register 5 contains decrypted plaintext
        
                'Compare original and decrypted plaintext
        IF  hi_IsNotEqual(5, 1) THEN
            PrintData "(21) hi_Encrypt_AES_ECB, hi_Decrypt_AES_ECB, 192 bit key"
            INCR Errors
            SLEEP 2000
        END IF

                '=====256 bits key (32 bytes)===============
        INCR Tests
                'Generate a random number to serve as plaintext:
'        BitLength = RND(60, 800)
'        CALL hi_GenerateRandom(BitLength, 1)
        i = RND(2, 150)
        h = ""
        FOR j = 1 TO i
            h = h + CHR$(RND(0, 255))
        NEXT j
        'PrintData "len plaintext:" + STR$(LEN(h))
        hi_PutReg h, 1      'Store plaintext in register 1
        
                'Generate a random number to serve as key:
        BitLength = 32 * 8
        CALL hi_GenerateRandom(BitLength, 2)

                'Encrypt plaintext
        hi_Encrypt_AES_ECB 1, 2, 4   'Register 4 contains ciphertext
                'Decrypt ciphertext
        hi_Decrypt_AES_ECB 4, 2, 5      'Register 5 contains decrypted plaintext
        
                'Compare original and decrypted plaintext
        IF  hi_IsNotEqual(5, 1) THEN
            PrintData "(21) hi_Encrypt_AES_ECB, hi_Decrypt_AES_ECB, 256 bit key"
            INCR Errors
            SLEEP 2000
        END IF




                '(23) hi_Encrypt_AES_1Block, hi_Decrypt_AES_1Block
                '=====128 bits key (16 bytes)===============
        INCR Tests
                'Generate a random number to serve as plaintext:
        BitLength = 128 'bits =  16 bytes =  1 AES block
        CALL hi_GenerateRandom(BitLength, 1)
        
                'Generate a random number to serve as key:
        BitLength = 16 * 8
        CALL hi_GenerateRandom(BitLength, 2)

                'Encrypt plaintext
        hi_Encrypt_AES_1Block 1, 2, 4   'Register 4 contains ciphertext
                'Decrypt ciphertext
        hi_Decrypt_AES_1Block 4, 2, 5      'Register 5 contains decrypted plaintext
        
                'Compare original and decrypted plaintext
        IF  hi_IsNotEqual(5, 1) THEN
            PrintData "(23) hi_Encrypt_AES_1Block, hi_Decrypt_AES_1Block, 128 bit key"
            INCR Errors
            SLEEP 2000
        END IF

                '=====192 bits key (24 bytes)===============
        INCR Tests
                'Generate a random number to serve as plaintext:
        BitLength = 128 'bits =  16 bytes =  1 AES block
        CALL hi_GenerateRandom(BitLength, 1)
        
                'Generate a random number to serve as key:
        BitLength = 24 * 8
        CALL hi_GenerateRandom(BitLength, 2)

                'Encrypt plaintext
        hi_Encrypt_AES_1Block 1, 2, 4   'Register 4 contains ciphertext
                'Decrypt ciphertext
        hi_Decrypt_AES_1Block 4, 2, 5      'Register 5 contains decrypted plaintext
        
                'Compare original and decrypted plaintext
        IF  hi_IsNotEqual(5, 1) THEN
            PrintData "(23) hi_Encrypt_AES_1Block, hi_Decrypt_AES_1Block, 192 bit key"
            INCR Errors
            SLEEP 2000
        END IF

                '=====256 bits key (32 bytes)===============
        INCR Tests
                'Generate a random number to serve as plaintext:
        BitLength = 128 'bits =  16 bytes =  1 AES block
        CALL hi_GenerateRandom(BitLength, 1)
        
                'Generate a random number to serve as key:
        BitLength = 32 * 8
        CALL hi_GenerateRandom(BitLength, 2)

                'Encrypt plaintext
        hi_Encrypt_AES_1Block 1, 2, 4   'Register 4 contains ciphertext
                'Decrypt ciphertext
        hi_Decrypt_AES_1Block 4, 2, 5      'Register 5 contains decrypted plaintext
        
                'Compare original and decrypted plaintext
        'hi_SwapReg 5, 6                
        IF  hi_IsNotEqual(5, 1) THEN
            PrintData "(23) hi_Encrypt_AES_1Block, hi_Decrypt_AES_1Block, 256 bit key"
            INCR Errors
            SLEEP 2000
        END IF


                '(24) hi_Huge2Hex, hi_Hex2Huge
        INCR Tests
        BitLength = RND(3, 50) * 8        'Generate a random bitlength
        CALL hi_GenerateRandom(BitLength, 1) 'Calculate a random number        --> h1
                
        hi_Huge2Hex 1, 2
        hi_Hex2Huge 2, 3
                                
        IF  hi_IsNotEqual(1, 3) = %True THEN
            PrintData "Error in (24) hi_Huge2Hex, hi_Hex2Huge"
            INCR Errors
            SLEEP 2000
        END IF


                '(25) hi_Huge2Base64, hi_Base642Huge
        INCR Tests
        BitLength = RND(3, 50) * 8        'Generate a random bitlength
        CALL hi_GenerateRandom(BitLength, 1) 'Calculate a random number        --> h1
                
        hi_Huge2Base64 1, 2
        hi_BreakString 2, 4, 1, 3, 3
        i = hi_Base642Huge(3, 4)

        IF  i <> 0 THEN
            PrintData "Error in (25) hi_Huge2Base64, hi_Base642Huge"
            PrintData "Base64 string was not a multiple of 4 bytes!"
            INCR Errors
            SLEEP 2000
        END IF
                                        
        IF  hi_IsNotEqual(1, 4) = %True THEN
            PrintData "Error in (25) hi_Huge2Base64, hi_Base642Huge"
            INCR Errors
            SLEEP 2000
        END IF


                '(26) Test for Diffie-Hellman algorithm
        INCR Tests                
                '-1)Restore the previously generated parameters P and G:
        hi_PutReg(DH_P, 1)
        hi_PutReg(DH_G, 2)
                
                '-2) First let's pretend that we are Alice:
                '-2a) Make up a private key (0 < PrivKey < P-1) and keep it secret!            
        hi_GenerateRandom(DH_Bitlength - 8, 3)  'Store Alices private key in register 3
                '-2b) Calculate a public key for Alice and store in register 4
        i = hi_DH_Step1(1, 2, 3, 4) '(lRegP AS LONG, lRegG AS LONG, lPriv AS LONG, lPub AS LONG)
        IF  i <> 0 THEN
            PrintData "Error in (26) Test for Diffie-Hellman algorithm"
            PrintData "Return value:" + STR$(i)
            PrintData "Alice: Illegal input parameter"
            INCR Errors
            SLEEP 2000
        END IF
        
                '-3) Next let's pretend that we are Bob:
                '-3a) Make up a private key (0 < PrivKey < P-1) and keep it secret!            
        hi_GenerateRandom(DH_Bitlength - 8, 13)  'Store Bobs private key in register 13
                '-3b) Calculate a public key for Bob and store in register 14
        i = hi_DH_Step1(1, 2, 13, 14) '(lRegP AS LONG, lRegG AS LONG, lPriv AS LONG, lPub AS LONG)
        IF  i <> 0 THEN
            PrintData "Error in (26) Test for Diffie-Hellman algorithm"
            PrintData "Return value:" + STR$(i)
            PrintData "Bob: Illegal input parameter"
            INCR Errors
            SLEEP 2000
        END IF        
        
                '-4) Alice sends her public key to Bob and Bob sends his public key
                '   to Alice
                
                '-5) Alice calculates her shared key, using her own private key and Bobs public key
                '   Alices shared key is in register 5
        i = hi_DH_Step2(1, 14, 3, 5) '(lRegP AS LONG, lPub AS LONG, lPriv AS LONG, lShared AS LONG)
        IF  i <> 0 THEN
            PrintData "Error in (26) Test for Diffie-Hellman algorithm"
            PrintData "Return value:" + STR$(i)
            PrintData "Calculating Alices shared key: Illegal input parameter"
            INCR Errors
            SLEEP 2000
        END IF    

                '-6) Bob calculates his shared key, using his own private key and Alicess public key
                '   Bobs shared key is in register 15
        i = hi_DH_Step2(1, 4, 13, 15) '(lRegP AS LONG, lPub AS LONG, lPriv AS LONG, lShared AS LONG)
        IF  i <> 0 THEN
            PrintData "Error in (26) Test for Diffie-Hellman algorithm"
            PrintData "Return value:" + STR$(i)
            PrintData "Calculating Bobs shared key: Illegal input parameter"
            INCR Errors
            SLEEP 2000
        END IF
                    
                '-7) Both Alices and Bobs shared key MUST be the same! Check this:
        IF hi_IsNotEqual(5, 15) THEN
            PrintData "Error in (26) Test for Diffie-Hellman algorithm"
            PrintData "Calculated shared keys do NOT match!"
            INCR Errors
            SLEEP 2000        
        END IF        



                '(27) hi_Huge2Bin , hi_Bin2Huge
        INCR Tests
        BitLength = RND(1, 10) * 8
        CALL hi_GenerateRandom(BitLength, 1)
        CALL hi_Huge2Bin(1, 2)    'h1 (huge) --> h2 (ascii binary)
        CALL hi_Bin2Huge(2, 3)    'h2 (ascii binary) --> h2 (huge)
        IF hi_IsNotEqual(1, 3) THEN
            PrintData "Error in (27) hi_Huge2Bin , hi_Bin2Huge"
            INCR Errors
        END IF
        
        
                '(28) hi_Incr
        INCR Tests
        CALL hi_PutReg(MKL$(1), 8)           'Store value 1 in h8
        BitLength = RND(3, 14) * 8           'Generate a random bitlength of variables to create
        CALL hi_GenerateRandom(BitLength, 1) 'Calculate a random number        --> h1
        CALL hi_Incr(1,3)                    'h3 = h1 + 1
        CALL hi_Sub(3,8,4)                   'h4 = h3 - 1
                                             'So, h4 should equal h1
        IF hi_IsNotEqual(1,4) THEN
            PrintData "(28)a: hi_Incr"
            INCR Errors
            SLEEP 10000
        END IF        
        


                '(29) hi_Decr
        INCR Tests
        'CALL hi_PutReg(MKL$(1), 8)           'Store value 1 in h8
        BitLength = RND(3, 14) * 8           'Generate a random bitlength of variables to create
        CALL hi_GenerateRandom(BitLength, 1) 'Calculate a random number        --> h1
        CALL hi_Decr(1,3)                    'h3 = h1 - 1
        CALL hi_Add(3,8,4)                   'h4 = h3 + 1
                                             'So, h4 should equal h1
        IF hi_IsNotEqual(1,4) THEN
            PrintData "(29)a: hi_Decr"
            INCR Errors
            SLEEP 10000
        END IF
        

                '(30) hi_Encrypt_Arc4, hi_Decrypt_Arc4
        INCR Tests
                'Generate a plaintext
        BitLength = RND(3, 32) * 8           'Generate a random bitlength of variables to create
        CALL hi_GenerateRandom(BitLength, 1) 'Calculate a random number        --> h1
                'Generate a key
        BitLength = RND(3, 32) * 8           'Generate a random bitlength of variables to create
        CALL hi_GenerateRandom(BitLength, 2) 'Calculate a random number        --> h2

                'Encrypt plaintext with ArcFour algorithm
        CALL hi_Encrypt_Arc4(1, 2, 3, 0)
                'Decrypt plaintext with ArcFour algorithm
        CALL hi_Decrypt_Arc4(3, 2, 4, 0)
                
        IF hi_IsNotEqual(1,4) THEN
            PrintData "(30)a:  hi_Encrypt_Arc4, hi_Decrypt_Arc4"
            INCR Errors
            SLEEP 10000
        END IF
        
                'Encrypt plaintext with ArcFour algorithm
        CALL hi_Encrypt_Arc4(1, 2, 3, 256)
                'Decrypt plaintext with ArcFour algorithm
        CALL hi_Decrypt_Arc4(3, 2, 4, 256)
                
        IF hi_IsNotEqual(1,4) THEN
            PrintData "(30)b:  hi_Encrypt_Arc4, hi_Decrypt_Arc4"
            INCR Errors
            SLEEP 10000
        END IF
        
                        
        DIALOG DOEVENTS
    LOOP UNTIL (TIMER - StartTime) > TestTime
    PrintData STR$(Tests) & " tests done, " & STR$(Errors) & " errors"
    PrintData "GlobalError:" + STR$(hi_GetGlobalError)
    PrintData "---------------------------"
    MOUSEPTR 1
END SUB


'--------------------------------------------------------------------------------
'Generate a file with random data using the Blum-Blum-Shub algorithm
SUB CreateBBSfile
    LOCAL h                AS STRING
    LOCAL i                AS LONG
    LOCAL BBSFile          AS STRING
    LOCAL ModulusLength    AS LONG
    LOCAL MulBits          AS LONG
    LOCAL ChunkLen         AS LONG
    LOCAL RandomBytesK     AS LONG

            'Input some parameters
    h = INPUTBOX$("Enter bitlength of BBS modulus:", "HIME", "128")
    ModulusLength  = VAL(h)
    h = INPUTBOX$("Multiple bits per calculation? (y/n):", "HIME", "y")
    IF h = "y" THEN MulBits = %True ELSE MulBits = %False
    PrintData "BBS modulus bitlenght: " & STR$(ModulusLength)

    h = INPUTBOX$("How many kbytes to generate:", "HIME", "10000")
    RandomBytesK = VAL(h)
        
    PrintData "Generating file with random data, BBS algorithm:"
    PrintData CURDIR$ + "\" + $BBSFile
        
            'Init the BBS parameters: modulus and seed
    CALL hi_InitBBS(ModulusLength, 5, 1, 2)  'Moduluslength, PrimeTests, hn, Seed

    KILL $BBSFile
    ChunkLen = 1000  'Bytes are calculated and saved in chunks
    FOR i = 1 TO RandomBytesK
        CALL hi_GenerateBBSRandomBits(ChunkLen, MulBits, 2, 1, 3, 2) 'lBytes, MultipleBits?, StartSeed, hn, Result, EndSeed
        h = hi_GetReg(3)

        IF LEN(h) <> ChunkLen THEN PrintData "Length of h <> ChunkLen!!"
        OPEN $BBSFile FOR BINARY AS #1
        PUT #1, LOF(1)+1, h  'data will be appended to file
        CLOSE #1
    NEXT i
    PrintData "Data was generated..."
    PrintData "---------------------------"
END SUB



'--------------------------------------------------------------------------------
'Generate a file with random data using the RSA algorithm
SUB CreateRSAfile
    LOCAL i AS LONG
    LOCAL h AS STRING
    LOCAL RSAFile          AS STRING
    LOCAL ChunkLen         AS LONG
    LOCAL RSAModulusLength AS LONG
    LOCAL RSARandomBytesK  AS LONG

        'Input some parameters
    h = INPUTBOX$("Enter bitlength of RSA modulus:", "HIME", "128")
    RSAModulusLength  = VAL(h)
    PrintData "RSA modulus bitlenght: " & STR$(RSAModulusLength)

    h = INPUTBOX$("How many kbytes to generate:", "HIME", "10000")
    RSARandomBytesK = VAL(h)
        
    PrintData "Generating file with random data, RSA algorithm:"
    PrintData CURDIR$ + "\" + $RSAFile
            
        'Generate the RSA keys:
    CALL hi_GenerateRSAKeys(RSAModulusLength, 5, 1, 2, 3) 'lBitlength, lPrimeTests, he, hd, hn

        'Generate the seed (must be smaller than modulus):
    DO
        CALL hi_GenerateRandom(RSAModulusLength - 8, 4)
    LOOP UNTIL hi_IsLess(4, 3)

    KILL $RSAFile
    ChunkLen = 1000  'Bytes are calculated and saved in chunks
    FOR i = 1 TO RSARandomBytesK
        CALL hi_GenerateRSARandomBits(ChunkLen, 4, 1, 3, 5, 4)   'lBytes, Newseed, he, hn, Result, OldSeed
        h = hi_GetReg(5)

        IF LEN(h) <> ChunkLen THEN PrintData "Length of h <> ChunkLen!!"
        OPEN $RSAFile FOR BINARY AS #1
        PUT #1, LOF(1)+1, h  'data will be appended to file
        CLOSE #1
    NEXT i
    PrintData "Data was generated..."
    PrintData "---------------------------"
END SUB



'--------------------------------------------------------------------------------
'   ** CallBacks **
'--------------------------------------------------------------------------------
CALLBACK FUNCTION ShowDIALOG1Proc()

    SELECT CASE CBMSG
        CASE %WM_COMMAND
            SELECT CASE CBCTL
                CASE %IDC_LABEL1
                CASE %IDC_TestBatButt
                    IF CBCTLMSG = %BN_CLICKED OR CBCTLMSG = 1 THEN
                        BatteryOfTests
                    END IF
                CASE %IDC_LABEL2
                CASE %IDC_BBSalgo
                    IF CBCTLMSG = %BN_CLICKED OR CBCTLMSG = 1 THEN
                        CreateBBSfile
                    END IF
                CASE %IDC_RSAalgo
                    IF CBCTLMSG = %BN_CLICKED OR CBCTLMSG = 1 THEN
                        CreateRSAfile
                    END IF
            END SELECT
    END SELECT

END FUNCTION


'--------------------------------------------------------------------------------
'   ** Dialogs **
'--------------------------------------------------------------------------------
FUNCTION ShowDIALOG1(BYVAL hParent AS DWORD) AS LONG
    LOCAL lRslt AS LONG
    LOCAL Mess  AS STRING
    
#PBFORMS BEGIN DIALOG %IDD_DIALOG1->->
    LOCAL hDlg AS DWORD


    DIALOG NEW hParent, $Programname, 151, 114, 282, 189, %WS_POPUP OR _
        %WS_BORDER OR %WS_DLGFRAME OR %WS_CAPTION OR %WS_SYSMENU OR _
        %WS_MINIMIZEBOX OR %WS_MAXIMIZEBOX OR %WS_CLIPSIBLINGS OR %WS_VISIBLE _
        OR %DS_MODALFRAME OR %DS_3DLOOK OR %DS_NOFAILCREATE OR %DS_SETFONT, _
        %WS_EX_WINDOWEDGE OR %WS_EX_CONTROLPARENT OR %WS_EX_LEFT OR _
        %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR, TO hDlg
    CONTROL ADD LABEL, hDlg, %IDC_LABEL1, "Run battery of tests to check proper " + _
        "functioning of HIME.dll", 6, 4, 270, 16, %WS_CHILD OR %WS_VISIBLE OR _
        %SS_CENTER OR %SS_CENTERIMAGE, %WS_EX_CLIENTEDGE OR %WS_EX_LEFT OR _
        %WS_EX_LTRREADING
    CONTROL ADD BUTTON, hDlg, %IDC_TestBatButt, "Run battery of tests", 76, 22, _
        132, 16
    CONTROL ADD LABEL, hDlg, %IDC_LABEL2, "Create file with random data", 6, 42, _
        270, 16, %WS_CHILD OR %WS_VISIBLE OR %SS_CENTER OR %SS_CENTERIMAGE, _
        %WS_EX_CLIENTEDGE OR %WS_EX_LEFT OR %WS_EX_LTRREADING
    CONTROL ADD BUTTON, hDlg, %IDC_BBSalgo, "Blum-Blum-Shub algorithm", 6, 60, _
        134, 16
    CONTROL ADD BUTTON, hDlg, %IDC_RSAalgo, "RSA algorithm", 142, 60, 134, 16
    CONTROL ADD TEXTBOX, hDlg, %IDC_TEXTBOX1, "", 6, 80, 270, 102, %WS_CHILD OR _
        %WS_VISIBLE OR %WS_TABSTOP OR %WS_HSCROLL OR %WS_VSCROLL OR %ES_LEFT OR _
        %ES_MULTILINE OR %ES_AUTOHSCROLL, %WS_EX_CLIENTEDGE OR %WS_EX_LEFT OR _
        %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR

#PBFORMS END DIALOG
    hMain = hDlg
    PrintData "Testprogram for HIME.dll"
    PrintData "Huge Integer Math and Encryption library"
    PrintData "----------------------------------------"


            'Show version of HIME.dll
    lRslt = hi_Version        
    PrintData "Version of loaded HIME.dll: " + FORMAT$(lRslt / 100, "###.00")
    IF lRslt < %TestBenchVersion THEN
        Mess = "Loaded HIME.dll is an older version!" + $CRLF
        Mess = Mess + "It must be atleast version V" + FORMAT$(%TestBenchVersion / 100, "###.00")
        MSGBOX Mess,,$ProgramName
    END IF
    DIALOG SHOW MODAL hDlg, CALL ShowDIALOG1Proc TO lRslt

    FUNCTION = lRslt
END FUNCTION






'--------------------------------------------------------------------------------
FUNCTION PBMAIN()
    LOCAL hModRE AS DWORD

    RANDOMIZE TIMER
    
    CALL hi_PutReg("12345678-12345678", 1)  '<<-- invalid registration key
    hi_Register(1)
            
    ShowDIALOG1 %HWND_DESKTOP

    FREELIBRARY hModRE
END FUNCTION
'--------------------------------------------------------------------------------


