/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 61                        
                                                                            
 This program demonstrates use of the sprite library to create a simple     
 SPACE INVADERS game. Mouse movement is used to control the user's ship,    
 and the aliens will follow a predetermined pattern. Alien fire will not    
 damage your ship. This game is incomplete.                                 
                                                                            
  PROJECT                                                             
 This program requires the WGT4.LIB and WSPR.LIB files to be linked.        
                                                                            
  DATA FILES                                                          
 INVADE.PAK, INVADER.SPR                                                    
                                                                            
ͼ
*/

#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <ctype.h>
#include <wgt4.h>
#include <wgtspr.h>

block title;

color palette[256];
block sprites[101];
int x,y,i,ops;
char k;
char ch;
int shoot;
int alshoot[18],totshoot;


// sprites numbers (So you don't get confused)
// 1    = spaceship
// 2    = missile fired
// 3-24 = aliens!
// 25-39= aliens missiles

void looper(void);



void main(void)
{
  printf ("WordUp Graphics Toolkit Example Program\n\n");
  printf ("This program is meant to show off what the\n");
  printf ("WGT Library can do, and is not meant as a\n");
  printf ("complete shareware or public domain game.\n");
  printf ("Press q during the game to quit...\n\n\n");


  i = minit();
  if (i == 0)
  { 
    printf ("Mouse not detected.  You need a mouse for this example program\n");
    exit (1);
  }
  else printf ("Mouse with %i buttons detected.\n", i);
  printf ("Press any key\n");
  getch ();

  vga256 ();
  title = wloadpak ("invade.pak");
  wloadsprites (palette, "invader.spr", sprites, 0, 100);
  wsetpalette (0, 255, palette);

  do {
  wclip (0, 0, 319, 199);
  initspr ();
  spon = 39;				// thirty nine sprites on now
  spclip = 1;

  wsetscreen (spritescreen);

  wputblock (0, 0, title, 0);
  wsetcolor (0);
  wbar(0, 0, 319, 140);
  wcopyscreen(0, 0, 319, 199, spritescreen, 0, 0, NULL);

  spriteon(1, 160, 148, 1);

  for (y = 0; y < 3; y++)
    for (x = 1; x < 8; x++)
    {
      spriteon((y * 7) + x + 2, x * 20 + 10, 20 + y * 30, 3);	// turn alien on
      animate((y * 7) + x + 2, "(3,3)(4,3)(5,3)(4,3)R");	// animate it
      animon((y * 7) + x + 2);                                        
      movex((y * 7) + x + 2, "(1,150,0)(0,30,0)(-1,150,0)(0,30,0)R");	// set up x movement
      movey((y * 7) + x + 2, "(0,150,0)(1,30,0)(0,150,0)(-1,30,0)R");	// set up y movement
      movexon((y * 7) + x + 2);
      moveyon((y * 7) + x + 2);
    }
    msetbounds(0, 148, 319, 148);
    mx = 160;
    my = 148;

    do {				/* Play game until keypress */
      looper ();
    } while (!kbhit ());
    ch = getch ();
    msetbounds (0, 0, 319, 199);
  
    deinitspr ();			/* Deinit the sprite system */
    for (x = 0; x < 15; x++)		/* Clear shot array */
      alshoot[x] = 0;
  } while (toupper (ch) != 'Q');	/* Restart game if not Q */

  wsetmode (3);
}



void looper(void)
{
  int checkspr;

  wretrace ();				/* Time updates to vertical retrace */
  erasespr ();

  s[1].x = mx;				/* Set player position */
  s[1].y = my;

  if (but == 1)				// if you pressed the left button
  {
    if (shoot == 0)			// not shooting then
    {
      sound (600);
      spriteon (2, s[1].x + 3, s[1].y, 2);    // turn on the missile sprite
      movey (2, "(-2,200,0)");  	// make it move up
      moveyon (2);			// turn the movement on
      shoot = 1;
    }
  }

  for (y = 0; y < 3; y++)		// loop through all aliens
    for (x = 1; x < 8; x++)
    {
      checkspr = (y * 7) + x + 2;
      if (s[checkspr].on != 0)		// if you haven't hit it yet
      {
	/* Cannot shoot more than 14 at once since we can only have 40 sprites */
	if ((rand () % 50 == 5) & (totshoot < 13))	/* 1 in 50 chance of shooting */
	{	
	  ops = 100;
	  i = 1;
	  do {
	    if (alshoot[i] == 0)		// find an open slot for missile
	      ops = i;
	    i++;
	  } while (i < 15);
	  if (ops != 100)
	  {
	    alshoot[ops] = 1;
	    totshoot++;
	    spriteon (ops + 24, s[checkspr].x + 4, s[checkspr].y, 2); // turn shot on
	    movey (ops + 24, "(1,160,0)");			// move it down
	    moveyon(ops + 24);
	  }
	}

	if (overlap (2, checkspr) == 1)		// and your missile is hitting it
	{
	  sound (200);
	  spriteoff (2);			// turn off the missile
	  shoot = 0;				// not shooting anymore
	  animate(checkspr, "(6,5)(7,5)(8,5)(9,5)(10,5)");  // show explosion
	  animon(checkspr);				// reset animation
	}
	if (s[checkspr].num == 10)		// if finished animating,
	  spriteoff(checkspr);			// turn off the sprite
      }
    }
  
  for (y = 1; y < 15; y++)		/* Disable missles when they hit ground */
  {
    if (s[y + 24].y > 154)
    {
      alshoot[y] = 0;
      spriteoff(y + 24);
      totshoot--;
    }
  }
  if (s[2].y < -10)			/* User missle off screen? */
    shoot = 0;

  drawspr();				/* Draw the sprites again */
  nosound();				/* Stop all sounds */
}

