/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 43                        
                                                                            
 Demonstrates the use of the WGT EMS routines. Random screens are created   
 and stored in EMS, then displayed until a key is pressed. After this, a    
 sprite file is loaded and the sprites are stored in EMS. The sprites are   
 randomly pasted onto the screen until a key is pressed once more.          
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 PACSPR.SPR                                                                 
                                                                            
ͼ
*/

#include <stdlib.h>
#include <conio.h>
#include <wgt4.h>

int oldmode;
int useEMS;
int screen;
int i;
int item, x1, x2, y1, y2;
block screens[8];

block emsscreen;
block emsblock;
block sprites[100];
color pal[256];

void main(void)
{
oldmode=wgetmode();

vga256();

useEMS=wems_present();

wtextcolor(15);

wgtprintf(0,0,NULL,"EMS present: %i",useEMS);

if (!useEMS)
  exit(1);

 wgtprintf(0,8,NULL,"EMS init: %i",wems_init());
 wgtprintf(0,16,NULL,"EMS page frame: %p",emsptr);
 wgtprintf(0,24,NULL,"EMS open: %i",wems_open(512/16));
 wgtprintf(0,32,NULL,"EMS handle: %Np",emshandle);
 wgtprintf(0,40,NULL,"Press any key to continue");
 getch();

wcls(0);

for (screen = 0; screen < 8; screen++)
 {
 wcls(0);
 for (i = 0; i < 100; i++)
  {
   item = random(5);
   x1 = random(320);
   x2 = random(320);
   y1 = random(200);
   y2 = random(200);

   wsetcolor(random(256));
   switch (item)
    {
    case 0: wbar(x1,y1,x2,y2); break;
    case 1: wline(x1,y1,x2,y2); break;
    case 2: wrectangle(x1,y1,x2,y2); break;
    case 3: wfill_circle(x1,y1,x2/10); break;
    case 4: wfill_ellipse(x1,y1,x2/10, y2/10); break;
    }
  }
 wgtprintf(0,0,NULL,"SCREEN %i",screen);
 screens[screen] = wnewblock(0,0,319,199);
 screens[screen] = wems_storeblock(screens[screen]);
 }

screen = 0;
while (!kbhit())
 {
  emsscreen = wems_getdata(screens[screen]);
  wputblock(0,0,emsscreen,0);
  screen++;
  if (screen > 7) 
    screen = 0;
 }
getch();

wems_reset();

wnormscreen();
wems_loadsprites(pal, "pacspr.spr", sprites,0,99);
wsetpalette(0,255,pal);

do 
 {
 i++;
 if (i > 99) 
   i = 0;
 if (sprites[i] != NULL)
   {
   emsblock = wems_getdata(sprites[i]);
   wputblock(random(320),random(200),emsblock, 0);
   }
 } while (!kbhit());
wems_close();
}