/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 31                        
                                                                            
 Show how to use WGT library files - simple example with wloadsprites.      
 Also demonstrates how to use lib2buf to extract any type of file.          
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 You must have the DEMO31.WGT library file in your executable directory .   
                                                                            
ͼ
*/

#include <wgt4.h>
#include <conio.h>
#include <stdlib.h>


void main(void)
{
  block sprites[2];		/* Pointers to sprites */
  color pal[256];		/* Our palette */
  int oldmode;			/* Store previous video mode */
  char *buf;                    /* Pointer to a buffer for extra data */

  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }

  oldmode = wgetmode();		/* Gets the current mode */
  vga256();			/* Initialize graphics mode */
  setlib("demo31.wgt");		/* Tell WGT what library file to use */
  setpassword("WGT");		/* This is the required password for DEMO31.WGT */

  /* Loads a sprite file from within DEMO31.WGT */
  wloadsprites(pal,"demo31.spr",sprites,0,1);
  wsetpalette(0,255,pal);

  wcls(0);			/* Clear screen with black */
  do				/* Randomly place block on screen */
  {
    wputblock(rand() % 300,rand() % 180,sprites[1],0);
  } while (!kbhit());		/* Abort when key is pressed */
  getch();
  wfreesprites(sprites,0,1);
  wsetmode(oldmode);		/* Restore initial video mode */

  buf = lib2buf ("demo31.txt"); /* Load a text file from the library file */
  printf ("%s\n", buf);         /* Now display the file */
  farfree (buf);                /* Deallocate the buffer */

  printf ("Press any key to exit.\n");
  while (!kbhit ());
  getch();
}
