/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 16                        
                                                                            
This program shows how to use wcopyscreen.                                  
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <wgt4.h>

int x,y;
int oldmode;
block screen1;


void main(void)
{
  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }
  oldmode = wgetmode();
  vga256();

  screen1 = wnewblock(0,0,319,199);

  wsetscreen(screen1);		/* sets to screen1 */
  for (y = 0; y < 200; y++)
  {
    wsetcolor(y);
    wfline(0,0,319,y);		/* draw something on another screen */
    wfline(319,199,0,y);
  }

  minit();
  moff();
  wnormscreen();		/* make the putblock go onto the default screen */

  do {
    wcopyscreen(mx,my,mx+20,my+20,screen1,mx,my,NULL);
    /* this means copy a square 20*20 from screen1 to the same spot
       on the default screen.  Move the mouse around and watch the black
       wipe away as screen1 copies over. */

    /* NULL means the default screen. */
  } while (!kbhit());
  mdeinit ();                   /* Deinitialize the mouse handler */

  getch();		/* wasn't that fun! */

  wfreeblock(screen1);
  wsetmode(oldmode);
}