/**********************************************************************
* sprtest.c
* 
* A simple STK test program.
* 
* Compile with the command line "tcc sprtest.c stks.lib graphics.lib"
* or use the integrated environment with the project file SPRTEST.PRJ.
*
**********************************************************************
                    This file is part of

          STK -- The sprite toolkit -- version 1.1

              Copyright (C) Jari Karjala 1991

The sprite toolkit (STK) is a FreeWare toolkit for creating high
resolution sprite graphics with PCompatible hardware. This toolkit 
is provided as is without any warranty or such thing. See the file
COPYING for further information. 

**********************************************************************/

#include <stdio.h>          /*** puts() ***/
#include "stk.h"            /*** The Sprite Toolkit prototypes ***/
#include "sprtest.smp"      /*** The sprite map to use **/

int main(int argc, char **argv)
{
    int i,j,k;
    ANIM_SPRITE as1, as2;

    /**** Detect a suitable graphics mode, start it and init spr module ****/
    gr_detect(GR_TYPE_SPR, &i, &j);
    if (i == -1) {
        puts("Unsupported graphics mode, need EGA or Hercules!");
        return 1;
    }
    gr_text_mode = GR_MODE_CLEAR_FAST;
    gr_start(&i, &j);
    spr_initialize(i);

    /**** Create two animated sprites ****/
    as1 = spr_anim_create(1, spr_create(sprtest_width, sprtest_height, 
                                        sprtest_shape, sprtest_mask, 
                                        8, 0));

    as2 = spr_anim_create(1, spr_create(sprtest_width, sprtest_height, 
                                        sprtest_shape, sprtest_mask, 
                                        8, 0));
    if (as1==NULL || as2==NULL) {
        gr_puts("Cannot create sprites.\nPress enter to exit");
        while (gr_inkey()!=13)
            ;
        return 2;
    }

    /**** Set sprite 1 properties *****/
    spr_anim_set_time(as1, 0, 6, 5000);  /** Timeout after 5000 steps **/
    spr_anim_set_location(as1, 20,15);      /** Initial position **/
    spr_anim_set_limits(as1, 0,0, 400, gr_max_y);     /** Limits **/
    spr_anim_set_vector(as1, 2,1);          /** Direction vector **/
    spr_anim_start(as1);                    /** Activate the sprite **/
    /**** Set sprite 2 properties *****/
    spr_anim_set_time(as2, 0, 6, 5000); /** Timeout after 5000 steps **/
    spr_anim_set_location(as2, 20,300);     /** Initial position **/
    spr_anim_set_vector(as2, -2,2);         /** Direction vector **/
    spr_anim_start(as2);                    /** Activate the sprite **/

    gr_dual_xy_printf(60,60,"***** HERE IS SOME BACKGROUND TEXTURE *****");
    gr_dual_xy_printf(200,200,"***** HERE IS SOME BACKGROUND TEXTURE *****");
    gr_dual_xy_printf(130,130,"Press Esc to exit");    
    
    k = 0;
    do {    /**** Loop until the user presses the Esc key ****/
        gr_xy_printf(0,0,"Pass %d ",k);
        gr_setactivepage(spr_anim_next_pass()^1);
        spr_regulate_speed();
        i = gr_inkey();
        k++;
    } while (i!=27);

    /**** No real need to use gr_end since it is bound with atexit() ****/
    gr_end();
    
    return 0;
}
