{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+}
{
	Mouse funktions.
	(C) 1994 By Kimmo Fredriksson.
}
UNIT	Mouse;

	INTERFACE

PROCEDURE Show;
PROCEDURE Hide;
PROCEDURE SetPos( X, Y : Integer );
PROCEDURE SetRange( x1, y1, x2, y2 : Integer );
FUNCTION  X : Integer;
FUNCTION  Y : Integer;
FUNCTION  LeftButton  : Boolean;
FUNCTION  RightButton : Boolean;
FUNCTION  ChkAndReset : Boolean;

	IMPLEMENTATION

{ Show mouse cursor }

PROCEDURE Show; ASSEMBLER;
ASM
	MOV	AX,1
	INT	33h
END;

{ Hide mouse cursor }

PROCEDURE Hide; ASSEMBLER;
ASM
	MOV	AX,2
	INT	33h
END;

{ Mouse X coordinate }

FUNCTION X : Integer; ASSEMBLER;
ASM
	MOV	AX,3
	INT	33h
	MOV	AX,CX
END;

{ Mouse Y coordinate }

FUNCTION Y : Integer; ASSEMBLER;
ASM
	MOV	AX,3
	INT	33h
	MOV	AX,DX
END;

{ Left button pressed ? }

FUNCTION LeftButton : Boolean; ASSEMBLER;
ASM
	MOV	AX,3;
	INT	33h
	MOV	AL,BL
	AND	AL,01h
END;

{ Right button pressed ? }

FUNCTION RightButton : Boolean; ASSEMBLER;
ASM
	MOV	AX,3;
	INT	33h
	MOV	AL,BL
	SHR	AL,1
	AND	AL,01h
END;

{ Moves cursor to X,Y }

PROCEDURE SetPos( X, Y : Integer ); ASSEMBLER;
ASM
	MOV	AX,4
	MOV	CX,[X]
	MOV	DX,[Y]
	INT	33h
END;

{ Defines range of cursor location }

PROCEDURE SetRange( x1, y1, x2, y2 : Integer ); ASSEMBLER;
ASM
	MOV	AX,7
	MOV	CX,[x1]
	MOV	DX,[x2]
	INT	33h
	MOV	AX,8
	MOV	CX,[y1]
	MOV	DX,[y2]
	INT	33h
END;

{ Check, if mouse installed, and reset mouse }

FUNCTION ChkAndReset : Boolean; ASSEMBLER;
ASM
	MOV	AX,0
	INT	33h
	TEST	AX,AX
	JZ	@Err
	MOV	AX,1
	INT	33h
	MOV	AX,1
	RET
@Err:   XOR	AX,AX
END;

END.

