package james.dean.mines;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager;
import android.view.inputmethod.*;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;



public class MinesActivity extends Activity implements OnClickListener
  {
    private class Room
      {
        String     strDescription;
        int        nChokepoint;
        boolean    bMined;
        boolean    bVisited;
        Passage [] passage = new Passage [6];

        public Room()
          {
            strDescription=null;
            nChokepoint=-1;
            bMined=false;
            bVisited=false;
            passage[0]=null;
            passage[1]=null;
            passage[2]=null;
            passage[3]=null;
            passage[4]=null;
            passage[5]=null;
          }
      }

    private class Treasure
      {
        String  strTreasure;
        Room    roomTreasure;
        String  strGuardian;
        boolean bSlain;
        String  strWeapon;
        Room    roomWeapon;

        public Treasure(
         String strTreasure,
         String strGuardian,
         String strWeapon)
          {
            this.strTreasure=strTreasure;
            this.strGuardian=strGuardian;
            this.strWeapon=strWeapon;
            roomTreasure=null;
            bSlain=false;
            roomWeapon=null;
          }
      }

    private class Passage
      {
        boolean  bBlocked;
        Treasure treasureGuardian;
        Room     room1;
        Room     room2;

        public Passage()
          {
            bBlocked=true;
            treasureGuardian=null;
            room1=null;
            room2=null;
          }
      }

    private class PathStack
      {
        Room      room;
        int       nDirectionUsedToEnterRoom;
        PathStack pathStackNext;

        public PathStack()
          {
            room=null;
            nDirectionUsedToEnterRoom=0;
            pathStackNext=null;
          }
      }

    private class FindPathLocalsStack
      {
        boolean             bRoomAlreadyInStack;
        int                 nDirection1;
        int                 nDirection2;
        int                 nDirection3;
        int []              nDirectionRandom=new int [6];
        PathStack           pathStack;
        FindPathLocalsStack findPathLocalsStackNext;

        public FindPathLocalsStack()
          {
            bRoomAlreadyInStack=false;
            nDirection1=0;
            nDirection2=0;
            nDirectionRandom[0]=0;
            nDirectionRandom[1]=0;
            nDirectionRandom[2]=0;
            nDirectionRandom[3]=0;
            nDirectionRandom[4]=0;
            nDirectionRandom[5]=0;
            nDirection3=0;
            pathStack=null;
            findPathLocalsStackNext=null;
          }
      }

    private class FindPathParametersStack
      {
        Room                    room;
        int                     nDirectionUsedToEnterRoom;
        int                     nReturnAddress;
        FindPathParametersStack findPathParametersStackNext;

        public FindPathParametersStack()
          {
            room=null;
            nDirectionUsedToEnterRoom=0;
            nReturnAddress=0;
            findPathParametersStackNext=null;
          }
      }

    private boolean       m_bRestoringState;
    private Button        m_buttonAbout;
    private Button        m_buttonCarry;
    private Button        m_buttonDown;
    private Button        m_buttonDrop;
    private Button        m_buttonEast;
    private Button        m_buttonGo;
    private Button        m_buttonInventory;
    private Button        m_buttonQuit;
    private Button        m_buttonScore;
    private Button        m_buttonSouth;
    private Button        m_buttonNorth;
    private Button        m_buttonUp;
    private Button        m_buttonWayOut;
    private Button        m_buttonWest;
    private EditText      m_editMineNumber;
    private int           m_nAddIndex;
    private int           m_nChokepoints;
    private int           m_nDirectionOpposite [] = {1,0,3,2,5,4};
    private int           m_nMoves;
    private int           m_nReplaceIndex;
    private int           m_nRN [] = {1,2,3,4,5,6,7,8};
    private int           m_nRNPartialSum;
    private int           m_nRooms;
    private int           m_nTreasures;
    private Room          m_room;
    private Room          m_roomEntrance;
    private Room []       m_roomWithName;
    private StringBuilder m_sbCommands;
    private String        m_strABeginner;
    private String        m_strAbout;
    private String        m_strAGrizzlyOldProspector;
    private String        m_strAnd;
    private String        m_strAnExpertTreasureHunter;
    private String        m_strANoviceAdventurer;
    private String        m_strAreHere;
    private String        m_strASeasonedExplorer;
    private String        m_strAsHeLeavesHeShoutsTheLetter;
    private String        m_strAsHeLeavesHeShoutsTheLetters;
    private String        m_strComma;
    private String        m_strDirection [];
    private String        m_strEntranceToTheMine;
    private String        m_strGuardian [];
    private String        m_strIsGuardedBy;
    private String        m_strIsHere;
    private String        m_strLocations;
    private String        m_strLowerSingle;
    private String        m_strLowerSingleBeforeVowel;
    private String        m_strMineNumber;
    private String        m_strNothingHappens;
    private String        m_strOf100Points;
    private String        m_strOf;
    private String        m_strOvercomesThe;
    private String        m_strPeriod;
    private String        m_strQuote;
    private String        m_strRoom [];
    private String        m_strSpace = " ";
    private String        m_strDirectionLetters;
    private String        m_strThePassage;
    private String        m_strThePirateTakesOneOfYourTreasures;
    private String        m_strTimesToVisit;
    private String        m_strTreasure [];
    private String        m_strTreasures;
    private String        m_strTreasuresToTheEntranceOfTheMine;
    private String        m_strUpperSingle;
    private String        m_strUpperSingleBeforeVowel;
    private String        m_strVowels;
    private String        m_strWayOut;
    private String []     m_strWeapon;
    private String        m_strYouAreCarrying;
    private String        m_strYouAreIn;
    private String        m_strYouAreNotCarryingAnything;
    private String        m_strYouCannotGoThatWay;
    private String        m_strYouCarryNothingToOvercomeThe;
    private String        m_strYouHaveMoved;
    private String        m_strYouHaveReturned;
    private String        m_strYouHaveScored;
    private String        m_strYouHold;
    private String        m_strYour;
    private String        m_strYourScoreRanksYouAs;
    private TextView      m_textLocation;
    private TextView      m_textMineNumber;
    private TextView      m_textObjective;
    private Treasure []   m_treasure;



    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState)
      {
        int    nCommand;
        int    nCommands;
        String strCommands;

        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        m_buttonGo=(Button) findViewById(R.id.buttonGo);
        m_buttonGo.setOnClickListener(this);
        m_buttonDown=(Button) findViewById(R.id.buttonDown);
        m_buttonDown.setOnClickListener(this);
        m_buttonSouth=(Button) findViewById(R.id.buttonSouth);
        m_buttonSouth.setOnClickListener(this);
        m_buttonNorth=(Button) findViewById(R.id.buttonNorth);
        m_buttonNorth.setOnClickListener(this);
        m_buttonUp=(Button) findViewById(R.id.buttonUp);
        m_buttonUp.setOnClickListener(this);
        m_buttonEast=(Button) findViewById(R.id.buttonEast);
        m_buttonEast.setOnClickListener(this);
        m_buttonWest=(Button) findViewById(R.id.buttonWest);
        m_buttonWest.setOnClickListener(this);
        m_buttonScore=(Button) findViewById(R.id.buttonScore);
        m_buttonScore.setOnClickListener(this);
        m_buttonAbout=(Button) findViewById(R.id.buttonAbout);
        m_buttonAbout.setOnClickListener(this);
        m_buttonInventory=(Button) findViewById(R.id.buttonInventory);
        m_buttonInventory.setOnClickListener(this);
        m_buttonDrop=(Button) findViewById(R.id.buttonDrop);
        m_buttonDrop.setOnClickListener(this);
        m_buttonCarry=(Button) findViewById(R.id.buttonCarry);
        m_buttonCarry.setOnClickListener(this);
        m_buttonAbout=(Button) findViewById(R.id.buttonAbout);
        m_buttonAbout.setOnClickListener(this);
        m_buttonQuit=(Button) findViewById(R.id.buttonQuit);
        m_buttonQuit.setOnClickListener(this);
        m_buttonWayOut=(Button) findViewById(R.id.buttonWayOut);
        m_buttonWayOut.setOnClickListener(this);
        m_editMineNumber=(EditText) findViewById(R.id.editMineNumber);
        m_editMineNumber.setVisibility(View.VISIBLE);
        m_textLocation=(TextView) findViewById(R.id.textLocation);
        m_textMineNumber=(TextView) findViewById(R.id.textMineNumber);
        m_textObjective=(TextView) findViewById(R.id.textObjective);
        m_strRoom=getResources().getStringArray(R.array.arrayRoom);
        m_nRooms=m_strRoom.length;
        m_strTreasure=getResources().getStringArray(R.array.arrayTreasure);
        m_nTreasures=m_strTreasure.length;
        m_strWeapon=getResources().getStringArray(R.array.arrayWeapon);
        m_strGuardian=getResources().getStringArray(R.array.arrayGuardian);
        m_strDirection=getResources().getStringArray(R.array.arrayDirection);
        m_strABeginner=getResources().getString(R.string.stringABeginner);
        m_strAbout=getResources().getString(R.string.stringAbout);
        m_strAGrizzlyOldProspector=getResources().getString(R.string.stringAGrizzlyOldProspector);
        m_strAnd=getResources().getString(R.string.stringAnd);
        m_strAnExpertTreasureHunter=getResources().getString(R.string.stringAnExpertTreasureHunter);
        m_strANoviceAdventurer=getResources().getString(R.string.stringANoviceAdventurer);
        m_strAreHere=getResources().getString(R.string.stringAreHere);
        m_strASeasonedExplorer=getResources().getString(R.string.stringASeasonedExplorer);
        m_strAsHeLeavesHeShoutsTheLetter=getResources().getString(R.string.stringAsHeLeavesHeShoutsTheLetter);
        m_strAsHeLeavesHeShoutsTheLetters=getResources().getString(R.string.stringAsHeLeavesHeShoutsTheLetters);
        m_strComma=getResources().getString(R.string.stringComma);
        m_strDirectionLetters=getResources().getString(R.string.stringDirectionLetters);
        m_strEntranceToTheMine=getResources().getString(R.string.stringEntranceToTheMine);
        m_strIsGuardedBy=getResources().getString(R.string.stringIsGuardedBy);
        m_strIsHere=getResources().getString(R.string.stringIsHere);
        m_strLocations=getResources().getString(R.string.stringLocations);
        m_strLowerSingle=getResources().getString(R.string.stringLowerSingle);
        m_strLowerSingleBeforeVowel=getResources().getString(R.string.stringLowerSingleBeforeVowel);
        m_strNothingHappens=getResources().getString(R.string.stringNothingHappens);
        m_strOf100Points=getResources().getString(R.string.stringOf100Points);
        m_strOf=getResources().getString(R.string.stringOf);
        m_strOvercomesThe=getResources().getString(R.string.stringOvercomesThe);
        m_strPeriod=getResources().getString(R.string.stringPeriod);
        m_strQuote=getResources().getString(R.string.stringQuote);
        m_strThePassage=getResources().getString(R.string.stringThePassage);
        m_strThePirateTakesOneOfYourTreasures=getResources().getString(R.string.stringThePirateTakesOneOfYourTreasures);
        m_strTimesToVisit=getResources().getString(R.string.stringTimesToVisit);
        m_strTreasures=getResources().getString(R.string.stringTreasures);
        m_strTreasuresToTheEntranceOfTheMine=getResources().getString(R.string.stringTreasuresToTheEntranceOfTheMine);
        m_strUpperSingle=getResources().getString(R.string.stringUpperSingle);
        m_strUpperSingleBeforeVowel=getResources().getString(R.string.stringUpperSingleBeforeVowel);
        m_strVowels=getResources().getString(R.string.stringVowels);
        m_strYouAreCarrying=getResources().getString(R.string.stringYouAreCarrying);
        m_strYouAreIn=getResources().getString(R.string.stringYouAreIn);
        m_strYouAreNotCarryingAnything=getResources().getString(R.string.stringYouAreNotCarryingAnything);
        m_strYouCannotGoThatWay=getResources().getString(R.string.stringYouCannotGoThatWay);
        m_strYouCarryNothingToOvercomeThe=getResources().getString(R.string.stringYouCarryNothingToOvercomeThe);
        m_strYouHaveMoved=getResources().getString(R.string.stringYouHaveMoved);
        m_strYouHaveReturned=getResources().getString(R.string.stringYouHaveReturned);
        m_strYouHaveScored=getResources().getString(R.string.stringYouHaveScored);
        m_strYouHold=getResources().getString(R.string.stringYouHold);
        m_strYour=getResources().getString(R.string.stringYour);
        m_strYourScoreRanksYouAs=getResources().getString(R.string.stringYourScoreRanksYouAs);
        m_nDirectionOpposite[0]=1;
        m_nDirectionOpposite[1]=0;
        m_nDirectionOpposite[2]=3;
        m_nDirectionOpposite[3]=2;
        m_nDirectionOpposite[4]=5;
        m_nDirectionOpposite[5]=4;
        if (savedInstanceState == null)
          {
            m_bRestoringState=false;
            m_sbCommands=new StringBuilder("");
            m_strMineNumber="";
            m_buttonGo.setVisibility(View.VISIBLE);
            m_buttonDown.setVisibility(View.INVISIBLE);
            m_buttonSouth.setVisibility(View.INVISIBLE);
            m_buttonNorth.setVisibility(View.INVISIBLE);
            m_buttonUp.setVisibility(View.INVISIBLE);
            m_buttonEast.setVisibility(View.INVISIBLE);
            m_buttonWest.setVisibility(View.INVISIBLE);
            m_buttonScore.setVisibility(View.INVISIBLE);
            m_buttonAbout.setVisibility(View.INVISIBLE);
            m_buttonInventory.setVisibility(View.INVISIBLE);
            m_buttonDrop.setVisibility(View.INVISIBLE);
            m_buttonCarry.setVisibility(View.INVISIBLE);
            m_buttonAbout.setVisibility(View.INVISIBLE);
            m_buttonQuit.setVisibility(View.INVISIBLE);
            m_buttonWayOut.setVisibility(View.INVISIBLE);
            m_textLocation.setVisibility(View.INVISIBLE);
            m_textMineNumber.setVisibility(View.VISIBLE);
            m_textObjective.setVisibility(View.VISIBLE);
            m_editMineNumber.requestFocus();
          }
        else
          {
            m_sbCommands=new StringBuilder(savedInstanceState.getString("m_sbCommands"));
            nCommands=m_sbCommands.length();
            if (nCommands == 0)
              {
                m_bRestoringState=false;
                m_sbCommands=new StringBuilder("");
                m_strMineNumber="";
                m_buttonGo.setVisibility(View.VISIBLE);
                m_buttonDown.setVisibility(View.INVISIBLE);
                m_buttonSouth.setVisibility(View.INVISIBLE);
                m_buttonNorth.setVisibility(View.INVISIBLE);
                m_buttonUp.setVisibility(View.INVISIBLE);
                m_buttonEast.setVisibility(View.INVISIBLE);
                m_buttonWest.setVisibility(View.INVISIBLE);
                m_buttonScore.setVisibility(View.INVISIBLE);
                m_buttonAbout.setVisibility(View.INVISIBLE);
                m_buttonInventory.setVisibility(View.INVISIBLE);
                m_buttonDrop.setVisibility(View.INVISIBLE);
                m_buttonCarry.setVisibility(View.INVISIBLE);
                m_buttonAbout.setVisibility(View.INVISIBLE);
                m_buttonQuit.setVisibility(View.INVISIBLE);
                m_buttonWayOut.setVisibility(View.INVISIBLE);
                m_textLocation.setVisibility(View.INVISIBLE);
                m_textMineNumber.setVisibility(View.VISIBLE);
                m_textObjective.setVisibility(View.VISIBLE);
                m_editMineNumber.requestFocus();
              }
            else
              {
                this.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN); 
                strCommands=m_sbCommands.toString();
                m_sbCommands=new StringBuilder("");
                m_strMineNumber=savedInstanceState.getString("m_strMineNumber");
                m_bRestoringState=true;
                --nCommands;
                nCommand=0;
                while (nCommand < nCommands)
                  {
                    ProcessCommand(strCommands.charAt(nCommand));
                    ++nCommand;
                  }
                m_bRestoringState=false;
                ProcessCommand(strCommands.charAt(nCommand));
              }
          }
      }
    
    @Override
    public void onResume()
      {
        super.onResume();
        if (m_sbCommands.length() > 0)
          this.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);  
      }

    @Override
    public void onSaveInstanceState(
     Bundle bundle)
      {
        super.onSaveInstanceState(bundle);
        bundle.putString("m_sbCommands",m_sbCommands.toString());
        if (m_sbCommands.length() > 0)
          bundle.putString("m_strMineNumber",m_strMineNumber);
      }

    private int RandomNumber()
      {
        int nResult;
        /*
            Each pseudo-random number is the modulo sum of the
          previous eight pseudo-random numbers.  A prime modulus
          makes it likely that the pseudo-random numbers will be
          uniformly distributed.  To speed computation, a partial
          sum of 7 of the 8 previous pseudo-random numbers is maintained.
               For a given set of initial values m_nRN[i], i=0,1,2,...,7,
          this random number generator should produce the same sequence
          of random numbers, no matter what 32-bit compiler it is compiled
          under.
        */
        do
          {
            nResult=m_nRNPartialSum+m_nRN[m_nAddIndex];
            if (nResult >= 32771)
              nResult-=32771;
            m_nRNPartialSum=nResult-m_nRN[m_nReplaceIndex];
            if (m_nRNPartialSum < 0)
              m_nRNPartialSum+=32771;
            m_nRN[m_nReplaceIndex]=nResult;
            m_nAddIndex=m_nReplaceIndex;
            if (++m_nReplaceIndex >= 8)
              m_nReplaceIndex=0;
          }
        while (nResult > 32767);
        return nResult;
      }

    private void SeedRandomNumberGenerator(
     String strMine)
      {
        int  nKeyIndex;
        int  nKeyStart;
        int  nKeyLength;

        nKeyLength=strMine.length();
        nKeyIndex=0;
        for (nKeyStart=nKeyLength; nKeyStart < 8; ++nKeyStart)
          m_nRN[nKeyIndex++]=1+(int) '0';
        nKeyStart=0;
        for (nKeyStart=0; ((nKeyStart < 8) && (nKeyStart < nKeyLength));
         ++nKeyStart)
          m_nRN[nKeyIndex++]=1+(int) (strMine.charAt(nKeyStart));
        m_nRNPartialSum=0;
        for (nKeyIndex=7; nKeyIndex > 0; --nKeyIndex)
          {
            m_nRNPartialSum+=m_nRN[nKeyIndex];
            if (m_nRNPartialSum >= 32771)
              m_nRNPartialSum-=32771;
          }
        m_nReplaceIndex=1;
        m_nAddIndex=0;
        for (nKeyIndex=256; nKeyIndex-- > 0;)
          RandomNumber();
        return;
      }

    private void ShuffleRoomDescriptions()
      {
        int    nRoom1;
        int    nRoom2;
        String str;

        for (nRoom1=m_nRooms-1; nRoom1 > 0; --nRoom1)
          {
            nRoom2=RandomNumber()%nRoom1;
            str=m_strRoom[nRoom1];
            m_strRoom[nRoom1]=m_strRoom[nRoom2];
            m_strRoom[nRoom2]=str;
          }
        return;
      }

    private void ExcavateMine()
      {
        int     nChokepoint;
        int     nDirectionOpposite;
        int     nDirection1;
        int     nDirection2;
        int     nDistance;
        int     nHeight;
        int     nLen;
        int     nMax;
        int     nRoom;
        int     nStep;
        int     nTreasure;
        int     nUnblocked;
        int     nWidth;
        int     nX;
        int     nXFirstRoom;
        int     nY;
        int     nYFirstRoom;
        int     nZ;
        int     nZFirstRoom;
        Passage passage;
        Room    room;
        Room    roomDown;
        Room    roomNext;
        Room    roomSouth;
        Room    roomSouthBase;
        Room    roomWest;
        Room    roomWestBase;
        Room    roomWestBaseBase;

        nMax=(int) (10.0+Math.exp(Math.log((double) m_nRooms)/3.0));
        do
          {
            nLen=RandomNumber()%(nMax-3)+3;
            nWidth=RandomNumber()%(nMax-3)+3;
            nHeight=RandomNumber()%(nMax-3)+3;
          }
        while ((nLen*nWidth*nHeight < 2*(m_nRooms-1))
        ||     (nLen*nWidth*nHeight > 3*(m_nRooms-1)));
        nXFirstRoom=0;
        nYFirstRoom=RandomNumber()%nLen;
        nZFirstRoom=RandomNumber()%nHeight;
        roomWestBase=null;
        roomWestBaseBase=null;
        for (nX=0; nX < nWidth; ++nX)
          {
            roomSouthBase=null;
            for (nY=0; nY < nLen; ++nY)
              {
                roomWest=roomWestBase;
                roomSouth=roomSouthBase;
                roomDown=null;
                for (nZ=0; nZ < nHeight; ++nZ)
                  {
                    room=new Room();
/*
(X,Y,Z) gets linked to (X-1,Y,Z); (X,Y-1,Z); and (X,Y,Z-1)
                       roomWest   roomSouth      roomDown
*/
                    if (nZ == 0)
                      {
                        roomSouthBase=room;
                        if (nY == 0)
                          roomWestBaseBase=room;
                      }
                    if (roomDown != null)
                      {
                      /* link room to one below it */
                        passage=new Passage();
                        passage.room1=room;
                        passage.room2=roomDown;
                        room.passage[5]=passage;
                        roomDown.passage[4]=passage;
                      }
                    if (roomSouth != null)
                      {
                        /* link to room to the south */
                        passage=new Passage();
                        passage.room1=room;
                        passage.room2=roomSouth;
                        room.passage[1]=passage;
                        roomSouth.passage[0]=passage;
                        if (roomSouth.passage[4] != null)
                          if (roomSouth.passage[4].room1
                           == roomSouth)
                            roomSouth
                             =roomSouth.passage[4].room2;
                          else
                            roomSouth
                             =roomSouth.passage[4].room1;
                        else
                          roomSouth=null;
                      }
                    if (roomWest != null)
                      {
                      /* link to the room to the west */
                        passage=new Passage();
                        passage.room1=room;
                        passage.room2=roomWest;
                        room.passage[3]=passage;
                        roomWest.passage[2]=passage;
                        if (roomWest.passage[4] != null)
                          if (roomWest.passage[4].room1
                           == roomWest)
                            roomWest=roomWest.passage[4].
                             room2;
                          else
                            roomWest=roomWest.passage[4].
                             room1;
                        else
                          roomWest=null;
                       }
                    /* If this is the first room, connect it to the entrance. */
                    if ((nX == nXFirstRoom)
                    &&  (nY == nYFirstRoom)
                    &&  (nZ == nZFirstRoom))
                      {
                        passage=new Passage();
                        passage.bBlocked=false;
                        passage.room1=room;
                        passage.room2=m_roomEntrance;
                        room.passage[3]=passage;
                        m_roomEntrance.passage[2]
                         =passage;
                      }
                    roomDown=room;
                  }
                if (roomWestBase != null)
                  {
                    if (roomWestBase.passage[0] != null)
                      {
                        if (roomWestBase.passage[0].room1
                         == roomWestBase)
                          roomWestBase
                           =roomWestBase.passage[0].room2;
                        else
                          roomWestBase
                           =roomWestBase.passage[0].room1;
                      }
                  }
              }
            roomWestBase=roomWestBaseBase;
          }
        nChokepoint=-1;
        nTreasure=0;
        room=m_roomEntrance;
        nRoom=0;
        while (nRoom < m_nRooms)
          {
            nDirection1=RandomNumber()%6;
            nDirectionOpposite=m_nDirectionOpposite[nDirection1];
            nDistance=RandomNumber()%3+1;
            nStep=0;
            while ((room.passage[nDirection1] != null)
            &&     (nStep < nDistance))
              {
                passage=room.passage[nDirection1];
                if (passage.room1 == room)
                  roomNext=passage.room2;
                else
                  roomNext=passage.room1;
                if (passage.bBlocked)
                  if ((roomNext.nChokepoint == nChokepoint)
                  ||  (! roomNext.bMined))
                    {
                      room=roomNext;
                      room.bMined=true;
                      room.nChokepoint=nChokepoint;
                      passage.bBlocked=false;
                      if (room.strDescription != null)
                        ++nStep;
                      else
                        {
                          nUnblocked=0;
                          for (nDirection2=6;
                           ((nUnblocked < 2) && (nDirection2-- > 0));)
                            if (nDirection2 != nDirectionOpposite)
                              if (room.passage[nDirection2] != null)
                                if (! room.passage[nDirection2].bBlocked)
                                  ++nUnblocked;
                          if (nUnblocked < 2)
                            ++nStep;
                          else
                            nStep=nDistance;
                        }
                    }
                  else
                    nStep=nDistance;
                else
                  {
                    ++nStep;
                    room=roomNext;
                    nChokepoint=room.nChokepoint;
                  }
              }
            if (nStep != 0)
              {
                if (room.strDescription == null)
                  {
                    room.strDescription=m_strRoom[nRoom];
                    nDirection1=0;
                    nUnblocked=0;
                    for (nDirection2=6;
                     ((nUnblocked < 2) && (nDirection2-- > 0));)
                      if (room.passage[nDirection2] != null)
                        if (! room.passage[nDirection2].bBlocked)
                          {
                            nDirection1=nDirection2;
                            ++nUnblocked;
                          }
                    if (nUnblocked == 1)
                      {
                        if ((m_nRooms-nRoom)*RandomNumber()
                         < 32768*(m_nTreasures-nTreasure))
                          {
                            nChokepoint=nTreasure;
                            room.passage[nDirection1].
                             treasureGuardian=m_treasure[nTreasure];
                            ++nTreasure;
                          }
                      }
                    room.nChokepoint=nChokepoint;
                    m_roomWithName[nRoom]=room;
                    ++nRoom;
                  }
              }
          }
        m_roomWithName[nRoom]=m_roomEntrance;
        m_nChokepoints=nTreasure;
        return;
      }

    private void HideTreasuresAndWeapons()
      {
        boolean bChokepointFound;
        int     nRoom;
        int     nTreasure;

        for (nTreasure=0; nTreasure < m_nTreasures; ++nTreasure)
          {
            bChokepointFound=false;
            nRoom=0;
            while ((! bChokepointFound) && (nRoom < m_nRooms))
              if (m_roomWithName[nRoom].nChokepoint == nTreasure)
                bChokepointFound=true;
              else
                ++nRoom;
            if (bChokepointFound)
              {
                do
                  nRoom=RandomNumber()%m_nRooms;
                while (m_roomWithName[nRoom].nChokepoint != nTreasure);
                m_treasure[nTreasure].roomTreasure=m_roomWithName[nRoom];
                do
                  nRoom=RandomNumber()%(m_nRooms+1);
                while (m_roomWithName[nRoom].nChokepoint >= nTreasure);
                m_treasure[nTreasure].roomWeapon=m_roomWithName[nRoom];
              }
            else
              {
                nRoom=RandomNumber()%m_nRooms;
                m_treasure[nTreasure].roomTreasure=m_roomWithName[nRoom];
                m_treasure[nTreasure].roomWeapon=m_roomWithName[m_nRooms];
              }
          }
        return;
      }

    private void ListPassages()
      {
        char     cFirstChar;
        int      nDirection;
        Room     roomAlongPassage;
        Treasure treasure;
        String   strDescription;

        m_buttonNorth.setEnabled(false);
        m_buttonSouth.setEnabled(false);
        m_buttonEast.setEnabled(false);
        m_buttonWest.setEnabled(false);
        m_buttonUp.setEnabled(false);
        m_buttonDown.setEnabled(false);
        for (nDirection=0; nDirection < 6; ++nDirection)
          if ((m_room.passage[nDirection] != null)
          &&  (! m_room.passage[nDirection].bBlocked))
            switch (nDirection)
              {
                case 0:
                  m_buttonNorth.setEnabled(true);
                  break;
                case 1:
                  m_buttonSouth.setEnabled(true);
                  break;
                case 2:
                  m_buttonEast.setEnabled(true);
                  break;
                case 3:
                  m_buttonWest.setEnabled(true);
                  break;
                case 4:
                  m_buttonUp.setEnabled(true);
                  break;
                default:
                  m_buttonDown.setEnabled(true);
                  break;
              }
        for (nDirection=0; nDirection < 6; ++nDirection)
          {
            strDescription=null;
            roomAlongPassage=m_room;
            while ((roomAlongPassage.passage[nDirection] != null)
            &&     (! roomAlongPassage.passage[nDirection].bBlocked)
            &&     (strDescription == null))
              {
                if ((treasure=roomAlongPassage.passage[
                 nDirection].treasureGuardian) != null)
                  {
                    m_textLocation.append(m_strSpace);
                    m_textLocation.append(m_strSpace);
                    m_textLocation.append(m_strThePassage);
                    m_textLocation.append(m_strSpace);
                    m_textLocation.append(m_strDirection[nDirection]);
                    m_textLocation.append(m_strSpace);
                    m_textLocation.append(m_strIsGuardedBy);
                    m_textLocation.append(m_strSpace);
                    cFirstChar=treasure.strGuardian.charAt(0);
                  if (m_strVowels.indexOf(cFirstChar) >= 0)
                    m_textLocation.append(m_strLowerSingleBeforeVowel);
                  else
                    m_textLocation.append(m_strLowerSingle);
                    m_textLocation.append(m_strSpace);
                    m_textLocation.append(treasure.strGuardian);
                    m_textLocation.append(m_strPeriod);
                  }
                if (roomAlongPassage.passage[nDirection].room1
                 == roomAlongPassage)
                  roomAlongPassage
                   =roomAlongPassage.passage[nDirection].room2;
                else
                  roomAlongPassage
                   =roomAlongPassage.passage[nDirection].room1;
                strDescription=roomAlongPassage.strDescription;
              }
          }
        return;
      }

    private void ListTreasuresAndWeapons()
      {
        char cFirstChar;
        int  nItem;
        int  nItems;
        int  nTreasure;

        nItems=0;
        for (nTreasure=m_nTreasures; nTreasure-- > 0;)
          {
            if (m_treasure[nTreasure].roomTreasure == m_room)
              ++nItems;
            if (m_treasure[nTreasure].roomWeapon == m_room)
              ++nItems;
          }
        if (nItems > 0)
          {
            m_buttonCarry.setEnabled(true);
            nItem=0;
            for (nTreasure=m_nTreasures; nTreasure-- > 0;)
              {
                if (m_treasure[nTreasure].roomTreasure == m_room)
                  {
                    cFirstChar=m_treasure[nTreasure].strWeapon.charAt(0);
                    ++nItem;
                    if (nItem < nItems)
                      {
                        if (nItem == 1)
                          {
                            m_textLocation.append(m_strSpace);
                            m_textLocation.append(m_strSpace);
                            if (m_strVowels.indexOf(cFirstChar) >= 0)
                              m_textLocation.append(m_strUpperSingleBeforeVowel);
                            else
                              m_textLocation.append(m_strUpperSingle);
                          }
                        else
                          if (m_strVowels.indexOf(cFirstChar) >= 0)
                            m_textLocation.append(m_strLowerSingleBeforeVowel);
                          else
                            m_textLocation.append(m_strLowerSingle);
                        m_textLocation.append(m_strSpace);
                        m_textLocation.append(m_treasure[nTreasure].strTreasure);
                        if (nItems != 2)
                          m_textLocation.append(m_strComma);
                        m_textLocation.append(m_strSpace);
                      }
                    else
                      {
                        if (nItems > 1)
                          {
                            m_textLocation.append(m_strAnd);
                            m_textLocation.append(m_strSpace);
                            if (m_strVowels.indexOf(cFirstChar) >= 0)
                              m_textLocation.append(m_strLowerSingleBeforeVowel);
                            else
                              m_textLocation.append(m_strLowerSingle);
                          }
                        else
                          {
                            m_textLocation.append(m_strSpace);
                            m_textLocation.append(m_strSpace);
                            if (m_strVowels.indexOf(cFirstChar) >= 0)
                              m_textLocation.append(m_strUpperSingleBeforeVowel);
                            else
                              m_textLocation.append(m_strUpperSingle);
                          }
                        m_textLocation.append(m_strSpace);
                        m_textLocation.append(m_treasure[nTreasure].strTreasure);
                        m_textLocation.append(m_strSpace);
                        if (nItems > 1)
                          m_textLocation.append(m_strAreHere);
                        else
                          m_textLocation.append(m_strIsHere);
                        m_textLocation.append(m_strPeriod);
                      }
                  }
                if (m_treasure[nTreasure].roomWeapon == m_room)
                  {
                    cFirstChar=m_treasure[nTreasure].strWeapon.charAt(0);
                    ++nItem;
                    if (nItem < nItems)
                      {
                        if (nItem == 1)
                          {
                            m_textLocation.append(m_strSpace);
                            m_textLocation.append(m_strSpace);
                            if (m_strVowels.indexOf(cFirstChar) >= 0)
                              m_textLocation.append(m_strUpperSingleBeforeVowel);
                            else
                              m_textLocation.append(m_strUpperSingle);
                          }
                        else
                          if (m_strVowels.indexOf(cFirstChar) >= 0)
                            m_textLocation.append(m_strLowerSingleBeforeVowel);
                          else
                            m_textLocation.append(m_strLowerSingle);
                        m_textLocation.append(m_strSpace);
                        m_textLocation.append(m_treasure[nTreasure].strWeapon);
                        if (nItems != 2)
                          m_textLocation.append(m_strComma);
                        m_textLocation.append(m_strSpace);
                      }
                    else
                      {
                        if (nItems > 1)
                          {
                            m_textLocation.append(m_strAnd);
                            m_textLocation.append(m_strSpace);
                            if (m_strVowels.indexOf(cFirstChar) >= 0)
                              m_textLocation.append(m_strLowerSingleBeforeVowel);
                            else
                              m_textLocation.append(m_strLowerSingle);
                          }
                        else
                          {
                            m_textLocation.append(m_strSpace);
                            m_textLocation.append(m_strSpace);
                            if (m_strVowels.indexOf(cFirstChar) >= 0)
                              m_textLocation.append(m_strUpperSingleBeforeVowel);
                            else
                              m_textLocation.append(m_strUpperSingle);
                          }
                        m_textLocation.append(m_strSpace);
                        m_textLocation.append(m_treasure[nTreasure].strWeapon);
                        m_textLocation.append(m_strSpace);
                        if (nItems > 1)
                          m_textLocation.append(m_strAreHere);
                        else
                          m_textLocation.append(m_strIsHere);
                        m_textLocation.append(m_strPeriod);
                      }
                  }
              }
          }
        return;
      }

    private void UpdateScreen(boolean bSomethingAlreadyWritten)
      {
        boolean bTreasureHeld;
        int     nTreasure;

        if (! m_bRestoringState)
          {
            if (bSomethingAlreadyWritten)
              {
                m_textLocation.append(m_strSpace);
                m_textLocation.append(m_strSpace);
                m_textLocation.append(m_strYouAreIn);
              }
            else
              m_textLocation.setText(m_strYouAreIn);
            m_textLocation.append(m_strSpace);
            m_textLocation.append(m_room.strDescription);
            ListPassages();
            m_buttonCarry.setEnabled(false);
            ListTreasuresAndWeapons();
            bTreasureHeld=false;
            for (nTreasure=m_nTreasures; (! bTreasureHeld) && (nTreasure-- > 0);)
              bTreasureHeld=(m_treasure[nTreasure].roomTreasure == null);
            if (bTreasureHeld)
              m_buttonDrop.setEnabled(true);
            else
              m_buttonDrop.setEnabled(false);
          }
      }

    private void Move(int nDirection)
      {
        boolean bGuarded;
        boolean bSomethingWritten;
        Room    roomAlongPassage;
        String  strDescription;

        bSomethingWritten=false;
        if ((m_room.passage[nDirection] != null)
        &&  (! m_room.passage[nDirection].bBlocked))
          {
            bGuarded=false;
            strDescription=null;
            roomAlongPassage=m_room;
            while((roomAlongPassage.passage[nDirection] != null)
            &&    (strDescription == null))
              {
                if (roomAlongPassage.passage[nDirection].treasureGuardian
                 != null)
                  {
                    if (roomAlongPassage.passage[
                     nDirection].treasureGuardian.roomWeapon != null)
                      {
                        bGuarded=true;
                        if (! m_bRestoringState)
                          {
                            m_textLocation.setText(m_strYouCarryNothingToOvercomeThe);
                            m_textLocation.append(m_strSpace);
                            m_textLocation.append(roomAlongPassage.passage[
                             nDirection].treasureGuardian.strGuardian);
                            m_textLocation.append(m_strPeriod);
                          }
                        bSomethingWritten=true;
                      }
                    else
                      {
                        if (! m_bRestoringState)
                          {
                            m_textLocation.setText(m_strYour);
                            m_textLocation.append(m_strSpace);
                            m_textLocation.append(roomAlongPassage.passage[
                             nDirection].treasureGuardian.strWeapon);
                            m_textLocation.append(m_strSpace);
                            m_textLocation.append(m_strOvercomesThe);
                            m_textLocation.append(m_strSpace);
                            m_textLocation.append(roomAlongPassage.passage[
                             nDirection].treasureGuardian.strGuardian);
                            m_textLocation.append(m_strPeriod);
                          }
                        bSomethingWritten=true;
                        roomAlongPassage.passage[
                         nDirection].treasureGuardian.bSlain=true;
                        roomAlongPassage.passage[
                         nDirection].treasureGuardian=null;
                      }
                  }
                if (roomAlongPassage.passage[nDirection].room1
                 == roomAlongPassage)
                  roomAlongPassage=roomAlongPassage.passage[nDirection].room2;
                else
                  roomAlongPassage=roomAlongPassage.passage[nDirection].room1;
                strDescription=roomAlongPassage.strDescription;
              }
            if (! bGuarded)
              {
                ++m_nMoves;
                roomAlongPassage.bVisited=true;
                m_room=roomAlongPassage;
              }
          }
        else
          {
            if (! m_bRestoringState)
              m_textLocation.setText(m_strYouCannotGoThatWay);
            bSomethingWritten=true;
          }
        UpdateScreen(bSomethingWritten);
        return;
      }

    private void FindPathToEntrance(
     Room roomStart,
     Room roomEntrance)
      {
        boolean                 bReenter;
        boolean                 bResume;
        Character               c;
        int                     nReturnAddress;
        FindPathLocalsStack     findPathLocalsStack;
        FindPathLocalsStack     findPathLocalsStackHead;
        FindPathParametersStack findPathParametersStack;
        FindPathParametersStack findPathParametersStackHead;
        int                     nIterations;
        PathStack               pathStackHead;

        findPathLocalsStack=null;
        findPathLocalsStackHead=null;
        findPathParametersStack=null;
        findPathParametersStackHead=null;
        findPathParametersStack=new FindPathParametersStack();
        findPathParametersStack.findPathParametersStackNext
         =findPathParametersStackHead;
        findPathParametersStack.room=roomStart;
        findPathParametersStack.nDirectionUsedToEnterRoom=0;
        findPathParametersStack.nReturnAddress=0;
        findPathParametersStackHead=findPathParametersStack;
        pathStackHead=null;
        bResume=false;
        nIterations=0;
        do
          {
            ++nIterations;
            bReenter=false;
            if (bResume)
              {
                for (;((! bReenter) && (m_strWayOut == null) && ((findPathLocalsStackHead.nDirection1) > 0));)
                  {
                    --(findPathLocalsStackHead.nDirection1);
                    findPathLocalsStackHead.nDirection2=(findPathLocalsStackHead.nDirectionRandom)[findPathLocalsStackHead.nDirection1];
                    if (findPathParametersStackHead.room.passage[findPathLocalsStackHead.nDirection2] != null)
                      {
                        if (! findPathParametersStackHead.room.passage[findPathLocalsStackHead.nDirection2].bBlocked)
                          {
                            if (findPathParametersStackHead.room.passage[findPathLocalsStackHead.nDirection2].room1 == findPathParametersStackHead.room)
                              {
                                findPathParametersStack=new FindPathParametersStack();
                                findPathParametersStack.findPathParametersStackNext=findPathParametersStackHead;
                                findPathParametersStack.room=findPathParametersStackHead.room.passage[findPathLocalsStackHead.nDirection2].room2;
                                findPathParametersStack.nDirectionUsedToEnterRoom=findPathLocalsStackHead.nDirection2;
                                findPathParametersStack.nReturnAddress=1;
                                findPathParametersStackHead=findPathParametersStack;
                                bReenter=true;
                              }
                            else
                              {
                                findPathParametersStack=new FindPathParametersStack();
                                findPathParametersStack.findPathParametersStackNext=findPathParametersStackHead;
                                findPathParametersStack.room=findPathParametersStackHead.room.passage[findPathLocalsStackHead.nDirection2].room1;
                                findPathParametersStack.nDirectionUsedToEnterRoom=findPathLocalsStackHead.nDirection2;
                                findPathParametersStack.nReturnAddress=1;
                                findPathParametersStackHead=findPathParametersStack;
                                bReenter=true;
                              }
                          }
                      }
                  }
                if (! bReenter)
                  {
                    pathStackHead=findPathLocalsStackHead.pathStack.pathStackNext;
                    findPathLocalsStackHead.pathStack=null;
                    findPathLocalsStack=findPathLocalsStackHead;
                    findPathLocalsStackHead=findPathLocalsStack.findPathLocalsStackNext;
                    findPathLocalsStack=null;
                  }
              }
            else
              bReenter=true;
            if (bReenter)
              do
                {
                  bReenter=false;
                  findPathLocalsStack=new FindPathLocalsStack();
                  findPathLocalsStack.findPathLocalsStackNext=findPathLocalsStackHead;
                  findPathLocalsStackHead=findPathLocalsStack;
                  if (findPathParametersStackHead.room == roomEntrance)
                    {
                      findPathLocalsStackHead.pathStack=pathStackHead;
                      while (findPathLocalsStackHead.pathStack != null)
                        {
                          findPathLocalsStackHead.pathStack=findPathLocalsStackHead.pathStack.pathStackNext;
                        }
                      c=m_strDirectionLetters.charAt(findPathParametersStackHead.nDirectionUsedToEnterRoom);
                      m_strWayOut=c.toString();
                      findPathLocalsStackHead.pathStack=pathStackHead;
                      while (findPathLocalsStackHead.pathStack != null)
                        {
                          if (findPathLocalsStackHead.pathStack.pathStackNext != null)
                            {
                              if (findPathLocalsStackHead.pathStack.room.strDescription != null)
                                {
                                  c=m_strDirectionLetters.charAt(findPathLocalsStackHead.pathStack.nDirectionUsedToEnterRoom);
                                  m_strWayOut=c.toString()+m_strWayOut;
                                }
                            }
                          findPathLocalsStackHead.pathStack=findPathLocalsStackHead.pathStack.pathStackNext;
                        }
                    }
                  else
                    {
                      findPathLocalsStackHead.bRoomAlreadyInStack=false;
                      findPathLocalsStackHead.pathStack=pathStackHead;
                      while ((findPathLocalsStackHead.pathStack != null) && (! (findPathLocalsStackHead.bRoomAlreadyInStack)))
                        {
                          findPathLocalsStackHead.bRoomAlreadyInStack=(findPathLocalsStackHead.pathStack.room == findPathParametersStackHead.room);
                          findPathLocalsStackHead.pathStack=findPathLocalsStackHead.pathStack.pathStackNext;
                        }
                      if (! (findPathLocalsStackHead.bRoomAlreadyInStack))
                        {
                          findPathLocalsStackHead.pathStack=new PathStack();
                          findPathLocalsStackHead.pathStack.room=findPathParametersStackHead.room;
                          findPathLocalsStackHead.pathStack.nDirectionUsedToEnterRoom=findPathParametersStackHead.nDirectionUsedToEnterRoom;
                          findPathLocalsStackHead.pathStack.pathStackNext=pathStackHead;
                          pathStackHead=findPathLocalsStackHead.pathStack;
                          for (findPathLocalsStackHead.nDirection1=6; (findPathLocalsStackHead.nDirection1)-- > 0;)
                            (findPathLocalsStackHead.nDirectionRandom)[findPathLocalsStackHead.nDirection1]=findPathLocalsStackHead.nDirection1;
                          for (findPathLocalsStackHead.nDirection1=5; findPathLocalsStackHead.nDirection1 > 0; --(findPathLocalsStackHead.nDirection1))
                            {
                              findPathLocalsStackHead.nDirection2=RandomNumber()%(findPathLocalsStackHead.nDirection1+1);
                              findPathLocalsStackHead.nDirection3=(findPathLocalsStackHead.nDirectionRandom)[findPathLocalsStackHead.nDirection1];
                              (findPathLocalsStackHead.nDirectionRandom)[findPathLocalsStackHead.nDirection1]=(findPathLocalsStackHead.nDirectionRandom)[findPathLocalsStackHead.nDirection2];
                              (findPathLocalsStackHead.nDirectionRandom)[findPathLocalsStackHead.nDirection2]=findPathLocalsStackHead.nDirection3;
                            }
                          for (findPathLocalsStackHead.nDirection1=6; ((! bReenter) && (m_strWayOut == null) && ((findPathLocalsStackHead.nDirection1) > 0));)
                            {
                              --(findPathLocalsStackHead.nDirection1);
                              findPathLocalsStackHead.nDirection2=(findPathLocalsStackHead.nDirectionRandom)[findPathLocalsStackHead.nDirection1];
                              if (findPathParametersStackHead.room.passage[findPathLocalsStackHead.nDirection2] != null)
                                {
                                  if (! findPathParametersStackHead.room.passage[findPathLocalsStackHead.nDirection2].bBlocked)
                                    {
                                      if (findPathParametersStackHead.room.passage[findPathLocalsStackHead.nDirection2].room1 == findPathParametersStackHead.room)
                                        {
                                          findPathParametersStack=new FindPathParametersStack();
                                          findPathParametersStack.findPathParametersStackNext=findPathParametersStackHead;
                                          findPathParametersStack.room=findPathParametersStackHead.room.passage[findPathLocalsStackHead.nDirection2].room2;
                                          findPathParametersStack.nDirectionUsedToEnterRoom=findPathLocalsStackHead.nDirection2;
                                          findPathParametersStack.nReturnAddress=1;
                                          findPathParametersStackHead=findPathParametersStack;
                                          bReenter=true;
                                        }
                                      else
                                        {
                                          findPathParametersStack=new FindPathParametersStack();
                                          findPathParametersStack.findPathParametersStackNext=findPathParametersStackHead;
                                          findPathParametersStack.room=findPathParametersStackHead.room.passage[findPathLocalsStackHead.nDirection2].room1;
                                          findPathParametersStack.nDirectionUsedToEnterRoom=findPathLocalsStackHead.nDirection2;
                                          findPathParametersStack.nReturnAddress=1;
                                          findPathParametersStackHead=findPathParametersStack;
                                          bReenter=true;
                                        }
                                    }
                                }
                            }
                          if (! bReenter)
                            {
                              pathStackHead=findPathLocalsStackHead.pathStack.pathStackNext;
                              findPathLocalsStackHead.pathStack=null;
                            }
                        }
                    }
                  if (! bReenter)
                    {
                      findPathLocalsStack=findPathLocalsStackHead;
                      findPathLocalsStackHead=findPathLocalsStack.findPathLocalsStackNext;
                      findPathLocalsStack=null;
                    }
                }
              while (bReenter);
            nReturnAddress=findPathParametersStackHead.nReturnAddress;
            findPathParametersStack=findPathParametersStackHead;
            findPathParametersStackHead=findPathParametersStack.findPathParametersStackNext;
            findPathParametersStack=null;
            bResume=true;
          }
        while ((nReturnAddress != 0) && (nIterations < 1000));
        return;
      }

    private void buttonQuitClicked()
      {
        finish();
      }

    private void buttonAboutClicked()
      {
        m_sbCommands.append("A");
        if (! m_bRestoringState)
          m_textLocation.setText(m_strAbout);
        UpdateScreen(true);
      }

    private void buttonMineNumberOkClicked()
      {
        m_sbCommands.append("X");
        m_textObjective.setVisibility(View.INVISIBLE);
        m_buttonGo.setVisibility(View.INVISIBLE);
        m_editMineNumber.setEnabled(false);
        m_roomEntrance=new Room();
        m_roomEntrance.strDescription=new String(m_strEntranceToTheMine);
        m_roomEntrance.bMined=true;
        m_roomEntrance.bVisited=true;
        if (! m_bRestoringState)
          m_strMineNumber=m_editMineNumber.getText().toString();
        SeedRandomNumberGenerator(m_strMineNumber);
        ShuffleRoomDescriptions();
        m_treasure=new Treasure [m_nTreasures];
        for (int nTreasure=m_nTreasures; nTreasure-- > 0;)
          m_treasure[nTreasure]=new Treasure(m_strTreasure[nTreasure],
           m_strGuardian[nTreasure],m_strWeapon[nTreasure]);
        m_nChokepoints=0;
        m_roomWithName=new Room [m_nRooms+1];
        ExcavateMine();
        HideTreasuresAndWeapons();
        m_nMoves=0;
        m_room=m_roomEntrance;
        UpdateScreen(false);
        m_textLocation.setVisibility(View.VISIBLE);
        m_buttonWest.setVisibility(View.VISIBLE);
        m_buttonEast.setVisibility(View.VISIBLE);
        m_buttonNorth.setVisibility(View.VISIBLE);
        m_buttonSouth.setVisibility(View.VISIBLE);
        m_buttonUp.setVisibility(View.VISIBLE);
        m_buttonDown.setVisibility(View.VISIBLE);
        m_buttonCarry.setVisibility(View.VISIBLE);
        m_buttonDrop.setVisibility(View.VISIBLE);
        m_buttonInventory.setVisibility(View.VISIBLE);
        m_buttonWayOut.setVisibility(View.VISIBLE);
        m_buttonScore.setVisibility(View.VISIBLE);
        m_buttonAbout.setVisibility(View.VISIBLE);
        m_buttonQuit.setVisibility(View.VISIBLE);
        InputMethodManager imm=(InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(m_editMineNumber.getWindowToken(),0);
      }

    private void buttonInventoryClicked()
      {
        char c;
        int  nItem;
        int  nItems;
        int  nTreasure;

        m_sbCommands.append("I");
        nItems=0;
        for (nTreasure=m_nTreasures; nTreasure-- > 0;)
          if (m_treasure[nTreasure].roomTreasure == null)
            ++nItems;
        for (nTreasure=m_nChokepoints; nTreasure-- > 0;)
          if ((m_treasure[nTreasure].roomWeapon == null) && (! m_treasure[nTreasure].bSlain))
            ++nItems;
        if (nItems == 0)
          m_textLocation.setText(m_strYouAreNotCarryingAnything);
        else
          {
            m_textLocation.setText(m_strYouAreCarrying);
            m_textLocation.append(m_strSpace);
            nItem=0;
            for (nTreasure=m_nTreasures; nTreasure-- > 0;)
              if (m_treasure[nTreasure].roomTreasure == null)
                {
                  ++nItem;
                  if (nItem == nItems)
                    {
                      if (nItems > 1)
                        {
                          m_textLocation.append(m_strAnd);
                          m_textLocation.append(m_strSpace);
                        }
                    }
                  c=m_treasure[nTreasure].strTreasure.charAt(0);
                  if (m_strVowels.indexOf(c) >= 0)
                    m_textLocation.append(m_strLowerSingleBeforeVowel);
                  else
                    m_textLocation.append(m_strLowerSingle);
                  m_textLocation.append(m_strSpace);
                  m_textLocation.append(m_treasure[nTreasure].strTreasure);
                  if (nItem == nItems)
                    m_textLocation.append(m_strPeriod);
                  else
                    {
                      if (nItems > 2)
                        m_textLocation.append(m_strComma);
                      m_textLocation.append(m_strSpace);
                    }
                }
            for (nTreasure=m_nChokepoints; nTreasure-- > 0;)
              if ((m_treasure[nTreasure].roomWeapon == null) && (! m_treasure[nTreasure].bSlain))
                {
                  ++nItem;
                  if (nItem == nItems)
                    {
                      if (nItems > 1)
                        {
                          m_textLocation.append(m_strAnd);
                          m_textLocation.append(m_strSpace);
                        }
                    }
                  c=m_treasure[nTreasure].strWeapon.charAt(0);
                  if (m_strVowels.indexOf(c) >= 0)
                    m_textLocation.append(m_strLowerSingleBeforeVowel);
                  else
                    m_textLocation.append(m_strLowerSingle);
                  m_textLocation.append(m_strSpace);
                  m_textLocation.append(m_treasure[nTreasure].strWeapon);
                  if (nItem == nItems)
                    m_textLocation.append(m_strPeriod);
                  else
                    {
                      if (nItems > 2)
                        m_textLocation.append(m_strComma);
                      m_textLocation.append(m_strSpace);
                    }
                }
          }
        UpdateScreen(true);
        return;
      }

    private void buttonWayOutClicked()
      {
        boolean bCarryingTreasure;
        int     nRoom;
        int     nTreasure;

        m_sbCommands.append("O");
        if (m_room == m_roomEntrance)
          {
            if (! m_bRestoringState)
              m_textLocation.setText(m_strNothingHappens);
          }
        else
          {
            bCarryingTreasure=false;
            for (nTreasure=m_nTreasures;
             ((! bCarryingTreasure) && (nTreasure-- > 0));)
              bCarryingTreasure=(m_treasure[nTreasure].roomTreasure == null);
            if (bCarryingTreasure)
              {
                m_strWayOut=null;
                FindPathToEntrance(m_room,m_roomEntrance);
                if (m_strWayOut == null)
                  {
                    if (! m_bRestoringState)
                      m_textLocation.setText(m_strNothingHappens);
                  }
                else
                  {
                    do
                      nRoom=RandomNumber()%m_nRooms;
                    while (m_roomWithName[nRoom] == m_room);
                    m_treasure[nTreasure].roomTreasure=m_roomWithName[nRoom];
                    if (! m_bRestoringState)
                      {
                        m_textLocation.setText(
                         m_strThePirateTakesOneOfYourTreasures);
                        m_textLocation.append(m_strSpace);
                        m_textLocation.append(m_strSpace);
                        if (m_strWayOut.length() == 1)
                          m_textLocation.append(
                           m_strAsHeLeavesHeShoutsTheLetter);
                        else
                          m_textLocation.append(
                           m_strAsHeLeavesHeShoutsTheLetters);
                        m_textLocation.append(m_strWayOut);
                        m_textLocation.append(m_strQuote);
                        m_textLocation.append(m_strPeriod);
                      }
                  }
              }
            else
              {
                if (! m_bRestoringState)
                  m_textLocation.setText(m_strNothingHappens);
              }
          }
        UpdateScreen(true);
      }

    private void buttonScoreClicked()
      {
        Integer integerMoves;
        Integer integerRooms;
        Integer integerRoomsVisited;
        Integer integerScore;
        Integer integerTreasures;
        Integer integerTreasuresCarried;
        Integer integerTreasuresRecovered;
        int     nRoom;
        int     nRoomsVisited;
        int     nScore;
        int     nTreasure;
        int     nTreasuresCarried;
        int     nTreasuresRecovered;

        m_sbCommands.append("P");
        integerRooms=new Integer(m_nRooms+1);
        nScore=0;
        nTreasuresRecovered=0;
        nTreasuresCarried=0;
        nRoomsVisited=0;
        for (nRoom=0; nRoom <= m_nRooms; ++nRoom)
          if (m_roomWithName[nRoom].bVisited)
            ++nRoomsVisited;
        integerRoomsVisited=new Integer(nRoomsVisited);
        integerMoves=new Integer(m_nMoves);
        m_textLocation.setText(m_strYouHaveMoved);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(integerMoves.toString());
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strTimesToVisit);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(integerRoomsVisited.toString());
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strOf);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(integerRooms.toString());
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strLocations);
        integerTreasures=new Integer(m_nTreasures);
        for (nTreasure=m_nTreasures; nTreasure-- > 0;)
          if (m_treasure[nTreasure].roomTreasure == null)
            ++nTreasuresCarried;
        integerTreasuresCarried=new Integer(nTreasuresCarried);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strYouHold);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(integerTreasuresCarried.toString());
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strOf);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(integerTreasures.toString());
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strTreasures);
        for (nTreasure=m_nTreasures; nTreasure-- > 0;)
          if (m_treasure[nTreasure].roomTreasure == m_roomEntrance)
            ++nTreasuresRecovered;
        integerTreasuresRecovered=new Integer(nTreasuresRecovered);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strYouHaveReturned);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(integerTreasuresRecovered.toString());
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strOf);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(integerTreasures.toString());
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strTreasuresToTheEntranceOfTheMine);
        nScore=25*nRoomsVisited/(m_nRooms+1)+75*nTreasuresRecovered/m_nTreasures+45*nTreasuresCarried/m_nTreasures;
        if (m_nMoves > 5*m_nRooms)
          {
            nScore=nScore-m_nMoves/(5*m_nRooms);
            if (nScore < 0)
              nScore=0;
          }
        integerScore=new Integer(nScore);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strYouHaveScored);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(integerScore.toString());
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strOf100Points);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strSpace);
        m_textLocation.append(m_strYourScoreRanksYouAs);
        m_textLocation.append(m_strSpace);
        if (nScore < 25)
          m_textLocation.append(m_strABeginner);
        else if (nScore < 50)
          m_textLocation.append(m_strANoviceAdventurer);
        else if (nScore < 75)
          m_textLocation.append(m_strASeasonedExplorer);
        else if (nScore < 100)
          m_textLocation.append(m_strAGrizzlyOldProspector);
        else
          m_textLocation.append(m_strAnExpertTreasureHunter);
        m_textLocation.append(m_strPeriod);
        UpdateScreen(true);
        return;
      }

    private void buttonDropClicked()
      {
        m_sbCommands.append("L");
        for (int nTreasure=m_nTreasures; nTreasure-- > 0;)
          if (m_treasure[nTreasure].roomTreasure == null)
            m_treasure[nTreasure].roomTreasure=m_room;
        m_buttonDrop.setEnabled(false);
        UpdateScreen(false);
      }

    private void buttonCarryClicked()
      {
        int nTreasure;

        m_sbCommands.append("C");
        for (nTreasure=m_nTreasures; nTreasure-- > 0;)
          {
            if (m_treasure[nTreasure].roomWeapon == m_room)
              m_treasure[nTreasure].roomWeapon=null;
            if (m_treasure[nTreasure].roomTreasure == m_room)
              m_treasure[nTreasure].roomTreasure=null;
          }
        m_buttonCarry.setEnabled(false);
        UpdateScreen(false);
      }

    private void buttonUpClicked()
      {
        m_sbCommands.append("U");
        Move(4);
      }

    private void buttonEastClicked()
      {
        m_sbCommands.append("E");
        Move(2);
      }

    private void buttonNorthClicked()
      {
        m_sbCommands.append("N");
        Move(0);
      }

    private void buttonWestClicked()
      {
        m_sbCommands.append("W");
        Move(3);
      }

    private void buttonDownClicked()
      {
        m_sbCommands.append("D");
        Move(5);
      }

    private void buttonSouthClicked()
      {
        m_sbCommands.append("S");
        Move(1);
      }

    public void onClick(View v)
      {
        if (v == m_buttonAbout)
          buttonAboutClicked();
        else if (v == m_buttonCarry)
          buttonCarryClicked();
        else if (v == m_buttonDown)
          buttonDownClicked();
        else if (v == m_buttonDrop)
          buttonDropClicked();
        else if (v == m_buttonEast)
          buttonEastClicked();
        else if (v == m_buttonGo)
          buttonMineNumberOkClicked();
        else if (v == m_buttonInventory)
          buttonInventoryClicked();
        else if (v == m_buttonQuit)
          buttonQuitClicked();
        else if (v == m_buttonScore)
          buttonScoreClicked();
        else if (v == m_buttonSouth)
          buttonSouthClicked();
        else if (v == m_buttonNorth)
          buttonNorthClicked();
        else if (v == m_buttonUp)
          buttonUpClicked();
        else if (v == m_buttonWayOut)
          buttonWayOutClicked();
        else if (v == m_buttonWest)
          buttonWestClicked();
        else;
      }

    private void ProcessCommand(
     char c)
      {
        switch (c)
          {
            case 'X':
              buttonMineNumberOkClicked();
              break;
            case 'N':
              buttonNorthClicked();
              break;
            case 'S':
              buttonSouthClicked();
              break;
            case 'E':
              buttonEastClicked();
              break;
            case 'W':
              buttonWestClicked();
              break;
            case 'U':
              buttonUpClicked();
              break;
            case 'D':
              buttonDownClicked();
              break;
            case 'C':
              buttonCarryClicked();
              break;
            case 'L':
              buttonDropClicked();
              break;
            case 'A':
              buttonAboutClicked();
              break;
            case 'O':
              buttonWayOutClicked();
              break;
            case 'I':
              if (! m_bRestoringState)
                buttonInventoryClicked();
              break;
            case 'P':
              if (! m_bRestoringState)
                buttonScoreClicked();
              break;
            default:
              break;
          }
      }
  }
