#  mkImages.tcl --
#
#     Generate the images
#
# SCCS: @(#) mkImages.tcl 1.5 97/12/23 19:16:52
#

source gimpClient.tcl

set htmldir /proj/tcl/ws/public_html
lappend auto_path [file join $htmldir libtml]
source $htmldir/.tml

gimpConnect $host $port

gimpSend {(load "sunscript1.scm")}
gimpSend "(set! sunscript-img-width $sunscript(imgWidth))"
gimpSend "(set! sunscript-img-height $sunscript(imgHeight))"
gimpSend "(set! sunscript-bevel-width $sunscript(bevelWidth))"

foreach item $sunscript(Order) {
    set label [lindex $sunscript($item) 1]
    set img1 $item.gif
    gimpSend "(script-fu-sunscript-button1 \"$label\" \"$img1\" 0)"
    puts [exec gifsicle -o $htmldir/images/menu/$img1 $img1]
    set img2 ${item}_on.gif
    gimpSend "(script-fu-sunscript-button1 \"$label\" \"$img2\" 1)"
    puts [exec gifsicle -o $htmldir/images/menu/$img2 $img2]
}

