/*
 * Decompiled with CFR 0.152.
 */
package tcl.regex;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class OroRegexpCmd
implements Command {
    private static final int OPT_INDICES = 0;
    private static final int OPT_NOCASE = 1;
    private static final int OPT_LAST = 2;
    private static final String[] validCmds = new String[]{"-indices", "-nocase", "--"};

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int objc = argv.length - 1;
        boolean noCase = false;
        boolean indices = false;
        boolean last = false;
        if (argv.length >= 3) {
            int currentObjIndex = 1;
            while (objc > 0 && !last && argv[currentObjIndex].toString().startsWith("-")) {
                int opt = TclIndex.get((Interp)interp, (TclObject)argv[currentObjIndex], (String[])validCmds, (String)"switch", (int)1);
                switch (opt) {
                    default: {
                        throw new TclException(interp, "RegexpCmd.cmdProc: bad option " + opt + " index to validCmds");
                    }
                    case 0: {
                        indices = true;
                        break;
                    }
                    case 1: {
                        noCase = true;
                        break;
                    }
                    case 2: {
                        last = true;
                        break;
                    }
                }
                --objc;
                ++currentObjIndex;
            }
            if (objc >= 2) {
                Pattern pattern1;
                String origStringArg;
                String patternArg = argv[currentObjIndex].toString();
                String stringArg = origStringArg = argv[currentObjIndex + 1].toString();
                currentObjIndex += 2;
                if (noCase) {
                    patternArg = patternArg.toLowerCase();
                    stringArg = origStringArg.toLowerCase();
                }
                Perl5Matcher L11 = new Perl5Matcher();
                Perl5Compiler L12 = new Perl5Compiler();
                try {
                    Perl5Compiler compiler = L12;
                    pattern1 = compiler.compile(patternArg);
                }
                catch (MalformedPatternException e) {
                    String msg = e.getMessage();
                    if (msg.equals("Unmatched parentheses.")) {
                        msg = "unmatched ()";
                    } else if (msg.equals("?+* follows nothing in expression")) {
                        msg = "?+* follows nothing";
                    }
                    throw new TclException(interp, "couldn't compile regular expression pattern: " + msg);
                }
                if (!L11.contains(stringArg, pattern1)) {
                    interp.setResult(0);
                } else {
                    MatchResult result = L11.getMatch();
                    interp.setResult(1);
                    int g = 0;
                    while (objc > 2) {
                        if (g >= result.groups()) break;
                        int start = result.beginOffset(g);
                        if (start != -1) {
                            int end = result.endOffset(g);
                            if (!indices) {
                                OroRegexpCmd.setMatchStringVar(interp, argv[currentObjIndex].toString(), start, end, origStringArg);
                            } else {
                                OroRegexpCmd.setMatchVar(interp, argv[currentObjIndex].toString(), start, end - 1);
                            }
                        } else if (!indices) {
                            OroRegexpCmd.setEmptyStringVar(interp, argv[currentObjIndex].toString());
                        } else {
                            OroRegexpCmd.setMatchVar(interp, argv[currentObjIndex].toString(), -1, -1);
                        }
                        ++g;
                        --objc;
                        ++currentObjIndex;
                    }
                }
                while (objc > 2) {
                    if (!indices) {
                        OroRegexpCmd.setEmptyStringVar(interp, argv[currentObjIndex].toString());
                    } else {
                        OroRegexpCmd.setMatchVar(interp, argv[currentObjIndex].toString(), -1, -1);
                    }
                    --objc;
                    ++currentObjIndex;
                }
                return;
            }
            throw new TclNumArgsException(interp, 1, argv, "?switches? exp string ?matchVar? ?subMatchVar subMatchVar ...?");
        }
        throw new TclNumArgsException(interp, 1, argv, "?switches? exp string ?matchVar? ?subMatchVar subMatchVar ...?");
    }

    public static boolean match(Interp interp, String stringArg, String patternArg) throws TclException {
        Pattern pattern1;
        Perl5Matcher L3 = new Perl5Matcher();
        Perl5Compiler L4 = new Perl5Compiler();
        try {
            Perl5Compiler compiler = L4;
            pattern1 = compiler.compile(patternArg);
        }
        catch (MalformedPatternException e) {
            String msg = e.getMessage();
            if (msg.equals("Unmatched parentheses.")) {
                msg = "unmatched ()";
            } else if (msg.equals("?+* follows nothing in expression")) {
                msg = "?+* follows nothing";
            }
            throw new TclException(interp, "couldn't compile regular expression pattern: " + msg);
        }
        if (patternArg.length() <= 0 || patternArg.charAt(0) != '^') {
            return L3.matches(stringArg, pattern1);
        }
        return L3.contains(stringArg, pattern1) && L3.getMatch().beginOffset(0) == 0;
    }

    private static void setMatchVar(Interp interp, String varName, int start, int end) throws TclException {
        try {
            TclObject indexPairObj = TclList.newInstance();
            TclList.append(interp, indexPairObj, TclInteger.newInstance((int)start));
            TclList.append(interp, indexPairObj, TclInteger.newInstance((int)end));
            interp.setVar(varName, indexPairObj, 0);
        }
        catch (TclException TclException0) {
            throw new TclException(interp, "couldn't set variable \"" + varName + "\"");
        }
    }

    private static void setMatchStringVar(Interp interp, String varName, int start, int end, String valueString) throws TclException {
        TclObject valueObj = start != -1 ? TclString.newInstance((String)valueString.substring(start, end)) : TclString.newInstance((String)"");
        try {
            interp.setVar(varName, valueObj, 0);
        }
        catch (TclException TclException0) {
            throw new TclException(interp, "couldn't set variable \"" + varName + "\"");
        }
    }

    private static void setEmptyStringVar(Interp interp, String varName) throws TclException {
        try {
            interp.setVar(varName, TclString.newInstance((String)""), 0);
        }
        catch (TclException TclException0) {
            throw new TclException(interp, "couldn't set variable \"" + varName + "\"");
        }
    }
}

