
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

#include <stream.h>
#include <ctype.h>
#include "hash_table.h"
#include "string_table.h"
#include "scan.h"
#include "tags.h"
#include "instr.h"
#include "inst_args.h"
#include "memory.h"
#include "basics.h"
#include "inst_table.h"

InstrType instr_types[] = {
#define NAMES
#define use(String,ID,Function,Arg1,Arg2,Arg3)\
  {String, ID, {Arg1,Arg2,Arg3}, &Function},
#include "instructions.h"
#undef use
#undef NAMES
  };
    
HashTable instr_ID;

void InstrType::fill(Instr& instr, char** p)
{
  instr.ID = ID;
  instr.exec = exec;
  instr.arg1 = instr_args[ArgType[0]]->fill(p[0]);
  instr.arg2 = instr_args[ArgType[1]]->fill(p[1]);
  instr.arg3 = instr_args[ArgType[2]]->fill(p[2]);
}
  
void InstrType::print(Instr& instr)
{
  cout << name << " ";
  instr_args[ArgType[0]]->print(instr.arg1); cout << " ";
  instr_args[ArgType[1]]->print(instr.arg2); cout << " ";
  instr_args[ArgType[2]]->print(instr.arg3); cout << "\n";
}

void init_instr_types(Scan& SC)
{
  for (int i = 0; i < LAST_INSTRUCTION; i++) 
    instr_ID.bind(SC.intern(instr_types[i].name), instr_types[i].ID);
}

 /*  what_to_update == ARG_LABEL or ARG_PROC */
void InstrType::update(Instr& instr, int what_to_update)
{
  Cell *arg[3];
  arg[0] = &(instr.arg1);
  arg[1] = &(instr.arg2);
  arg[2] = &(instr.arg3);
  for (int i = 0; i < 3; i++) {
    if (ArgType[i] == what_to_update)
      *arg[i] = instr_args[ArgType[i]]->update(*arg[i]);
  }
}
