(* Variables - Definition v3 pages 4,5 *)

(*
$File: Common/Var.sml $
$Date: 1992/08/19 14:48:07 $
$Revision: 1.15 $
$Locker: birkedal $
*)

(*$Var: IDENT VAR*)
functor Var(structure Ident: IDENT): VAR =
  struct
    type id     = Ident.id
    type longid = Ident.longid
    type strid  = Ident.strid

    datatype longvar = LONGVAR of longid

    fun mk_longvar longid = LONGVAR longid
    fun pr_longvar(LONGVAR longid) = Ident.pr_longid longid

    datatype var = VAR of id
    type KnownVal = var

    fun mkVar id = VAR id
    fun unVar(VAR id) = id

    fun pr_var (VAR id) = Ident.pr_id id

    fun unqualified(LONGVAR longid) = Ident.unqualified longid

    fun decompose(LONGVAR longid) =
      let
	val (strid_list,id) = Ident.decompose longid
      in
	(strid_list,VAR id)
      end

    val bogus = LONGVAR Ident.bogus
    val var_PRIM      = VAR Ident.id_PRIM
    val var_ABS       = VAR Ident.id_ABS 
    val var_NEG       = VAR Ident.id_NEG 
    val var_PLUS      = VAR Ident.id_PLUS
    val var_MINUS     = VAR Ident.id_MINUS
    val var_MUL       = VAR Ident.id_MUL
    val var_LESS      = VAR Ident.id_LESS 
    val var_GREATER   = VAR Ident.id_GREATER
    val var_LESSEQ    = VAR Ident.id_LESSEQ 
    val var_GREATEREQ = VAR Ident.id_GREATEREQ 

  end;
