/************************************************************************/
/*									*/
/*	Copyright Pittsburgh Supercomputing Center 1987, 1988, 1990	*/
/*	All Rights Reserved						*/
/*	Author Joel Welling						*/
/*			    						*/
/*      clip_test.c version 1.0                                         */
/*                                                                      */
/************************************************************************/

/*  This module recognizes what type of machine it's on by the presence
of the symbol VMS, unix, CRAY, or ardent.  The following makes the machine
assignment less ambiguous.
*/
#if (unix && (!CRAY && !ardent && !__hpux ))
#define USE_UNIX
#endif

#ifdef VMS
#include stdio                            
#include descrip
#include math
#else
#include <stdio.h>
#include <string.h>
#include <math.h>
#endif

/* Include defs files that allow linkage to Fortran on various systems */
#ifdef USE_UNIX
#include "unix_defs.h"
#endif
#ifdef CRAY
#include "unicos_defs.h"
#endif
#ifdef ardent
#include "unicos_defs.h"  /* these are also appropriate on Ardent Titan */
#endif

#define VCOUNT 39
#define PI 3.14159265

#define PVCOUNT 12
static float xpolygon[PVCOUNT]= { 0.4, 0.4, 0.1, 0.1, 0.9, 0.9, 0.6, 0.6, 
				  0.85, 0.85, 0.15, 0.15 };
static float ypolygon[PVCOUNT]= { 0.6, 0.4, 0.4, 0.9, 0.9, 0.4, 0.4, 0.6, 
				    0.6, 0.85, 0.85, 0.6 };
static int pvcount= PVCOUNT;

static float cur_theta= 0.0, cur_delta= -0.5;

static void project( xorig, yorig, xres, yres, npts )
float *xorig, *yorig, *xres, *yres;
int npts;
{
  int iloop;

#ifdef never
  for (iloop=0; iloop<npts; iloop++) {
    xres[iloop]= xorig[iloop]*cos(cur_theta) 
      + yorig[iloop]*sin(cur_theta);
    yres[iloop]= -xorig[iloop]*sin(cur_theta) 
      + yorig[iloop]-0.5*cos(cur_theta) + 0.5;
  }
#endif

#ifdef never
  for (iloop=0; iloop<npts; iloop++) {
    xres[iloop]= (xorig[iloop]-0.5)*cos(cur_theta) 
      + (yorig[iloop]-0.5)*sin(cur_theta) + 0.5;
    yres[iloop]= -(xorig[iloop]-0.5)*sin(cur_theta) 
      + (yorig[iloop]-0.5)*cos(cur_theta) + 0.5;
  }

#endif
  for (iloop=0; iloop<npts; iloop++) {
    xres[iloop]= xorig[iloop] - 2.0*cur_delta;
    yres[iloop]= yorig[iloop];
  }
}

static void step_params()
{
  cur_theta += PI/16.0;
  cur_delta += 1.0/16.0;
}

static void make_star(xarray,yarray)
float *xarray,*yarray;
{
  float x, y, r, theta, dtheta, x0, y0;
  int i;

  theta= 0.0;
  dtheta= 37.0*PI/(VCOUNT-1);
  r= 0.55;
  y0= 0.5;
  x0= 0.5;

  for (i=0; i<VCOUNT; i++) {
    xarray[i]= x0 + r*sin(theta);
    yarray[i]= y0 + r*cos(theta);
    theta += dtheta;
  }  
}

main()
{
  int i, ierr=0, junk, npts, ithree= 3, ione= 1, ifive= 5, itwo= 2;
  float zero= 0.0, one= 1.0, textx= 0.1, texty= 0.9, text2x= 0.5, text2y= 0.5;
  float xarray[VCOUNT],yarray[VCOUNT];
  float nxpgn[PVCOUNT],nypgn[PVCOUNT];

  fprintf(stderr,"This routine tests clipping- keep hitting return.\n");

  npts= VCOUNT;

  make_star(xarray,yarray);
  csetdev("cgmb",&ierr);    
  if (ierr) fprintf(stderr,"error on csetdev\n");
/*
  tgldbg(&ierr);
  if (ierr) fprintf(stderr,"error on tgldbg\n");
  clip_toggle_debug();
*/
  wrcopn("clip_test.cgmb",&ierr); 
  if (ierr) fprintf(stderr,"error on wrcopn\n");
  for (i=0; i<16; i++) {
    wrbegp(&ierr);
    if (ierr) fprintf(stderr,"error on wrbegp\n");
    wrbgpb(&ierr);
    if (ierr) fprintf(stderr,"error on wrbgpb\n");
    wristl(&ione,&ierr);
    if (ierr) fprintf(stderr,"error on wristl\n");
    wrttxt("Test routine",&textx, &texty, &ierr);
    if (ierr) fprintf(stderr,"error on wrttxt\n");

    wrpmkt(&ithree,&ierr);
    if (ierr) fprintf(stderr,"error on wrpmkt\n");

    clip_off();
    wrplnc(&ithree,&ierr);
    if (ierr) fprintf(stderr,"error on wrplnc\n");
    wrpmkc(&ithree,&ierr);
    if (ierr) fprintf(stderr,"error on wrpmkc\n");
    wrtpmk(xarray, yarray, &npts, &ierr);
    if (ierr) fprintf(stderr,"error %d on wrtpmk\n",ierr);
    wrplin(xarray, yarray, &npts, &ierr);
    if (ierr) fprintf(stderr,"error %d on wrplin\n",ierr);
    clip_on();
    wrplnc(&ione,&ierr);
    if (ierr) fprintf(stderr,"error on wrplnc\n");
    wrpmkc(&ione,&ierr);
    if (ierr) fprintf(stderr,"error on wrpmkc\n");
    wrplin(xarray, yarray, &npts, &ierr);
    if (ierr) fprintf(stderr,"error %d on wrplin\n",ierr);
    wrtpmk(xarray, yarray, &npts, &ierr);
    if (ierr) fprintf(stderr,"error %d on wrtpmk\n",ierr);

    wrpgnc(&ithree, &ierr);
    if (ierr) fprintf(stderr,"error on wrpgnc\n");
    project( xpolygon, ypolygon, nxpgn, nypgn, PVCOUNT );
    wrtpgn(nxpgn, nypgn, &pvcount, &ierr);
    if (ierr) fprintf(stderr,"error %d on wrtpgn\n",ierr);

    clip_on();
    wrpgnc(&ione, &ierr);
    if (ierr) fprintf(stderr,"error on wrpgnc\n");
    wrtpgn(nxpgn, nypgn, &pvcount, &ierr);
    if (ierr) fprintf(stderr,"error %d on wrtpgn\n",ierr);

    clip_off();
    wrtxtc(&ithree,&ierr);
    if (ierr) fprintf(stderr,"error on wrtxtc\n");
    text2y= 0.5 + cur_delta;
    wrttxt("hello", &text2x, &text2y, &ierr);
    if (ierr) fprintf(stderr,"error on wrttxt\n");
    
    clip_on();
    wrtxtc(&ione,&ierr);
    if (ierr) fprintf(stderr,"error on wrtxtc\n");
    text2y= 0.5 + cur_delta;
    wrttxt("hello", &text2x, &text2y, &ierr);
    if (ierr) fprintf(stderr,"error on wrttxt\n");
    
    wrendp(&ierr);
    if (ierr) fprintf(stderr,"error on wrendp\n");
    junk= getchar();
    step_params();
  }

  wrtend(&ierr);
  if (ierr) fprintf(stderr,"error on wrtend\n");
}
