/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.test.TestException;
import java.io.PrintWriter;

public abstract class BaseTest {
    protected PrintWriter out;
    protected int failures;
    protected int passes;
    protected int expectedPasses;

    protected BaseTest() {
    }

    protected void commandline(String[] stringArray) {
        this.out = new PrintWriter(System.out, true);
        try {
            this.test();
            return;
        }
        catch (TestException testException) {
            this.out.println(testException.getMessage());
            System.exit(testException.getErrorCode());
            return;
        }
    }

    protected void setOutput(PrintWriter printWriter) {
        this.out = printWriter;
    }

    protected void test() throws TestException {
        block13: {
            try {
                try {
                    this.passes = 0;
                    this.failures = 0;
                    this.expectedPasses = 1;
                    this.out.println("Start tests...\n");
                    this.engineTest();
                    this.out.println("\nDone tests...");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object var2_4 = null;
                this.report();
                if (this.failures <= 0 && this.passes >= this.expectedPasses) break block13;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                this.report();
                if (this.failures > 0 || this.passes < this.expectedPasses) {
                    try {
                        try {
                            this.out.println("(Debugging tests not written)");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    catch (Throwable throwable2) {}
                    if (this.passes == 0) {
                        throw new TestException(String.valueOf(this.getClass().getName()) + " failed completely", 1);
                    }
                    throw new TestException(String.valueOf(this.getClass().getName()) + " failed partially", 4);
                }
                throw throwable;
            }
            try {
                try {
                    this.out.println("(Debugging tests not written)");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Throwable throwable) {}
            if (this.passes == 0) {
                throw new TestException(String.valueOf(this.getClass().getName()) + " failed completely", 1);
            }
            throw new TestException(String.valueOf(this.getClass().getName()) + " failed partially", 4);
        }
    }

    protected void fail(String string) {
        ++this.failures;
        this.out.println(String.valueOf(string) + " - failed.\n");
    }

    protected void pass(String string) {
        ++this.passes;
        this.out.println(String.valueOf(string) + " - passed.\n");
    }

    protected void passIf(boolean bl, String string) {
        if (bl) {
            this.pass(string);
            return;
        }
        this.fail(string);
    }

    protected void setExpectedPasses(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        this.expectedPasses = n;
    }

    protected void report() {
        this.out.println("===========================================================================");
        this.out.println("Number of passes:   " + this.passes);
        this.out.println("Number of failures: " + this.failures);
        this.out.println("Expected passes:    " + (this.expectedPasses > 0 ? Integer.toString(this.expectedPasses) : "unknown"));
    }

    protected abstract void engineTest() throws Exception;
}

